/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.BasePositionHandler;
import org.traccar.model.Position;

public class TimeHandler
extends BasePositionHandler {
    private final boolean useServerTime;
    private final Set<String> protocols;

    @Inject
    public TimeHandler(Config config) {
        this.useServerTime = config.getString(Keys.TIME_OVERRIDE).equalsIgnoreCase("serverTime");
        String protocolList = config.getString(Keys.TIME_PROTOCOLS);
        this.protocols = protocolList != null ? new HashSet<String>(Arrays.asList(protocolList.split("[, ]"))) : null;
    }

    @Override
    public void handlePosition(Position position, BasePositionHandler.Callback callback) {
        if (this.protocols == null || this.protocols.contains(position.getProtocol())) {
            if (this.useServerTime) {
                position.setDeviceTime(position.getServerTime());
                position.setFixTime(position.getServerTime());
            } else {
                position.setFixTime(position.getDeviceTime());
            }
        }
        callback.processed(false);
    }
}

