/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class LCSParams
implements IParams {
    private boolean len = false;
    private boolean idx = false;
    private Long minMatchLen;
    private boolean withMatchLen = false;

    public static LCSParams LCSParams() {
        return new LCSParams();
    }

    public LCSParams len() {
        this.len = true;
        return this;
    }

    public LCSParams idx() {
        this.idx = true;
        return this;
    }

    public LCSParams minMatchLen(long minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public LCSParams withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.len) {
            args.add(Protocol.Keyword.LEN);
        }
        if (this.idx) {
            args.add(Protocol.Keyword.IDX);
        }
        if (this.minMatchLen != null) {
            args.add(Protocol.Keyword.MINMATCHLEN).add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args.add(Protocol.Keyword.WITHMATCHLEN);
        }
    }
}

