/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.firestore.v1.Precondition;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class Precondition {
    public static final Precondition NONE = new Precondition(null, null);
    private final Boolean exists;
    private final Timestamp updateTime;

    private Precondition(Boolean exists, Timestamp updateTime) {
        this.exists = exists;
        this.updateTime = updateTime;
    }

    @Nonnull
    static Precondition exists(Boolean exists) {
        return new Precondition(exists, null);
    }

    @Nonnull
    public static Precondition updatedAt(Timestamp updateTime) {
        return new Precondition(null, updateTime);
    }

    boolean isEmpty() {
        return this.exists == null && this.updateTime == null;
    }

    Boolean getExists() {
        return this.exists;
    }

    com.google.firestore.v1.Precondition toPb() {
        Precondition.Builder precondition = com.google.firestore.v1.Precondition.newBuilder();
        if (this.exists != null) {
            precondition.setExists(this.exists.booleanValue());
        }
        if (this.updateTime != null) {
            precondition.setUpdateTime(this.updateTime.toProto());
        }
        return precondition.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Precondition that = (Precondition)obj;
        return Objects.equals(this.exists, that.exists) && Objects.equals(this.updateTime, that.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.exists, this.updateTime);
    }
}

