/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Arrays;
import org.apache.commons.jexl3.internal.Closure;
import org.apache.commons.jexl3.internal.Scope;

public final class Frame {
    private final Scope scope;
    private final Object[] stack;
    private final int curried;

    Frame(Scope s, Object[] r, int c) {
        this.scope = s;
        this.stack = r;
        this.curried = c;
    }

    Frame assign(Object ... values) {
        if (this.stack != null) {
            int nparm = this.scope.getArgCount();
            Object[] copy = (Object[])this.stack.clone();
            int ncopy = 0;
            if (values != null && values.length > 0) {
                ncopy = Math.min(nparm - this.curried, Math.min(nparm, values.length));
                System.arraycopy(values, 0, copy, this.curried, ncopy);
            }
            Arrays.fill(copy, this.curried + ncopy, nparm, null);
            return new Frame(this.scope, copy, this.curried + ncopy);
        }
        return this;
    }

    Object get(int s) {
        return this.stack[s];
    }

    public Scope getScope() {
        return this.scope;
    }

    public String[] getUnboundParameters() {
        return this.scope.getParameters(this.curried);
    }

    boolean has(int s) {
        return s >= 0 && s < this.stack.length && this.stack[s] != Scope.UNDECLARED;
    }

    Object[] nocycleStack(Closure closure) {
        Object[] ns = this.stack;
        for (int i = 0; i < this.stack.length; ++i) {
            if (this.stack[i] != closure) continue;
            if (ns == this.stack) {
                ns = (Object[])this.stack.clone();
            }
            ns[i] = Closure.class.hashCode() + i;
        }
        return ns;
    }

    void set(int r, Object value) {
        this.stack[r] = value;
    }
}

