/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

final class ClassTool {
    private static final MethodHandle GET_MODULE;
    private static final MethodHandle GET_PKGNAME;
    private static final MethodHandle IS_EXPORTED;

    ClassTool() {
    }

    static String getPackageName(Class<?> clz) {
        String pkgName = "";
        if (clz != null) {
            if (GET_PKGNAME != null) {
                try {
                    return GET_PKGNAME.invoke(clz);
                }
                catch (Throwable xany) {
                    return "";
                }
            }
            Class<?> clazz = clz;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            if (clazz.isPrimitive()) {
                return "java.lang";
            }
            for (Class<?> walk = clazz.getEnclosingClass(); walk != null; walk = walk.getEnclosingClass()) {
                clazz = walk;
            }
            Package pkg = clazz.getPackage();
            if (pkg == null) {
                String name = clazz.getName();
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    pkgName = name.substring(0, dot);
                }
            } else {
                pkgName = pkg.getName();
            }
        }
        return pkgName;
    }

    static boolean isExported(Class<?> declarator) {
        if (IS_EXPORTED != null) {
            try {
                Object module = GET_MODULE.invoke(declarator);
                if (module != null) {
                    String pkgName = GET_PKGNAME.invoke(declarator);
                    return IS_EXPORTED.invoke(module, pkgName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    static {
        MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        MethodHandle getModule = null;
        MethodHandle getPackageName = null;
        MethodHandle isExported = null;
        try {
            Class<?> modulec = ClassTool.class.getClassLoader().loadClass("java.lang.Module");
            if (modulec != null && (getModule = LOOKUP.findVirtual(Class.class, "getModule", MethodType.methodType(modulec))) != null && (getPackageName = LOOKUP.findVirtual(Class.class, "getPackageName", MethodType.methodType(String.class))) != null) {
                isExported = LOOKUP.findVirtual(modulec, "isExported", MethodType.methodType(Boolean.TYPE, String.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_MODULE = getModule;
        GET_PKGNAME = getPackageName;
        IS_EXPORTED = isExported;
    }
}

