/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;

public class LogDirDescription {
    private final Map<TopicPartition, ReplicaInfo> replicaInfos;
    private final ApiException error;
    private final OptionalLong totalBytes;
    private final OptionalLong usableBytes;

    public LogDirDescription(ApiException error, Map<TopicPartition, ReplicaInfo> replicaInfos) {
        this(error, replicaInfos, -1L, -1L);
    }

    public LogDirDescription(ApiException error, Map<TopicPartition, ReplicaInfo> replicaInfos, long totalBytes, long usableBytes) {
        this.error = error;
        this.replicaInfos = replicaInfos;
        this.totalBytes = totalBytes == -1L ? OptionalLong.empty() : OptionalLong.of(totalBytes);
        this.usableBytes = usableBytes == -1L ? OptionalLong.empty() : OptionalLong.of(usableBytes);
    }

    public ApiException error() {
        return this.error;
    }

    public Map<TopicPartition, ReplicaInfo> replicaInfos() {
        return Collections.unmodifiableMap(this.replicaInfos);
    }

    public OptionalLong totalBytes() {
        return this.totalBytes;
    }

    public OptionalLong usableBytes() {
        return this.usableBytes;
    }

    public String toString() {
        return "LogDirDescription(replicaInfos=" + this.replicaInfos + ", error=" + this.error + ", totalBytes=" + this.totalBytes + ", usableBytes=" + this.usableBytes + ')';
    }
}

