/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource;

public final class SourceHandleUtils {
    private static final char CH_CR = '\r';
    private static final char CH_LF = '\n';
    private static final String CR = new String(new char[]{'\r'});
    private static final String LF = new String(new char[]{'\n'});
    private static final String CRLF = new String(new char[]{'\r', '\n'});

    private SourceHandleUtils() {
    }

    public static int lineToOffset(String text, int line) {
        int offset = 0;
        if (line > 1) {
            String breakString = CRLF;
            int breakIndex = text.indexOf(breakString);
            if (breakIndex == -1 && (breakIndex = text.indexOf(breakString = LF)) == -1) {
                breakString = CR;
                breakIndex = text.indexOf(breakString);
            }
            for (int _line = 1; breakIndex > -1 && _line < line; ++_line) {
                offset = breakIndex + breakString.length();
                breakIndex = text.indexOf(breakString, offset);
            }
        }
        return offset;
    }

    public static int[] offsetToLineColumn(String text, int offset) {
        int line = 1;
        int column = 1;
        boolean crlf = text.contains(CRLF);
        boolean newlinePending = false;
        offset = Math.min(offset, text.length());
        block4: for (int pos = 0; pos < offset; ++pos) {
            if (newlinePending) {
                ++line;
                column = 1;
                newlinePending = false;
            }
            char ch = text.charAt(pos);
            switch (ch) {
                case '\r': {
                    if (crlf) {
                        ++pos;
                    }
                    newlinePending = true;
                    continue block4;
                }
                case '\n': {
                    newlinePending = true;
                    continue block4;
                }
                default: {
                    ++column;
                }
            }
        }
        return new int[]{line, column};
    }
}

