/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class C2stekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("PA$").number("(d+)").text("$").expression(".#").number("(dd)(dd)(dd)#").number("(dd)(dd)(dd)#").number("([01])#").number("([+-]?d+.d+)#").number("([+-]?d+.d+)#").number("(d+.d+)#").number("(d+.d+)#").number("(-?d+.d+)#").number("(d+)#").number("d+#").number("(x+)").groupBegin().number("#([01])?").number("([01])").number("([01])#").groupEnd("?").any().text("$AP").compile();

    public C2stekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int alarm) {
        return switch (alarm) {
            case 2 -> "vibration";
            case 3 -> "powerCut";
            case 4 -> "overspeed";
            case 5 -> "sos";
            case 6 -> "door";
            case 10 -> "lowBattery";
            case 11 -> "fault";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        if (sentence.contains("$20$") && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(sentence, remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, (String)msg)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(parser.nextInt() > 0);
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.setAltitude(parser.nextDouble());
        position.set("battery", (double)parser.nextInt().intValue() * 0.001);
        position.set("alarm", this.decodeAlarm(parser.nextHexInt()));
        if (parser.hasNext()) {
            position.set("armed", parser.nextInt() > 0);
        }
        if (parser.hasNext(2)) {
            position.set("door", parser.nextInt() > 0);
            position.set("ignition", parser.nextInt() > 0);
        }
        return position;
    }
}

