/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geofence;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.traccar.config.Config;
import org.traccar.geofence.GeofenceGeometry;
import org.traccar.helper.DistanceCalculator;
import org.traccar.model.Geofence;

public class GeofenceCircle
extends GeofenceGeometry {
    private double centerLatitude;
    private double centerLongitude;
    private double radius;

    public GeofenceCircle() {
    }

    public GeofenceCircle(String wkt) throws ParseException {
        this.fromWkt(wkt);
    }

    public GeofenceCircle(double latitude, double longitude, double radius) {
        this.centerLatitude = latitude;
        this.centerLongitude = longitude;
        this.radius = radius;
    }

    public double distanceFromCenter(double latitude, double longitude) {
        return DistanceCalculator.distance(this.centerLatitude, this.centerLongitude, latitude, longitude);
    }

    @Override
    public boolean containsPoint(Config config, Geofence geofence, double latitude, double longitude) {
        return this.distanceFromCenter(latitude, longitude) <= this.radius;
    }

    @Override
    public double calculateArea() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public String toWkt() {
        Object wkt = "CIRCLE (";
        wkt = (String)wkt + String.valueOf(this.centerLatitude);
        wkt = (String)wkt + " ";
        wkt = (String)wkt + String.valueOf(this.centerLongitude);
        wkt = (String)wkt + ", ";
        DecimalFormat format = new DecimalFormat("0.#");
        wkt = (String)wkt + format.format(this.radius);
        wkt = (String)wkt + ")";
        return wkt;
    }

    @Override
    public void fromWkt(String wkt) throws ParseException {
        if (!wkt.startsWith("CIRCLE")) {
            throw new ParseException("Mismatch geometry type", 0);
        }
        String content = wkt.substring(wkt.indexOf("(") + 1, wkt.indexOf(")"));
        if (content.equals("")) {
            throw new ParseException("No content", 0);
        }
        String[] commaTokens = content.split(",");
        if (commaTokens.length != 2) {
            throw new ParseException("Not valid content", 0);
        }
        String[] tokens = commaTokens[0].split("\\s");
        if (tokens.length != 2) {
            throw new ParseException("Too much or less coordinates", 0);
        }
        try {
            this.centerLatitude = Double.parseDouble(tokens[0]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(tokens[0] + " is not a double", 0);
        }
        try {
            this.centerLongitude = Double.parseDouble(tokens[1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(tokens[1] + " is not a double", 0);
        }
        try {
            this.radius = Double.parseDouble(commaTokens[1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(commaTokens[1] + " is not a double", 0);
        }
    }
}

