/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.hash.ByteArrayHashMap;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionCache;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupData;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupMeta;
import org.pentaho.di.trans.steps.dimensionlookup.Messages;

public class DimensionLookup
extends BaseStep
implements StepInterface {
    private static final int CREATION_METHOD_AUTOINC = 1;
    private static final int CREATION_METHOD_SEQUENCE = 2;
    private static final int CREATION_METHOD_TABLEMAX = 3;
    private int techKeyCreation;
    private DimensionLookupMeta meta;
    private DimensionLookupData data;

    public DimensionLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void setTechKeyCreation(int method) {
        this.techKeyCreation = method;
    }

    private int getTechKeyCreation() {
        return this.techKeyCreation;
    }

    private void determineTechKeyCreation() {
        String keyCreation = this.meta.getTechKeyCreation();
        if (this.meta.getDatabaseMeta().supportsAutoinc() && DimensionLookupMeta.CREATION_METHOD_AUTOINC.equals(keyCreation)) {
            this.setTechKeyCreation(1);
        } else if (this.meta.getDatabaseMeta().supportsSequences() && DimensionLookupMeta.CREATION_METHOD_SEQUENCE.equals(keyCreation)) {
            this.setTechKeyCreation(2);
        } else {
            this.setTechKeyCreation(3);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (DimensionLookupMeta)smi;
        this.data = (DimensionLookupData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaName, this.data.realTableName);
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.startDateFieldIndex = -1;
            if (this.data.startDateChoice == 4) {
                this.data.startDateFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getStartDateFieldName());
                if (this.data.startDateFieldIndex < 0) {
                    throw new KettleStepException(Messages.getString("DimensionLookup.Exception.StartDateValueColumnNotFound", this.meta.getStartDateFieldName()));
                }
            }
            this.data.keynrs = new int[this.meta.getKeyStream().length];
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                if (this.data.keynrs[i] >= 0) continue;
                throw new KettleStepException(Messages.getString("DimensionLookup.Exception.KeyFieldNotFound", this.meta.getKeyStream()[i]));
            }
            this.data.fieldnrs = new int[this.meta.getFieldStream().length];
            for (i = 0; this.meta.getFieldStream() != null && i < this.meta.getFieldStream().length; ++i) {
                if (!DimensionLookupMeta.isUpdateTypeWithoutArgument(this.meta.isUpdate(), this.meta.getFieldUpdate()[i])) {
                    this.data.fieldnrs[i] = this.data.outputRowMeta.indexOfValue(this.meta.getFieldStream()[i]);
                    if (this.data.fieldnrs[i] >= 0) continue;
                    throw new KettleStepException(Messages.getString("DimensionLookup.Exception.KeyFieldNotFound", this.meta.getFieldStream()[i]));
                }
                this.data.fieldnrs[i] = -1;
            }
            if (!this.meta.isUpdate() && this.meta.isPreloadingCache()) {
                this.preloadCache();
            } else if (this.data.cacheKeyRowMeta == null) {
                this.data.cacheKeyRowMeta = new RowMeta();
                for (i = 0; i < this.data.keynrs.length; ++i) {
                    ValueMetaInterface key = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]);
                    this.data.cacheKeyRowMeta.addValueMeta(key.clone());
                }
                this.data.cache = new ByteArrayHashMap(this.meta.getCacheSize() > 0 ? this.meta.getCacheSize() : 5000, this.data.cacheKeyRowMeta);
            }
            this.data.datefieldnr = this.meta.getDateField() != null && this.meta.getDateField().length() > 0 ? this.getInputRowMeta().indexOfValue(this.meta.getDateField()) : -1;
            this.determineTechKeyCreation();
            this.data.notFoundTk = new Long(this.meta.getDatabaseMeta().getNotFoundTK(this.isAutoIncrement()));
            this.data.valueDateNow = this.meta.getDateField() != null && this.data.datefieldnr >= 0 ? this.getInputRowMeta().getDate(r, this.data.datefieldnr) : new Date(System.currentTimeMillis());
            if (this.getCopy() == 0) {
                this.checkDimZero();
            }
            this.setDimLookup(this.data.outputRowMeta);
        }
        try {
            Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(Messages.getString("DimensionLookup.Log.LineNumber") + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError(Messages.getString("DimensionLookup.Log.StepCanNotContinueForErrors", e.getMessage()));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void preloadCache() throws KettleException {
        try {
            int i;
            int i2;
            DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
            String sql = "SELECT " + databaseMeta.quoteField(this.meta.getKeyField());
            for (i2 = 0; i2 < this.meta.getKeyLookup().length; ++i2) {
                sql = sql + ", " + this.meta.getKeyLookup()[i2];
            }
            for (i2 = 0; i2 < this.meta.getFieldLookup().length; ++i2) {
                sql = sql + ", " + this.meta.getFieldLookup()[i2];
            }
            sql = sql + ", " + databaseMeta.quoteField(this.meta.getDateFrom());
            sql = sql + ", " + databaseMeta.quoteField(this.meta.getDateTo());
            sql = sql + " FROM " + this.data.schemaTable;
            this.logDetailed("Pre-loading cache by reading from database with: " + Const.CR + sql + Const.CR);
            List rows = this.data.db.getRows(sql, -1);
            RowMetaInterface rowMeta = this.data.db.getReturnRowMeta();
            this.data.preloadKeyIndexes = new int[this.meta.getKeyLookup().length];
            for (i = 0; i < this.data.preloadKeyIndexes.length; ++i) {
                this.data.preloadKeyIndexes[i] = rowMeta.indexOfValue(this.meta.getKeyLookup()[i]);
            }
            this.data.preloadFromDateIndex = rowMeta.indexOfValue(this.meta.getDateFrom());
            this.data.preloadToDateIndex = rowMeta.indexOfValue(this.meta.getDateTo());
            this.data.preloadCache = new DimensionCache(rowMeta, this.data.preloadKeyIndexes, this.data.preloadFromDateIndex, this.data.preloadToDateIndex);
            this.data.preloadCache.setRowCache(rows);
            this.logDetailed("Sorting the cache rows...");
            this.data.preloadCache.sortRows();
            this.logDetailed("Sorting of cached rows finished.");
            this.data.preloadIndexes = new ArrayList<Integer>();
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                int index = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                if (index < 0) {
                    throw new KettleStepException(Messages.getString("DimensionLookup.Exception.KeyFieldNotFound", this.meta.getFieldStream()[i]));
                }
                this.data.preloadIndexes.add(index);
            }
        }
        catch (Exception e) {
            throw new KettleException("Error encountered during cache pre-load", (Throwable)e);
        }
    }

    private synchronized Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Long technicalKey;
        Long valueVersion;
        Object[] lookupRow;
        RowMetaInterface lookupRowMeta;
        Object[] outputRow = new Object[this.data.outputRowMeta.size()];
        Object[] returnRow = null;
        Date valueDate = null;
        Date valueDateFrom = null;
        Date valueDateTo = null;
        valueDate = this.data.datefieldnr >= 0 ? rowMeta.getDate(row, this.data.datefieldnr) : this.data.valueDateNow;
        if (!this.meta.isUpdate() && this.meta.isPreloadingCache()) {
            RowMetaInterface preloadRowMeta = this.data.preloadCache.getRowMeta();
            this.data.returnRowMeta = this.data.preloadCache.getRowMeta();
            lookupRowMeta = preloadRowMeta;
            lookupRow = new Object[preloadRowMeta.size()];
            for (int i = 0; i < this.data.preloadIndexes.size(); ++i) {
                Object toData;
                int from = this.data.preloadIndexes.get(i);
                int to = this.data.preloadCache.getKeyIndexes()[i];
                ValueMetaInterface fromValueMeta = rowMeta.getValueMeta(from);
                ValueMetaInterface toValueMeta = this.data.preloadCache.getRowMeta().getValueMeta(to);
                Object fromData = row[from];
                lookupRow[to] = toData = toValueMeta.convertData(fromValueMeta, fromData);
            }
            lookupRow[this.data.preloadFromDateIndex] = valueDate;
            int index = this.data.preloadCache.lookupRow(lookupRow);
            returnRow = index >= 0 ? this.data.preloadCache.getRow(index) : null;
        } else {
            lookupRow = new Object[this.data.lookupRowMeta.size()];
            lookupRowMeta = this.data.lookupRowMeta;
            for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
                try {
                    lookupRow[i] = row[this.data.keynrs[i]];
                    continue;
                }
                catch (Exception e) {
                    throw new KettleStepException(Messages.getString("DimensionLookup.Exception.ErrorDetectedInGettingKey", i + "", this.data.keynrs[i] + "/" + rowMeta.size(), rowMeta.getString(row)));
                }
            }
            lookupRow[this.meta.getKeyStream().length] = valueDate;
            lookupRow[this.meta.getKeyStream().length + 1] = valueDate;
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("DimensionLookup.Log.LookupRow") + this.data.lookupRowMeta.getString(lookupRow));
            }
            if (this.meta.getCacheSize() >= 0) {
                returnRow = this.getFromCache(lookupRow, valueDate);
            }
            if (returnRow == null) {
                this.data.db.setValues(this.data.lookupRowMeta, lookupRow, this.data.prepStatementLookup);
                returnRow = this.data.db.getLookup(this.data.prepStatementLookup);
                this.data.returnRowMeta = this.data.db.getReturnRowMeta();
                this.incrementLinesInput();
                if (returnRow != null && this.meta.getCacheSize() >= 0) {
                    this.addToCache(lookupRow, returnRow);
                }
            }
        }
        if (!this.meta.isUpdate()) {
            if (returnRow == null) {
                returnRow = new Object[this.data.returnRowMeta.size()];
                returnRow[0] = this.data.notFoundTk;
                if (this.meta.getCacheSize() >= 0) {
                    returnRow[returnRow.length - 2] = this.data.min_date;
                    returnRow[returnRow.length - 1] = this.data.max_date;
                }
            }
        } else if (returnRow == null) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("DimensionLookup.Log.NoDimensionEntryFound") + lookupRowMeta.getString(lookupRow) + ")");
            }
            valueDateFrom = this.data.min_date;
            valueDateTo = this.data.max_date;
            valueVersion = new Long(1L);
            technicalKey = null;
            switch (this.getTechKeyCreation()) {
                case 3: {
                    technicalKey = this.data.db.getNextValue(this.getTransMeta().getCounters(), this.data.realSchemaName, this.data.realTableName, this.meta.getKeyField());
                    break;
                }
                case 1: {
                    technicalKey = null;
                    break;
                }
                case 2: {
                    technicalKey = this.data.db.getNextSequenceValue(this.data.realSchemaName, this.meta.getSequenceName(), this.meta.getKeyField());
                    if (technicalKey == null || !this.log.isRowLevel()) break;
                    this.logRowlevel(Messages.getString("DimensionLookup.Log.FoundNextSequence") + technicalKey.toString());
                }
            }
            technicalKey = this.dimInsert(this.getInputRowMeta(), row, technicalKey, true, valueVersion, valueDateFrom, valueDateTo);
            this.incrementLinesOutput();
            returnRow = new Object[this.data.returnRowMeta.size()];
            int returnIndex = 0;
            returnRow[returnIndex] = technicalKey;
            ++returnIndex;
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("DimensionLookup.Log.AddedDimensionEntry") + this.data.returnRowMeta.getString(returnRow));
            }
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("DimensionLookup.Log.DimensionEntryFound") + this.data.returnRowMeta.getString(returnRow));
            }
            technicalKey = this.data.returnRowMeta.getInteger(returnRow, 0);
            valueVersion = this.data.returnRowMeta.getInteger(returnRow, 1);
            valueDateFrom = this.meta.getMinDate();
            valueDateTo = this.meta.getMaxDate();
            boolean insert = false;
            boolean identical = true;
            boolean punch = false;
            for (int i = 0; i < this.meta.getFieldStream().length; ++i) {
                Object valueData2;
                ValueMetaInterface v2;
                Object valueData1;
                if (this.data.fieldnrs[i] < 0) continue;
                ValueMetaInterface v1 = this.data.outputRowMeta.getValueMeta(this.data.fieldnrs[i]);
                int cmp = v1.compare(valueData1 = row[this.data.fieldnrs[i]], v2 = this.data.returnRowMeta.getValueMeta(i + 2), valueData2 = returnRow[i + 2]);
                if (cmp != 0) {
                    identical = false;
                }
                if (cmp != 0 && this.meta.getFieldUpdate()[i] == 0) {
                    insert = true;
                }
                if (cmp != 0 && this.meta.getFieldUpdate()[i] == 2) {
                    punch = true;
                }
                if (!this.log.isRowLevel()) continue;
                this.logRowlevel(Messages.getString("DimensionLookup.Log.ComparingValues", "" + v1, "" + v2, String.valueOf(cmp), String.valueOf(identical), String.valueOf(insert), String.valueOf(punch)));
            }
            if (!insert) {
                if (!identical) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(Messages.getString("DimensionLookup.Log.UpdateRowWithValues") + this.getInputRowMeta().getString(row));
                    }
                    this.dimUpdate(rowMeta, row, technicalKey);
                    this.incrementLinesUpdated();
                    if (this.meta.getCacheSize() >= 0) {
                        Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueVersion, valueDateFrom, valueDateTo);
                        this.addToCache(lookupRow, values);
                    }
                } else {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(Messages.getString("DimensionLookup.Log.SkipLine"));
                    }
                    this.incrementLinesSkipped();
                }
            } else {
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("DimensionLookup.Log.InsertNewVersion") + technicalKey.toString());
                }
                Long valueNewVersion = valueVersion + 1L;
                valueDateFrom = valueDate;
                valueDateTo = this.data.max_date;
                if (this.meta.getDatabaseMeta().supportsAutoinc() && this.isAutoIncrement()) {
                    technicalKey = new Long(0L);
                } else if (this.meta.getDatabaseMeta().supportsSequences() && this.meta.getSequenceName() != null && this.meta.getSequenceName().length() > 0) {
                    technicalKey = this.data.db.getNextSequenceValue(this.data.realSchemaName, this.meta.getSequenceName(), this.meta.getKeyField());
                    if (technicalKey != null && this.log.isRowLevel()) {
                        this.logRowlevel(Messages.getString("DimensionLookup.Log.FoundNextSequence2") + technicalKey.toString());
                    }
                } else {
                    technicalKey = this.data.db.getNextValue(this.getTransMeta().getCounters(), this.data.realSchemaName, this.data.realTableName, this.meta.getKeyField());
                }
                technicalKey = this.dimInsert(rowMeta, row, technicalKey, false, valueNewVersion, valueDateFrom, valueDateTo);
                this.incrementLinesOutput();
                if (this.meta.getCacheSize() >= 0) {
                    Object[] values = this.getCacheValues(rowMeta, row, technicalKey, valueNewVersion, valueDateFrom, valueDateTo);
                    this.addToCache(lookupRow, values);
                }
            }
            if (punch) {
                this.dimPunchThrough(rowMeta, row);
                this.incrementLinesUpdated();
            }
            returnRow = new Object[this.data.returnRowMeta.size()];
            returnRow[0] = technicalKey;
            if (this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("DimensionLookup.Log.TechnicalKey") + technicalKey);
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(Messages.getString("DimensionLookup.Log.AddValuesToRow") + this.data.returnRowMeta.getString(returnRow));
        }
        for (int i = 0; i < rowMeta.size(); ++i) {
            outputRow[i] = row[i];
        }
        int outputIndex = rowMeta.size();
        int inputIndex = 0;
        outputRow[outputIndex++] = this.data.returnRowMeta.getInteger(returnRow, inputIndex++);
        ++inputIndex;
        while (inputIndex < returnRow.length && outputIndex < outputRow.length) {
            outputRow[outputIndex] = returnRow[inputIndex];
            ++outputIndex;
            ++inputIndex;
        }
        return outputRow;
    }

    private void setDimLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.lookupRowMeta = new RowMeta();
        String sql = "SELECT " + databaseMeta.quoteField(this.meta.getKeyField()) + ", " + databaseMeta.quoteField(this.meta.getVersionField());
        if (!Const.isEmpty((String[])this.meta.getFieldLookup())) {
            for (i = 0; i < this.meta.getFieldLookup().length; ++i) {
                if (Const.isEmpty((String)this.meta.getFieldLookup()[i]) || DimensionLookupMeta.isUpdateTypeWithoutArgument(this.meta.isUpdate(), this.meta.getFieldUpdate()[i])) continue;
                sql = sql + ", " + databaseMeta.quoteField(this.meta.getFieldLookup()[i]);
                if (Const.isEmpty((String)this.meta.getFieldStream()[i]) || this.meta.getFieldLookup()[i].equals(this.meta.getFieldStream()[i])) continue;
                sql = sql + " AS " + databaseMeta.quoteField(this.meta.getFieldStream()[i]);
            }
        }
        if (this.meta.getCacheSize() >= 0) {
            sql = sql + ", " + databaseMeta.quoteField(this.meta.getDateFrom()) + ", " + databaseMeta.quoteField(this.meta.getDateTo());
        }
        sql = sql + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ? ";
            this.data.lookupRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.keynrs[i]));
        }
        String dateFromField = databaseMeta.quoteField(this.meta.getDateFrom());
        String dateToField = databaseMeta.quoteField(this.meta.getDateTo());
        if (this.meta.isUsingStartDateAlternative() && this.meta.getStartDateAlternative() == 3 || this.meta.getStartDateAlternative() == 4) {
            sql = sql + " AND ( " + dateFromField + " IS NULL OR " + dateFromField + " <= ? )" + Const.CR;
            sql = sql + " AND " + dateToField + " >= ?" + Const.CR;
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateFrom(), 3));
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateTo(), 3));
        } else {
            sql = sql + " AND ? >= " + dateFromField + Const.CR;
            sql = sql + " AND ? < " + dateToField + Const.CR;
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateFrom(), 3));
            this.data.lookupRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateTo(), 3));
        }
        try {
            this.log.logDetailed(this.toString(), "Dimension Lookup setting preparedStatement to [" + sql + "]", new Object[0]);
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
            if (databaseMeta.supportsSetMaxRows()) {
                this.data.prepStatementLookup.setMaxRows(1);
            }
            if (databaseMeta.getDatabaseType() == 1) {
                this.data.prepStatementLookup.setFetchSize(0);
            }
            this.log.logDetailed(this.toString(), "Finished preparing dimension lookup statement.", new Object[0]);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare dimension lookup", (Throwable)ex);
        }
    }

    private boolean isAutoIncrement() {
        return this.techKeyCreation == 1;
    }

    public Long dimInsert(RowMetaInterface inputRowMeta, Object[] row, Long technicalKey, boolean newEntry, Long versionNr, Date dateFrom, Date dateTo) throws KettleException {
        int i;
        int i2;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        if (this.data.prepStatementInsert == null && this.data.prepStatementUpdate == null) {
            int i3;
            RowMeta insertRowMeta = new RowMeta();
            String sql = "INSERT INTO " + this.data.schemaTable + "( ";
            if (!this.isAutoIncrement()) {
                sql = sql + databaseMeta.quoteField(this.meta.getKeyField()) + ", ";
                insertRowMeta.addValueMeta(this.data.outputRowMeta.getValueMeta(inputRowMeta.size()));
            } else if (databaseMeta.getDatabaseType() == 9) {
                sql = sql + "0, ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getVersionField()) + ", " + databaseMeta.quoteField(this.meta.getDateFrom()) + ", " + databaseMeta.quoteField(this.meta.getDateTo());
            insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getVersionField(), 5));
            insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateFrom(), 3));
            insertRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateTo(), 3));
            for (i3 = 0; i3 < this.meta.getKeyLookup().length; ++i3) {
                sql = sql + ", " + databaseMeta.quoteField(this.meta.getKeyLookup()[i3]);
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i3]));
            }
            for (i3 = 0; i3 < this.meta.getFieldLookup().length; ++i3) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(this.meta.isUpdate(), this.meta.getFieldUpdate()[i3])) continue;
                sql = sql + ", " + databaseMeta.quoteField(this.meta.getFieldLookup()[i3]);
                insertRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.fieldnrs[i3]));
            }
            for (i3 = 0; i3 < this.meta.getFieldUpdate().length; ++i3) {
                ValueMeta valueMeta = null;
                switch (this.meta.getFieldUpdate()[i3]) {
                    case 3: 
                    case 4: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i3], 3);
                        break;
                    }
                    case 6: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i3], 4);
                    }
                }
                if (valueMeta == null) continue;
                sql = sql + ", " + databaseMeta.quoteField(valueMeta.getName());
                insertRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            sql = sql + ") VALUES (";
            if (!this.isAutoIncrement()) {
                sql = sql + "?, ";
            }
            sql = sql + "?, ?, ?";
            for (i3 = 0; i3 < this.data.keynrs.length; ++i3) {
                sql = sql + ", ?";
            }
            for (i3 = 0; i3 < this.meta.getFieldLookup().length; ++i3) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(this.meta.isUpdate(), this.meta.getFieldUpdate()[i3])) continue;
                sql = sql + ", ?";
            }
            for (i3 = 0; i3 < this.meta.getFieldUpdate().length; ++i3) {
                switch (this.meta.getFieldUpdate()[i3]) {
                    case 3: 
                    case 4: 
                    case 6: {
                        sql = sql + ", ?";
                    }
                }
            }
            sql = sql + " )";
            try {
                if (technicalKey == null) {
                    this.log.logDetailed(this.toString(), "SQL w/ return keys=[" + sql + "]", new Object[0]);
                    this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql), 1);
                } else {
                    this.log.logDetailed(this.toString(), "SQL=[" + sql + "]", new Object[0]);
                    this.data.prepStatementInsert = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
                }
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to prepare dimension insert :" + Const.CR + sql, (Throwable)ex);
            }
            RowMeta updateRowMeta = new RowMeta();
            String sql_upd = "UPDATE " + this.data.schemaTable + Const.CR;
            sql_upd = sql_upd + "SET " + databaseMeta.quoteField(this.meta.getDateTo()) + " = ?" + Const.CR;
            updateRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getDateTo(), 3));
            for (i2 = 0; i2 < this.meta.getFieldUpdate().length; ++i2) {
                ValueMeta valueMeta = null;
                switch (this.meta.getFieldUpdate()[i2]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i2], 3);
                        break;
                    }
                    case 6: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i2], 4);
                    }
                }
                if (valueMeta == null) continue;
                sql_upd = sql_upd + ", " + databaseMeta.quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            sql_upd = sql_upd + "WHERE ";
            for (i2 = 0; i2 < this.meta.getKeyLookup().length; ++i2) {
                if (i2 > 0) {
                    sql_upd = sql_upd + "AND   ";
                }
                sql_upd = sql_upd + databaseMeta.quoteField(this.meta.getKeyLookup()[i2]) + " = ?" + Const.CR;
                updateRowMeta.addValueMeta(inputRowMeta.getValueMeta(this.data.keynrs[i2]));
            }
            sql_upd = sql_upd + "AND   " + databaseMeta.quoteField(this.meta.getVersionField()) + " = ? ";
            updateRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getVersionField(), 5));
            try {
                this.log.logDetailed(this.toString(), "Preparing update: " + Const.CR + sql_upd + Const.CR, new Object[0]);
                this.data.prepStatementUpdate = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql_upd));
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to prepare dimension update :" + Const.CR + sql_upd, (Throwable)ex);
            }
            this.data.insertRowMeta = insertRowMeta;
            this.data.updateRowMeta = updateRowMeta;
        }
        Object[] insertRow = new Object[this.data.insertRowMeta.size()];
        int insertIndex = 0;
        if (!this.isAutoIncrement()) {
            insertRow[insertIndex++] = technicalKey;
        }
        insertRow[insertIndex++] = versionNr;
        switch (this.data.startDateChoice) {
            case 0: {
                insertRow[insertIndex++] = dateFrom;
                break;
            }
            case 1: {
                insertRow[insertIndex++] = new Date();
                break;
            }
            case 2: {
                insertRow[insertIndex++] = this.getTrans().getStartDate();
                break;
            }
            case 3: {
                insertRow[insertIndex++] = null;
                break;
            }
            case 4: {
                insertRow[insertIndex++] = inputRowMeta.getDate(row, this.data.startDateFieldIndex);
                break;
            }
            default: {
                throw new KettleStepException(Messages.getString("DimensionLookup.Exception.IllegalStartDateSelection", Integer.toString(this.data.startDateChoice)));
            }
        }
        insertRow[insertIndex++] = dateTo;
        for (i = 0; i < this.data.keynrs.length; ++i) {
            insertRow[insertIndex++] = row[this.data.keynrs[i]];
        }
        for (i = 0; i < this.data.fieldnrs.length; ++i) {
            if (this.data.fieldnrs[i] < 0) continue;
            insertRow[insertIndex++] = row[this.data.fieldnrs[i]];
        }
        block42: for (i = 0; i < this.meta.getFieldUpdate().length; ++i) {
            switch (this.meta.getFieldUpdate()[i]) {
                case 3: 
                case 4: {
                    insertRow[insertIndex++] = new Date();
                    continue block42;
                }
                case 6: {
                    insertRow[insertIndex++] = Boolean.TRUE;
                }
            }
        }
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "rins, size=" + this.data.insertRowMeta.size() + ", values=" + this.data.insertRowMeta.getString(insertRow), new Object[0]);
        }
        this.data.db.setValues(this.data.insertRowMeta, insertRow, this.data.prepStatementInsert);
        this.data.db.insertRow(this.data.prepStatementInsert);
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "Row inserted!", new Object[0]);
        }
        if (this.isAutoIncrement()) {
            try {
                RowMetaAndData keys = this.data.db.getGeneratedKeys(this.data.prepStatementInsert);
                if (keys.getRowMeta().size() <= 0) {
                    throw new KettleDatabaseException("Unable to retrieve value of auto-generated technical key : no value found!");
                }
                technicalKey = keys.getRowMeta().getInteger(keys.getData(), 0);
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to retrieve value of auto-generated technical key : unexpected error: ", (Throwable)e);
            }
        }
        if (!newEntry) {
            Object[] updateRow = new Object[this.data.updateRowMeta.size()];
            int updateIndex = 0;
            updateRow[updateIndex++] = dateFrom;
            block43: for (i2 = 0; i2 < this.meta.getFieldUpdate().length; ++i2) {
                switch (this.meta.getFieldUpdate()[i2]) {
                    case 3: 
                    case 4: {
                        updateRow[updateIndex++] = new Date();
                        continue block43;
                    }
                    case 6: {
                        updateRow[updateIndex++] = Boolean.FALSE;
                    }
                }
            }
            for (i2 = 0; i2 < this.data.keynrs.length; ++i2) {
                updateRow[updateIndex] = row[this.data.keynrs[i2]];
                ++updateIndex;
            }
            updateRow[updateIndex] = versionNr - 1L;
            ++updateIndex;
            if (this.log.isRowLevel()) {
                this.log.logRowlevel(this.toString(), "UPDATE using rupd=" + this.data.updateRowMeta.getString(updateRow), new Object[0]);
            }
            this.data.db.setValues(this.data.updateRowMeta, updateRow, this.data.prepStatementUpdate);
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), "Values set for update (" + this.data.updateRowMeta.size() + ")", new Object[0]);
            }
            this.data.db.insertRow(this.data.prepStatementUpdate);
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), "Row updated!", new Object[0]);
            }
        }
        return technicalKey;
    }

    public void dimUpdate(RowMetaInterface rowMeta, Object[] row, Long dimkey) throws KettleDatabaseException {
        int i;
        if (this.data.prepStatementDimensionUpdate == null) {
            this.data.dimensionUpdateRowMeta = new RowMeta();
            String sql = "UPDATE " + this.data.schemaTable + Const.CR + "SET ";
            boolean comma = false;
            for (i = 0; i < this.meta.getFieldLookup().length; ++i) {
                if (DimensionLookupMeta.isUpdateTypeWithoutArgument(this.meta.isUpdate(), this.meta.getFieldUpdate()[i])) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + this.meta.getDatabaseMeta().quoteField(this.meta.getFieldLookup()[i]) + " = ?" + Const.CR;
                this.data.dimensionUpdateRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.fieldnrs[i]));
            }
            for (i = 0; i < this.meta.getFieldUpdate().length; ++i) {
                ValueMeta valueMeta = null;
                switch (this.meta.getFieldUpdate()[i]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i], 3);
                    }
                }
                if (valueMeta == null) continue;
                sql = comma ? sql + ", " : sql + "  ";
                comma = true;
                sql = sql + this.meta.getDatabaseMeta().quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                this.data.dimensionUpdateRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            sql = sql + "WHERE  " + this.meta.getDatabaseMeta().quoteField(this.meta.getKeyField()) + " = ?";
            this.data.dimensionUpdateRowMeta.addValueMeta((ValueMetaInterface)new ValueMeta(this.meta.getKeyField(), 5));
            try {
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), "Preparing statement: [" + sql + "]", new Object[0]);
                }
                this.data.prepStatementDimensionUpdate = this.data.db.getConnection().prepareStatement(this.meta.getDatabaseMeta().stripCR(sql));
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Couldn't prepare statement :" + Const.CR + sql, (Throwable)ex);
            }
        }
        Object[] dimensionUpdateRow = new Object[this.data.dimensionUpdateRowMeta.size()];
        int updateIndex = 0;
        for (i = 0; i < this.data.fieldnrs.length; ++i) {
            if (this.data.fieldnrs[i] < 0) continue;
            dimensionUpdateRow[updateIndex++] = row[this.data.fieldnrs[i]];
        }
        for (i = 0; i < this.meta.getFieldUpdate().length; ++i) {
            switch (this.meta.getFieldUpdate()[i]) {
                case 3: 
                case 5: {
                    dimensionUpdateRow[updateIndex++] = new Date();
                }
            }
        }
        dimensionUpdateRow[updateIndex++] = dimkey;
        this.data.db.setValues(this.data.dimensionUpdateRowMeta, dimensionUpdateRow, this.data.prepStatementDimensionUpdate);
        this.data.db.insertRow(this.data.prepStatementDimensionUpdate);
    }

    public void dimPunchThrough(RowMetaInterface rowMeta, Object[] row) throws KettleDatabaseException {
        int i;
        if (this.data.prepStatementPunchThrough == null) {
            this.data.punchThroughRowMeta = new RowMeta();
            String sql_upd = "UPDATE " + this.data.schemaTable + Const.CR;
            sql_upd = sql_upd + "SET ";
            boolean first = true;
            for (i = 0; i < this.meta.getFieldLookup().length; ++i) {
                if (this.meta.getFieldUpdate()[i] != 2) continue;
                sql_upd = !first ? sql_upd + ", " : sql_upd + "  ";
                first = false;
                sql_upd = sql_upd + this.meta.getFieldLookup()[i] + " = ?" + Const.CR;
                this.data.punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.fieldnrs[i]));
            }
            for (i = 0; i < this.meta.getFieldUpdate().length; ++i) {
                ValueMeta valueMeta = null;
                switch (this.meta.getFieldUpdate()[i]) {
                    case 3: 
                    case 5: {
                        valueMeta = new ValueMeta(this.meta.getFieldLookup()[i], 3);
                    }
                }
                if (valueMeta == null) continue;
                sql_upd = sql_upd + ", " + this.meta.getDatabaseMeta().quoteField(valueMeta.getName()) + " = ?" + Const.CR;
                this.data.punchThroughRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
            }
            sql_upd = sql_upd + "WHERE ";
            for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                if (i > 0) {
                    sql_upd = sql_upd + "AND   ";
                }
                sql_upd = sql_upd + this.meta.getKeyLookup()[i] + " = ?" + Const.CR;
                this.data.punchThroughRowMeta.addValueMeta(rowMeta.getValueMeta(this.data.keynrs[i]));
            }
            try {
                this.data.prepStatementPunchThrough = this.data.db.getConnection().prepareStatement(this.meta.getDatabaseMeta().stripCR(sql_upd));
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to prepare dimension punchThrough update statement : " + Const.CR + sql_upd, (Throwable)ex);
            }
        }
        Object[] punchThroughRow = new Object[this.data.punchThroughRowMeta.size()];
        int punchIndex = 0;
        for (i = 0; i < this.meta.getFieldLookup().length; ++i) {
            if (this.meta.getFieldUpdate()[i] != 2) continue;
            punchThroughRow[punchIndex++] = row[this.data.fieldnrs[i]];
        }
        for (i = 0; i < this.meta.getFieldUpdate().length; ++i) {
            switch (this.meta.getFieldUpdate()[i]) {
                case 3: 
                case 5: {
                    punchThroughRow[punchIndex++] = new Date();
                }
            }
        }
        for (i = 0; i < this.data.keynrs.length; ++i) {
            punchThroughRow[punchIndex++] = row[this.data.keynrs[i]];
        }
        this.data.db.setValues(this.data.punchThroughRowMeta, punchThroughRow, this.data.prepStatementPunchThrough);
        this.data.db.insertRow(this.data.prepStatementPunchThrough);
    }

    private Object[] getCacheValues(RowMetaInterface rowMeta, Object[] row, Long technicalKey, Long valueVersion, Date valueDateFrom, Date valueDateTo) {
        if (this.data.cacheValueRowMeta == null) {
            return null;
        }
        Object[] cacheValues = new Object[this.data.cacheValueRowMeta.size()];
        int cacheIndex = 0;
        cacheValues[cacheIndex++] = technicalKey;
        cacheValues[cacheIndex++] = valueVersion;
        for (int i = 0; i < this.data.fieldnrs.length; ++i) {
            if (this.data.fieldnrs[i] < 0) continue;
            cacheValues[cacheIndex++] = row[this.data.fieldnrs[i]];
        }
        cacheValues[cacheIndex++] = valueDateFrom;
        cacheValues[cacheIndex++] = valueDateTo;
        return cacheValues;
    }

    private void addToCache(Object[] keyValues, Object[] returnValues) throws KettleValueException {
        if (this.data.cacheValueRowMeta == null) {
            this.data.cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        byte[] keyPart = RowMeta.extractData((RowMetaInterface)this.data.cacheKeyRowMeta, (Object[])keyValues);
        byte[] valuePart = RowMeta.extractData((RowMetaInterface)this.data.cacheValueRowMeta, (Object[])returnValues);
        this.data.cache.put(keyPart, valuePart);
        int tenPercent = this.meta.getCacheSize() / 10;
        if (this.meta.getCacheSize() > 0 && this.data.cache.size() > this.meta.getCacheSize() + tenPercent) {
            Object[] values;
            byte[] value;
            byte[] key;
            int i;
            List keys = this.data.cache.getKeys();
            int sizeBefore = keys.size();
            ArrayList<Long> samples = new ArrayList<Long>();
            int stepsize = keys.size() / 5;
            if (stepsize < 1) {
                stepsize = 1;
            }
            for (i = 0; i < keys.size(); i += stepsize) {
                key = (byte[])keys.get(i);
                value = this.data.cache.get(key);
                if (value == null) continue;
                values = RowMeta.getRow((RowMetaInterface)this.data.cacheValueRowMeta, (byte[])value);
                Long tk = this.data.cacheValueRowMeta.getInteger(values, 0);
                samples.add(tk);
            }
            Collections.sort(samples);
            this.data.smallestCacheKey = samples.size() > 1 ? ((Long)samples.get(1)).longValue() : ((Long)samples.get(0)).longValue();
            for (i = 0; i < keys.size(); ++i) {
                long tk;
                key = (byte[])keys.get(i);
                value = this.data.cache.get(key);
                if (value == null || (tk = this.data.cacheValueRowMeta.getInteger(values = RowMeta.getRow((RowMetaInterface)this.data.cacheValueRowMeta, (byte[])value), 0).longValue()) > this.data.smallestCacheKey) continue;
                this.data.cache.remove((Object)key);
            }
            int sizeAfter = this.data.cache.size();
            this.logDetailed("Reduced the lookup cache from " + sizeBefore + " to " + sizeAfter + " rows.");
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Cache store: key=" + keyValues + "    values=" + returnValues);
        }
    }

    private RowMetaInterface assembleCacheValueRowMeta() {
        RowMetaInterface cacheRowMeta = this.data.returnRowMeta.clone();
        return cacheRowMeta;
    }

    private Object[] getFromCache(Object[] keyValues, Date dateValue) throws KettleValueException {
        byte[] key;
        byte[] value;
        if (this.data.cacheValueRowMeta == null) {
            if (this.data.returnRowMeta == null) {
                return null;
            }
            this.data.cacheValueRowMeta = this.assembleCacheValueRowMeta();
        }
        if ((value = this.data.cache.get(key = RowMeta.extractData((RowMetaInterface)this.data.cacheKeyRowMeta, (Object[])keyValues))) != null) {
            Object[] row = RowMeta.getRow((RowMetaInterface)this.data.cacheValueRowMeta, (byte[])value);
            long time = dateValue.getTime();
            long from = ((Date)row[row.length - 2]).getTime();
            long to = ((Date)row[row.length - 1]).getTime();
            if (time >= from && time < to) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Cache hit: key=" + this.data.cacheKeyRowMeta.getString(keyValues) + "  values=" + this.data.cacheValueRowMeta.getString(row));
                }
                return row;
            }
        }
        return null;
    }

    public void checkDimZero() throws KettleException {
        String sql;
        RowMetaAndData r;
        Long count;
        if (!this.meta.isUpdate()) {
            return;
        }
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        if (this.meta.isAutoIncrement() && (count = (r = this.data.db.getOneRow(sql = "SELECT count(*) FROM " + this.data.schemaTable)).getRowMeta().getInteger(r.getData(), 0)) != 0L) {
            return;
        }
        int start_tk = databaseMeta.getNotFoundTK(this.isAutoIncrement());
        String sql2 = "SELECT count(*) FROM " + this.data.schemaTable + " WHERE " + databaseMeta.quoteField(this.meta.getKeyField()) + " = " + start_tk;
        RowMetaAndData r2 = this.data.db.getOneRow(sql2);
        Long count2 = r2.getRowMeta().getInteger(r2.getData(), 0);
        if (count2 == 0L) {
            String isql = null;
            try {
                if (!databaseMeta.supportsAutoinc() || !this.isAutoIncrement()) {
                    isql = "insert into " + this.data.schemaTable + "(" + databaseMeta.quoteField(this.meta.getKeyField()) + ", " + databaseMeta.quoteField(this.meta.getVersionField()) + ") values (0, 1)";
                } else {
                    switch (databaseMeta.getDatabaseType()) {
                        case 2: 
                        case 8: 
                        case 11: {
                            isql = "insert into " + this.data.schemaTable + "(" + databaseMeta.quoteField(this.meta.getKeyField()) + ", " + databaseMeta.quoteField(this.meta.getVersionField()) + ") values (0, 1)";
                            break;
                        }
                        case 1: 
                        case 9: {
                            isql = "insert into " + this.data.schemaTable + "(" + databaseMeta.quoteField(this.meta.getKeyField()) + ", " + databaseMeta.quoteField(this.meta.getVersionField()) + ") values (1, 1)";
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 10: 
                        case 12: 
                        case 16: 
                        case 27: {
                            isql = "insert into " + this.data.schemaTable + "(" + databaseMeta.quoteField(this.meta.getVersionField()) + ") values (1)";
                            break;
                        }
                        default: {
                            isql = "insert into " + this.data.schemaTable + "(" + databaseMeta.quoteField(this.meta.getKeyField()) + ", " + databaseMeta.quoteField(this.meta.getVersionField()) + ") values (0, 1)";
                        }
                    }
                }
                this.data.db.execStatement(databaseMeta.stripCR(isql));
            }
            catch (KettleException e) {
                throw new KettleDatabaseException("Error inserting 'unknown' row in dimension [" + this.data.schemaTable + "] : " + isql, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DimensionLookupMeta)smi;
        this.data = (DimensionLookupData)sdi;
        if (super.init(smi, sdi)) {
            this.data.min_date = this.meta.getMinDate();
            this.data.max_date = this.meta.getMaxDate();
            this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
            this.data.realTableName = this.environmentSubstitute(this.meta.getTableName());
            this.data.startDateChoice = 0;
            if (this.meta.isUsingStartDateAlternative()) {
                this.data.startDateChoice = this.meta.getStartDateAlternative();
            }
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("DimensionLookup.Log.ConnectedToDB"));
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleException ke) {
                this.logError(Messages.getString("DimensionLookup.Log.ErrorOccurredInProcessing") + ke.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block9: {
            this.meta = (DimensionLookupMeta)smi;
            this.data = (DimensionLookupData)sdi;
            try {
                block8: {
                    try {
                        if (this.data.db.isAutoCommit()) break block8;
                        if (this.getErrors() == 0L) {
                            this.data.db.commit();
                        } else {
                            this.data.db.rollback();
                        }
                    }
                    catch (KettleDatabaseException e) {
                        this.logError(Messages.getString("DimensionLookup.Log.ErrorOccurredInProcessing") + e.getMessage());
                        Object var5_4 = null;
                        if (this.data.db != null) {
                            this.data.db.disconnect();
                        }
                        break block9;
                    }
                }
                Object var5_3 = null;
                if (this.data.db == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

