/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerowsbyhashset;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.Messages;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.RowKey;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetData;
import org.pentaho.di.trans.steps.uniquerowsbyhashset.UniqueRowsByHashSetMeta;

public class UniqueRowsByHashSet
extends BaseStep
implements StepInterface {
    private UniqueRowsByHashSetMeta meta = (UniqueRowsByHashSetMeta)this.getStepMeta().getStepMetaInterface();
    private UniqueRowsByHashSetData data;

    public UniqueRowsByHashSet(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (UniqueRowsByHashSetData)stepDataInterface;
    }

    private boolean isUniqueRow(Object[] row) {
        return this.data.seen.add(new RowKey(row, this.data));
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (UniqueRowsByHashSetMeta)smi;
        this.data = (UniqueRowsByHashSetData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.data.clearHashSet();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.storeValues = this.meta.getStoreValues();
            this.data.fieldnrs = new int[this.meta.getCompareFields().length];
            for (int i = 0; i < this.meta.getCompareFields().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getCompareFields()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError(Messages.getString("UniqueRowsByHashSet.Log.CouldNotFindFieldInRow", this.meta.getCompareFields()[i]));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        if (this.isUniqueRow(r)) {
            this.putRow(this.data.outputRowMeta, r);
        } else {
            this.incrementLinesRejected();
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("UniqueRowsByHashSet.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UniqueRowsByHashSetMeta)smi;
        this.data = (UniqueRowsByHashSetData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

