/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.CreateVolumePermissionAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttributeItem;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.OnlyOneArgumentExpected;
import java.util.regex.Pattern;

public abstract class SnapshotAttributeBaseCmd
extends BaseCmd {
    public static final String GROUP_ITEM = "group";
    public static final String SNAPSHOT_ID_ITEM = "snapshotId";
    public static final String SNAPSHOT_ATTRIBUTE = "snapshot attribute";
    private static final Pattern validUserIdRegex = Pattern.compile("^\\d{12}+$");

    protected SnapshotAttributeBaseCmd(String name, String alias) {
        super(name, alias);
    }

    protected SnapshotAttribute.SnapshotAttributeType getSnapshotAttributeType(Jec2 jec2) {
        if (this.isOptionSet("create-volume-permission")) {
            return SnapshotAttribute.SnapshotAttributeType.createVolumePermission;
        }
        if (this.isOptionSet("product-code")) {
            return SnapshotAttribute.SnapshotAttributeType.productCodes;
        }
        throw new MissingArgument("create-volume-permission or product-code");
    }

    protected SnapshotAttribute getSnapshotAttribute(Jec2 jec2) {
        if (this.isOptionSet("create-volume-permission")) {
            CreateVolumePermissionAttribute listAttribute = new CreateVolumePermissionAttribute();
            this.populateListAttribute((SnapshotListAttribute)listAttribute);
            return listAttribute;
        }
        throw new MissingArgument("create-volume-permission");
    }

    protected void populateListAttribute(SnapshotListAttribute list) {
        String[] itemValues = null;
        String operationName = "";
        this.assertOnlyOneOptionSet(ATTRIBUTE_OP_ARGS);
        if (this.isOptionSet("add")) {
            itemValues = this.getOptionValues("add");
            operationName = "add";
        } else if (this.isOptionSet("remove")) {
            itemValues = this.getOptionValues("remove");
            operationName = "remove";
        } else {
            throw new InvalidArgument(operationName, "(null)");
        }
        for (String itemValue : itemValues) {
            if (itemValue.equals("all")) {
                list.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.group, itemValue);
                continue;
            }
            if (validUserIdRegex.matcher(itemValue).matches()) {
                list.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.userId, itemValue);
                continue;
            }
            throw new InvalidArgument(operationName, itemValue);
        }
    }

    protected SnapshotListAttribute.SnapshotListAttributeOperationType getAttributeListOperationType() {
        if (this.isOptionSet("create-volume-permission")) {
            this.assertOnlyOneOptionSet(ATTRIBUTE_OP_ARGS);
        }
        if (this.isOptionSet("add")) {
            return SnapshotListAttribute.SnapshotListAttributeOperationType.add;
        }
        if (this.isOptionSet("remove")) {
            return SnapshotListAttribute.SnapshotListAttributeOperationType.remove;
        }
        throw new OnlyOneArgumentExpected(ATTRIBUTE_OP_ARGS);
    }

    protected String getSnapshotId() {
        String[] snapshotIds = this.getNonOptions();
        if (snapshotIds.length == 0) {
            throw new InvalidArgumentCombination("A snapshot ID must be specified.");
        }
        if (snapshotIds.length > 1) {
            throw new InvalidArgumentCombination("Only one snapshot ID may be specified.");
        }
        return snapshotIds[0];
    }
}

