/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportIndianPanel
extends ReportPanel {
    private static final String[] headlines = new String[]{"settlement", "mission", "report.indian.tension", "skillTaught", "report.indian.mostHated", "report.indian.tradeInterests"};

    public ReportIndianPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportIndianAction");
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout(new MigLayout("wrap 6, fillx, insets 0", "[]20px[center]", "[top]"));
        boolean needsSeperator = false;
        for (Player opponent : CollectionUtils.transform(this.getGame().getLiveNativePlayers(new Player[0]), p -> player.hasContacted((Player)p))) {
            if (needsSeperator) {
                this.reportPanel.add((Component)new JSeparator(0), "newline 20, span, growx, wrap 20");
            }
            this.buildIndianAdvisorPanel(player, opponent);
            needsSeperator = true;
        }
        this.scrollPane.getViewport().setOpaque(false);
        this.reportPanel.setOpaque(true);
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        NationSummary ns = this.igc().nationSummary(opponent);
        List<IndianSettlement> nativeSettlements = opponent.getIndianSettlementList();
        String numSettlements = String.valueOf(nativeSettlements.size()) + " / " + (ns == null ? "?" : String.valueOf(ns.getNumberOfSettlements()));
        ImageLibrary lib = this.getImageLibrary();
        JLabel villageLabel = new JLabel();
        villageLabel.setIcon(new ImageIcon(lib.getScaledSettlementTypeImage(opponent.getNationType().getCapitalType())));
        this.reportPanel.add((Component)villageLabel, "span, split 2");
        JLabel headline = Utility.localizedLabel(opponent.getNationLabel());
        headline.setFont(FontLibrary.getScaledFont("normal-bold-small"));
        this.reportPanel.add((Component)headline, "wrap 20, aligny center");
        JLabel label = Utility.localizedLabel("report.indian.chieftain");
        Font font = FontLibrary.getScaledFont("normal-bold-tiny");
        label.setFont(font);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)Utility.localizedLabel(opponent.getName()), "left, wrap");
        label = Utility.localizedLabel("report.indian.typeOfSettlements");
        label.setFont(font);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)Utility.localizedLabel(Messages.nameKey(opponent.getNationType().getCapitalType().getId())), "left, wrap");
        label = Utility.localizedLabel("report.indian.numberOfSettlements");
        this.reportPanel.add(label);
        label.setFont(font);
        this.reportPanel.add((Component)new JLabel(numSettlements), "left, wrap");
        label = Utility.localizedLabel("report.indian.tribeTension");
        this.reportPanel.add(label);
        label.setFont(font);
        this.reportPanel.add((Component)Utility.localizedLabel(((StringTemplate)StringTemplate.template("report.indian.tensionStance").addNamed("%tension%", opponent.getTension(player))).addNamed("%stance%", opponent.getStance(player))), "left, wrap 20");
        if (nativeSettlements.isEmpty()) {
            this.reportPanel.add(Utility.localizedLabel("report.indian.noKnownSettlements"));
        } else {
            for (String key : headlines) {
                JLabel head = Utility.localizedLabel(key);
                head.setFont(font);
                this.reportPanel.add(head);
            }
            ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>(nativeSettlements.size());
            for (IndianSettlement is : nativeSettlements) {
                if (is.isCapital()) {
                    settlements.add(0, is);
                    continue;
                }
                settlements.add(is);
            }
            for (IndianSettlement is : settlements) {
                JLabel skillLabel;
                Tile tile = is.getTile();
                boolean known = tile.isExplored();
                boolean contacted = is.hasContacted(player);
                boolean visited = is.hasVisited(player);
                Object locationName = Messages.message(is.getLocationLabelFor(player));
                if (known && is.isCapital()) {
                    locationName = (String)locationName + ResourceManager.getString("indianSettlementChip.capital");
                }
                if (is.worthScouting(player)) {
                    locationName = (String)locationName + ResourceManager.getString("unscoutedIndianSettlement");
                }
                JButton settlementButton = Utility.getLinkButton((String)locationName, null, is.getTile().getId());
                Utility.localizeToolTip((JComponent)settlementButton, is.getTile().getLocationLabelFor(player));
                settlementButton.addActionListener(this);
                this.reportPanel.add((Component)settlementButton, "newline 15");
                Unit missionary = is.getMissionary();
                JLabel missionLabel = new JLabel("");
                if (missionary != null) {
                    BufferedImage dummy = new BufferedImage(1, 1, 2);
                    Graphics2D g = dummy.createGraphics();
                    missionLabel.setIcon(new ImageIcon(lib.getMissionChip(g, missionary.getOwner(), missionary.hasAbility("model.ability.expertMissionary"))));
                    g.dispose();
                    Utility.localizeToolTip((JComponent)missionLabel, Messages.message(missionary.getLabel(Unit.UnitLabelType.NATIONAL)));
                }
                this.reportPanel.add(missionLabel);
                this.reportPanel.add(Utility.localizedLabel(is.getAlarmLevelKey(player)));
                UnitType skillType = is.getLearnableSkill();
                if (visited && skillType != null) {
                    skillLabel = new JLabel("");
                    skillLabel.setIcon(new ImageIcon(lib.getSmallUnitTypeImage(skillType)));
                    Utility.localizeToolTip((JComponent)skillLabel, Messages.message(is.getLearnableSkillLabel(visited)));
                } else {
                    skillLabel = Utility.localizedLabel(is.getLearnableSkillLabel(visited));
                }
                this.reportPanel.add(skillLabel);
                this.reportPanel.add(Utility.localizedLabel(is.getMostHatedLabel(contacted)));
                int n = visited ? is.getWantedGoodsCount() : 1;
                String x = n > 1 ? "split " + Integer.toString(n) : null;
                for (int i = 0; i < n; ++i) {
                    JLabel goodsLabel;
                    GoodsType gt;
                    List<StringTemplate> gl = is.getWantedGoodsLabel(i, player);
                    if (visited && (gt = is.getWantedGoods(i)) != null) {
                        goodsLabel = new JLabel("");
                        goodsLabel.setIcon(new ImageIcon(lib.getSmallGoodsTypeImage(gt)));
                        Utility.localizeToolTip((JComponent)goodsLabel, Messages.message(gl.get(0)));
                    } else {
                        goodsLabel = Utility.localizedLabel(gl.get(0));
                    }
                    this.reportPanel.add((Component)goodsLabel, x);
                    x = null;
                }
            }
        }
    }
}

