/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class LanguageOption
extends AbstractOption<Language> {
    private static final Logger logger = Logger.getLogger(LanguageOption.class.getName());
    public static final String TAG = "languageOption";
    private static final Map<String, String> languageNames = CollectionUtils.makeUnmodifiableMap(new String[]{"arz", "hsb", "nds", "pms", "be-tarask"}, new String[]{"\u0645\u0635\u0631\u064a", "Serb\u0161\u0107ina", "Plattd\u00fc\u00fctsch", "Piemont\u00e9s", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f (\u0442\u0430\u0440\u0430\u0448\u043a\u0435\u0432\u0456\u0446\u0430)"});
    private static final List<Language> languages = new ArrayList<Language>();
    private static final Language DEFAULT_LANGUAGE = new Language("automatic", Locale.getDefault());
    private Language value = DEFAULT_LANGUAGE;

    public LanguageOption(Specification specification) {
        super(specification);
        LanguageOption.initializeLanguages();
    }

    private static void initializeLanguages() {
        if (!languages.isEmpty()) {
            return;
        }
        for (String languageId : FreeColDirectories.getLanguageIdList()) {
            if (languageId == null) continue;
            try {
                languages.add(new Language(languageId, Messages.getLocale(languageId)));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to add: " + languageId, e);
            }
        }
        languages.sort(Comparator.naturalOrder());
        languages.add(0, DEFAULT_LANGUAGE);
    }

    private Language getLanguage(String key) {
        return CollectionUtils.find(languages, l -> key.equals(l.getKey()));
    }

    public List<Language> getChoices() {
        return new ArrayList<Language>(languages);
    }

    @Override
    public LanguageOption cloneOption() {
        LanguageOption result = new LanguageOption(this.getSpecification());
        result.setValues(this);
        return result;
    }

    @Override
    public final Language getValue() {
        return this.value;
    }

    @Override
    public final void setValue(Language newValue) {
        Language oldValue = this.value;
        this.value = newValue;
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    protected void setValue(String valueString, String defaultValueString) {
        Language l = null;
        if (l == null && valueString != null) {
            l = this.getLanguage(valueString);
        }
        if (l == null && defaultValueString != null) {
            l = this.getLanguage(defaultValueString);
        }
        if (l == null) {
            l = this.getLanguage("automatic");
        }
        this.setValue(l);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.getValue().getKey());
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static class Language
    implements Comparable<Language> {
        private String key;
        private Locale locale;

        public Language(String key, Locale locale) {
            this.key = key;
            this.locale = locale;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String newKey) {
            this.key = newKey;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final void setLocale(Locale newLocale) {
            this.locale = newLocale;
        }

        @Override
        public int compareTo(Language l) {
            return this.toString().compareTo(l.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Language) {
                Language other = (Language)o;
                return Utils.equals(this.key, other.key) && super.equals(other);
            }
            return false;
        }

        public int hashCode() {
            int hash = super.hashCode();
            return 31 * hash + Utils.hashCode(this.key);
        }

        public String toString() {
            if ("automatic".equals(this.getKey())) {
                return Messages.message("clientOptions.gui.languageOption.autoDetectLanguage");
            }
            String name = this.locale.getDisplayName(this.locale);
            if (name.equals(this.key) && languageNames.containsKey(this.key)) {
                name = languageNames.get(this.key);
            }
            return StringUtils.capitalize(name, this.locale);
        }
    }
}

