/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class ModelMessage
extends StringTemplate {
    public static final String TAG = "modelMessage";
    public static final Comparator<ModelMessage> messageTypeComparator = (m1, m2) -> m1.getMessageType().ordinal() - m2.getMessageType().ordinal();
    private String sourceId;
    private String displayId;
    private MessageType messageType;
    private boolean displayed = false;
    private static final String DISPLAY_TAG = "display";
    private static final String HAS_BEEN_DISPLAYED_TAG = "hasBeenDisplayed";
    private static final String MESSAGE_TYPE_TAG = "messageType";
    private static final String SOURCE_TAG = "source";

    public ModelMessage() {
    }

    public ModelMessage(MessageType messageType, String id, String defaultId, FreeColGameObject source, FreeColObject display) {
        super(id, defaultId, StringTemplate.TemplateType.TEMPLATE);
        this.messageType = messageType;
        this.sourceId = source.getId();
        this.displayId = display != null ? display.getId() : source.getId();
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source, FreeColObject display) {
        this(messageType, id, null, source, display);
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source) {
        this(messageType, id, source, ModelMessage.getDefaultDisplay(messageType, source));
    }

    public ModelMessage(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public void divert(FreeColGameObject newSource) {
        if (Utils.equals(this.displayId, this.sourceId)) {
            this.displayId = newSource.getId();
        }
        this.sourceId = newSource.getId();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getOptionName() {
        return this.messageType == null ? null : this.messageType.getOptionName();
    }

    public boolean getDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public ModelMessage addDefaultId(String id) {
        return super.setDefaultId(id, ModelMessage.class);
    }

    private static FreeColObject getDefaultDisplay(MessageType messageType, FreeColGameObject source) {
        FreeColObject o = null;
        switch (messageType) {
            case SONS_OF_LIBERTY: 
            case GOVERNMENT_EFFICIENCY: {
                o = source.getSpecification().getGoodsType("model.goods.bells");
                break;
            }
            case UNIT_IMPROVED: 
            case UNIT_DEMOTED: 
            case UNIT_LOST: 
            case UNIT_ADDED: 
            case LOST_CITY_RUMOUR: 
            case COMBAT_RESULT: 
            case DEMANDS: 
            case GOODS_MOVEMENT: {
                o = source;
                break;
            }
            case BUILDING_COMPLETED: {
                o = source.getSpecification().getGoodsType("model.goods.hammers");
                break;
            }
            default: {
                if (!(source instanceof Player)) break;
                o = source;
            }
        }
        return o;
    }

    public String getIgnoredMessageKey() {
        switch (this.getMessageType()) {
            case WAREHOUSE_CAPACITY: {
                StringBuilder sb = new StringBuilder(64);
                sb.append(this.getSourceId());
                switch (this.getTemplateType()) {
                    case TEMPLATE: {
                        StringTemplate t = this.getReplacement("%goods%");
                        if (t == null) break;
                        sb.append('-').append(t.getId());
                        break;
                    }
                }
                return sb.toString();
            }
        }
        return null;
    }

    public List<Object> splitLinks(Player player) {
        FreeColGameObject source = player.getGame().getMessageSource(this);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(Messages.message(this));
        for (AbstractMap.SimpleEntry<String, StringTemplate> e : this.entryList()) {
            JButton b;
            String key = e.getKey();
            String val = Messages.message(e.getValue());
            if (val == null || (b = Utility.getMessageButton(key, val, player, source)) == null) continue;
            ArrayList<Object> next = new ArrayList<Object>();
            for (Object e2 : result) {
                if (e2 instanceof String) {
                    int index;
                    String str = (String)e2;
                    int start = 0;
                    while ((index = str.indexOf(val, start)) >= 0) {
                        if (index > start) {
                            next.add(str.substring(start, index));
                        }
                        next.add(Utility.getMessageButton(key, val, player, source));
                        start = index + val.length();
                    }
                    next.add(str.substring(start, str.length()));
                    continue;
                }
                next.add(e2);
            }
            result = next;
        }
        return result;
    }

    public static Comparator<ModelMessage> getSourceComparator(final Game game, final Map<String, Comparator<?>> specialized) {
        return new Comparator<ModelMessage>(){

            @Override
            public int compare(ModelMessage message1, ModelMessage message2) {
                String name;
                Comparator c;
                String sourceId2;
                String sourceId1 = message1.getSourceId();
                if (Utils.equals(sourceId1, sourceId2 = message2.getSourceId())) {
                    return messageTypeComparator.compare(message1, message2);
                }
                FreeColGameObject source1 = game.getMessageSource(message1);
                FreeColGameObject source2 = game.getMessageSource(message2);
                int base = FreeColObject.getObjectClassIndex(source1) - FreeColObject.getObjectClassIndex(source2);
                if (base == 0 && specialized != null && source1 != null && (c = (Comparator)specialized.get(name = source1.getClass().getName())) != null) {
                    base = c.compare(source1, source2);
                }
                return base;
            }
        };
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ModelMessage o = this.copyInCast(other, ModelMessage.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.sourceId = o.getSourceId();
        this.displayId = o.getDisplayId();
        this.messageType = o.getMessageType();
        this.displayed = o.getDisplayed();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(SOURCE_TAG, this.sourceId);
        if (this.displayId != null) {
            xw.writeAttribute(DISPLAY_TAG, this.displayId);
        }
        xw.writeAttribute(MESSAGE_TYPE_TAG, this.messageType);
        xw.writeAttribute(HAS_BEEN_DISPLAYED_TAG, this.displayed);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.sourceId = xr.getAttribute(SOURCE_TAG, null);
        this.displayId = xr.getAttribute(DISPLAY_TAG, null);
        this.messageType = xr.getAttribute(MESSAGE_TYPE_TAG, MessageType.class, MessageType.DEFAULT);
        this.displayed = xr.getAttribute(HAS_BEEN_DISPLAYED_TAG, false);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModelMessage) {
            ModelMessage other = (ModelMessage)o;
            return this.messageType == other.messageType && this.displayed == other.displayed && Utils.equals(this.sourceId, other.sourceId) && Utils.equals(this.displayId, other.displayId) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.sourceId != null) {
            hash = 37 * hash + this.sourceId.hashCode();
        }
        if (this.displayId != null) {
            hash = 37 * hash + this.displayId.hashCode();
        }
        hash = 37 * hash + this.messageType.ordinal();
        hash = 37 * hash + (this.displayed ? 1 : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("[ModelMessage ").append(this.hashCode()).append(' ').append(this.sourceId == null ? "null" : this.sourceId).append('/').append(this.displayId == null ? "null" : this.displayId).append(' ').append(this.messageType).append(' ').append(this.displayed).append(' ').append(super.toString()).append(']');
        return sb.toString();
    }

    public static enum MessageType implements Named
    {
        DEFAULT(""),
        BUILDING_COMPLETED("model.option.guiShowBuildingCompleted"),
        COMBAT_RESULT(null),
        DEMANDS("model.option.guiShowDemands"),
        DISASTERS("model.option.guiShowDisasters"),
        FOREIGN_DIPLOMACY("model.option.guiShowForeignDiplomacy"),
        GIFT_GOODS("model.option.guiShowGifts"),
        GOODS_MOVEMENT("model.option.guiShowGoodsMovement"),
        GOVERNMENT_EFFICIENCY("model.option.guiShowGovernmentEfficiency"),
        LOST_CITY_RUMOUR(null),
        MARKET_PRICES("model.option.guiShowMarketPrices"),
        MISSING_GOODS("model.option.guiShowMissingGoods"),
        SONS_OF_LIBERTY("model.option.guiShowSonsOfLiberty"),
        TUTORIAL("model.option.guiShowTutorial"),
        UNIT_ADDED("model.option.guiShowUnitAdded"),
        UNIT_ARRIVED("model.option.guiShowUnitArrived"),
        UNIT_DEMOTED("model.option.guiShowUnitDemoted"),
        UNIT_IMPROVED("model.option.guiShowUnitImproved"),
        UNIT_LOST("model.option.guiShowUnitLost"),
        UNIT_REPAIRED("model.option.guiShowUnitRepaired"),
        WAREHOUSE_CAPACITY("model.option.guiShowWarehouseCapacity"),
        WARNING("model.option.guiShowWarning");

        private final String optionName;

        private MessageType(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        private String getKey() {
            return "messageType." + StringUtils.getEnumKey(this);
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

