/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.IntegerOption;

public class SelectOption
extends IntegerOption {
    private static final Logger logger = Logger.getLogger(SelectOption.class.getName());
    public static final String TAG = "selectOption";
    protected boolean localizedLabels = false;
    private final Map<Integer, String> itemValues = new LinkedHashMap<Integer, String>();
    private static final String LABEL_TAG = "label";
    private static final String LOCALIZED_LABELS_TAG = "localizedLabels";

    public SelectOption(Specification specification) {
        super(specification);
    }

    public SelectOption(String id, Specification specification) {
        super(id, specification);
    }

    public String getName() {
        return this.itemValues.get(this.getValue());
    }

    public Map<Integer, String> getItemValues() {
        return this.itemValues;
    }

    public void addItemValue(Integer key, String value) {
        this.itemValues.put(key, value);
    }

    public void clearItemValues() {
        this.itemValues.clear();
    }

    public boolean localizeLabels() {
        return this.localizedLabels;
    }

    public String getXMLItemElementTagName() {
        return "selectValue";
    }

    @Override
    public void setValue(Integer value) {
        Set<Integer> keys = this.getItemValues().keySet();
        if (keys.isEmpty()) {
            return;
        }
        Integer fallback = null;
        for (Integer i : keys) {
            if (i.compareTo(value) == 0) {
                super.setValue(value);
                return;
            }
            if (fallback != null) continue;
            fallback = i;
        }
        logger.warning("selectOption.setValue invalid value: " + value + ", using fallback: " + fallback);
        super.setValue(fallback);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(LOCALIZED_LABELS_TAG, this.localizedLabels);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Map.Entry<Integer, String> entry : this.itemValues.entrySet()) {
            xw.writeStartElement(this.getXMLItemElementTagName());
            xw.writeAttribute("value", entry.getKey());
            xw.writeAttribute(LABEL_TAG, entry.getValue());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.localizedLabels = xr.getAttribute(LOCALIZED_LABELS_TAG, true);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        String value = xr.getAttribute("value", null);
        String defaultValue = xr.getAttribute("defaultValue", null);
        this.clearItemValues();
        super.readChildren(xr);
        this.setValue(value, defaultValue);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (this.getXMLItemElementTagName().equals(tag)) {
            this.addItemValue(xr.getAttribute("value", Integer.MAX_VALUE), xr.getAttribute(LABEL_TAG, null));
            xr.closeTag(tag);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(" value=").append(this.getValue()).append(" localized=").append(this.localizedLabels).append(']');
        return sb.toString();
    }
}

