/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultModuleExclude
implements ModuleExclude {
    private final String module;
    private final int hashCode;

    public static ModuleExclude of(String module) {
        return new DefaultModuleExclude(module);
    }

    private DefaultModuleExclude(String module) {
        this.module = module;
        this.hashCode = module.hashCode();
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        return this.module.equals(module.getName());
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleExclude that = (DefaultModuleExclude)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.module.equals(that.module);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "{\"exclude module\" : \"" + this.module + "\"}";
    }
}

