/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.NonNullApi;
import org.gradle.internal.Cast;
import org.gradle.internal.classpath.GroovyCallInterceptorsProvider;
import org.gradle.internal.classpath.intercept.CallInterceptor;

@NonNullApi
public class GroovyCallInterceptorsProvisionTools {
    private GroovyCallInterceptorsProvisionTools() {
    }

    static List<CallInterceptor> getInterceptorsFromProvider(GroovyCallInterceptorsProvider provider) {
        return provider.getInterceptorProviderClassNames().stream().flatMap(it -> GroovyCallInterceptorsProvisionTools.getInterceptorsFromClass(it).stream()).collect(Collectors.toList());
    }

    static List<CallInterceptor> getInterceptorsFromClass(String className) {
        try {
            return GroovyCallInterceptorsProvisionTools.getInterceptorsFromClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static List<CallInterceptor> getInterceptorsFromClass(Class<?> interceptorsProviderClass) {
        List result;
        Method getCallInterceptors;
        try {
            getCallInterceptors = interceptorsProviderClass.getDeclaredMethod("getCallInterceptors", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The provider class does not have the expected getCallInterceptors method", e);
        }
        try {
            result = (List)Cast.uncheckedNonnullCast((Object)getCallInterceptors.invoke(null, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access the getCallInterceptors method in the provider class", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

