/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.InvalidRrdException;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdInt;
import org.rrd4j.core.RrdLong;
import org.rrd4j.core.RrdString;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class Header
implements RrdUpdater<Header> {
    static final int SIGNATURE_LENGTH = 5;
    static final String SIGNATURE = "RRD4J";
    static final String DEFAULT_SIGNATURE = "RRD4J, version 0.1";
    static final String RRDTOOL_VERSION1 = "0001";
    static final String RRDTOOL_VERSION3 = "0003";
    private static final String[] VERSIONS = new String[]{"version 0.1", "version 0.2"};
    private final RrdDb parentDb;
    private int version = -1;
    private final RrdString<Header> signature;
    private final RrdLong<Header> step;
    private final RrdInt<Header> dsCount;
    private final RrdInt<Header> arcCount;
    private final RrdLong<Header> lastUpdateTime;

    Header(RrdDb parentDb, RrdDef rrdDef) throws IOException {
        String initSignature;
        this.parentDb = parentDb;
        if (rrdDef != null) {
            this.version = rrdDef.getVersion();
            initSignature = "RRD4J, " + VERSIONS[this.version - 1];
        } else {
            initSignature = DEFAULT_SIGNATURE;
        }
        this.signature = new RrdString<Header>(this);
        this.step = new RrdLong<Header>(this, true);
        this.dsCount = new RrdInt<Header>(this, true);
        this.arcCount = new RrdInt<Header>(this, true);
        this.lastUpdateTime = new RrdLong<Header>(this);
        if (rrdDef != null) {
            this.signature.set(initSignature);
            this.step.set(rrdDef.getStep());
            this.dsCount.set(rrdDef.getDsCount());
            this.arcCount.set(rrdDef.getArcCount());
            this.lastUpdateTime.set(rrdDef.getStartTime());
        }
    }

    Header(RrdDb parentDb, DataImporter reader) throws IOException {
        this(parentDb, (RrdDef)null);
        String importVersion;
        switch (importVersion = reader.getVersion()) {
            case "0001": {
                this.version = 1;
                break;
            }
            case "0003": {
                this.version = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not get version " + this.version);
            }
        }
        this.signature.set("RRD4J, " + VERSIONS[this.version - 1]);
        this.step.set(reader.getStep());
        this.dsCount.set(reader.getDsCount());
        this.arcCount.set(reader.getArcCount());
        this.lastUpdateTime.set(reader.getLastUpdateTime());
    }

    public String getSignature() throws IOException {
        return this.signature.get();
    }

    public String getInfo() throws IOException {
        return this.getSignature().substring(5);
    }

    public void setInfo(String info) throws IOException {
        if (info != null && info.length() > 0) {
            this.signature.set(SIGNATURE + info);
        } else {
            this.signature.set(SIGNATURE);
        }
    }

    public long getLastUpdateTime() throws IOException {
        return this.lastUpdateTime.get();
    }

    public long getStep() throws IOException {
        return this.step.get();
    }

    public int getDsCount() throws IOException {
        return this.dsCount.get();
    }

    public int getArcCount() throws IOException {
        return this.arcCount.get();
    }

    void setLastUpdateTime(long lastUpdateTime) throws IOException {
        this.lastUpdateTime.set(lastUpdateTime);
    }

    String dump() throws IOException {
        return "== HEADER ==\nsignature:" + this.getSignature() + " lastUpdateTime:" + this.getLastUpdateTime() + " step:" + this.getStep() + " dsCount:" + this.getDsCount() + " arcCount:" + this.getArcCount() + "\n";
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.writeComment(this.signature.get());
        writer.writeTag("version", RRDTOOL_VERSION3);
        writer.writeComment("Seconds");
        writer.writeTag("step", this.step.get());
        writer.writeComment(Util.getDate(this.lastUpdateTime.get()));
        writer.writeTag("lastupdate", this.lastUpdateTime.get());
    }

    @Override
    public void copyStateTo(Header header) throws IOException {
        header.lastUpdateTime.set(this.lastUpdateTime.get());
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    public int getVersion() throws IOException {
        if (this.version < 0) {
            for (int i = 0; i < VERSIONS.length; ++i) {
                if (!this.signature.get().endsWith(VERSIONS[i])) continue;
                this.version = i + 1;
                break;
            }
        }
        return this.version;
    }

    boolean isRrd4jHeader() {
        try {
            return this.signature.get().startsWith(SIGNATURE) || this.signature.get().startsWith("JR");
        }
        catch (IOException ioe) {
            return false;
        }
    }

    void validateHeader() throws IOException {
        if (!this.isRrd4jHeader()) {
            throw new InvalidRrdException("Invalid file header. File [" + this.parentDb.getCanonicalPath() + "] is not a RRD4J RRD file");
        }
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

