/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeVisitor;
import org.jitsi.nlj.transform.node.ConditionalPacketPath;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.StatsKeepingNode;
import org.jitsi.rtp.Packet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ-\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00102\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/jitsi/nlj/transform/node/DemuxerNode;", "Lorg/jitsi/nlj/transform/node/StatsKeepingNode;", "name", "", "<init>", "(Ljava/lang/String;)V", "transformPaths", "", "Lorg/jitsi/nlj/transform/node/ConditionalPacketPath;", "getTransformPaths", "()Ljava/util/Set;", "setTransformPaths", "(Ljava/util/Set;)V", "addPacketPath", "packetPath", "predicate", "Lorg/jitsi/nlj/util/PacketPredicate;", "Ljava/util/function/Predicate;", "Lorg/jitsi/rtp/Packet;", "root", "Lorg/jitsi/nlj/transform/node/Node;", "(Ljava/lang/String;Ljava/util/function/Predicate;Lorg/jitsi/nlj/transform/node/Node;)Lorg/jitsi/nlj/transform/node/DemuxerNode;", "removePacketPaths", "", "attach", "", "node", "detachNext", "visit", "visitor", "Lorg/jitsi/nlj/transform/NodeVisitor;", "getChildren", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\norg/jitsi/nlj/transform/node/DemuxerNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,554:1\n1863#2,2:555\n1863#2,2:557\n1557#2:559\n1628#2,3:560\n1863#2,2:563\n*S KotlinDebug\n*F\n+ 1 Node.kt\norg/jitsi/nlj/transform/node/DemuxerNode\n*L\n509#1:555,2\n518#1:557,2\n523#1:559\n523#1:560,3\n528#1:563,2\n*E\n"})
public abstract class DemuxerNode
extends StatsKeepingNode {
    @NotNull
    private Set<ConditionalPacketPath> transformPaths;

    public DemuxerNode(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(name + " demuxer", null);
        this.transformPaths = new CopyOnWriteArraySet();
    }

    @NotNull
    protected final Set<ConditionalPacketPath> getTransformPaths() {
        return this.transformPaths;
    }

    protected final void setTransformPaths(@NotNull Set<ConditionalPacketPath> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.transformPaths = set;
    }

    @NotNull
    public final DemuxerNode addPacketPath(@NotNull ConditionalPacketPath packetPath) {
        Intrinsics.checkNotNullParameter(packetPath, "packetPath");
        this.transformPaths.add(packetPath);
        packetPath.getPath().addParent(this);
        return this;
    }

    @NotNull
    public final DemuxerNode addPacketPath(@NotNull String name, @NotNull Predicate<Packet> predicate, @NotNull Node root) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(root, "root");
        ConditionalPacketPath path = new ConditionalPacketPath(name);
        path.setPredicate(predicate);
        path.setPath(root);
        return this.addPacketPath(path);
    }

    public final void removePacketPaths() {
        Iterable $this$forEach$iv = this.transformPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConditionalPacketPath it = (ConditionalPacketPath)element$iv;
            boolean bl = false;
            it.getPath().removeParent(this);
        }
        this.transformPaths.clear();
    }

    @NotNull
    public Void attach(@NotNull Node node2) {
        Intrinsics.checkNotNullParameter(node2, "node");
        throw new Exception();
    }

    @NotNull
    public Void detachNext() {
        throw new Exception();
    }

    @Override
    public void visit(@NotNull NodeVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        visitor2.visit(this);
        Iterable $this$forEach$iv = this.transformPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConditionalPacketPath conditionalPath = (ConditionalPacketPath)element$iv;
            boolean bl = false;
            conditionalPath.getPath().visit(visitor2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Node> getChildren() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.transformPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConditionalPacketPath conditionalPacketPath = (ConditionalPacketPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock superStats = super.getNodeStats();
        Iterable $this$forEach$iv = this.transformPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConditionalPacketPath path = (ConditionalPacketPath)element$iv;
            boolean bl = false;
            superStats.addNumber("packets_accepted_" + path.getName(), path.getPacketsAccepted());
        }
        return superStats;
    }
}

