/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.sctp4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi_modified.sctp4j.SctpClientSocket;
import org.jitsi_modified.sctp4j.SctpJni;
import org.jitsi_modified.sctp4j.SctpServerSocket;
import org.jitsi_modified.sctp4j.SctpSocket;

public class Sctp4j {
    private static boolean initialized = false;
    private static final Logger classLogger = new LoggerImpl(Sctp4j.class.toString());
    public static final int MSG_NOTIFICATION = 8192;
    private static final Map<Long, SctpSocket> sockets = new ConcurrentHashMap<Long, SctpSocket>();
    private static AtomicLong nextId = new AtomicLong(1L);

    public static void init(int port2) {
        if (!initialized) {
            SctpJni.usrsctp_init(port2);
            initialized = true;
            SctpJni.incomingSctpDataHandler = Sctp4j::onSctpIncomingData;
            SctpJni.outgoingSctpDataHandler = Sctp4j::onOutgoingSctpData;
        }
    }

    static void closeSocket(long ptr, long id) {
        SctpJni.usrsctp_close(ptr);
        sockets.remove(id);
    }

    private static void onSctpIncomingData(long socketAddr, byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            socket.onSctpIn(data, sid, ssn, tsn, ppid, context, flags);
        } else {
            classLogger.error("No socket found in onSctpIncomingData");
        }
    }

    private static int onOutgoingSctpData(long socketAddr, byte[] data, int tos, int set_df) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket != null) {
            return socket.onSctpOut(data, tos, set_df);
        }
        classLogger.error("No socket found in onOutgoingSctpData");
        return -1;
    }

    public static SctpServerSocket createServerSocket(int localSctpPort, Logger parentLogger) {
        long id = nextId.getAndIncrement();
        long ptr = SctpJni.usrsctp_socket(localSctpPort, id);
        if (ptr == 0L) {
            parentLogger.error("Failed to create server socket");
            return null;
        }
        SctpServerSocket socket = new SctpServerSocket(ptr, id, parentLogger);
        sockets.put(id, socket);
        return socket;
    }

    public static SctpClientSocket createClientSocket(int localSctpPort, Logger parentLogger) {
        long id = nextId.getAndIncrement();
        long ptr = SctpJni.usrsctp_socket(localSctpPort, id);
        if (ptr == 0L) {
            parentLogger.error("Failed to create client socket");
            return null;
        }
        SctpClientSocket socket = new SctpClientSocket(ptr, id, parentLogger);
        sockets.put(id, socket);
        return socket;
    }
}

