/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.voice.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.voice.internal.HLIMapper;
import org.openhab.core.io.rest.voice.internal.HumanLanguageInterpreterDTO;
import org.openhab.core.io.rest.voice.internal.VoiceDTO;
import org.openhab.core.io.rest.voice.internal.VoiceMapper;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.STTService;
import org.openhab.core.voice.TTSService;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.VoiceManager;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="voice")
@RolesAllowed(value={"user", "administrator"})
@Tag(name="voice")
@Component
@JaxrsResource
@JaxrsName(value="voice")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class VoiceResource
implements RESTResource {
    public static final String PATH_VOICE = "voice";
    private final Logger logger = LoggerFactory.getLogger(VoiceResource.class);
    private final LocaleService localeService;
    private final AudioManager audioManager;
    private final VoiceManager voiceManager;

    @Activate
    public VoiceResource(@Reference LocaleService localeService, @Reference AudioManager audioManager, @Reference VoiceManager voiceManager) {
        this.localeService = localeService;
        this.audioManager = audioManager;
        this.voiceManager = voiceManager;
    }

    @GET
    @Path(value="/interpreters")
    @Produces(value={"application/json"})
    @Operation(operationId="getVoiceInterpreters", summary="Get the list of all interpreters.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=HumanLanguageInterpreterDTO.class)))})})
    public Response getInterpreters(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        List<HumanLanguageInterpreterDTO> dtos = this.voiceManager.getHLIs().stream().map(hli -> HLIMapper.map(hli, locale)).toList();
        return Response.ok(dtos).build();
    }

    @GET
    @Path(value="/interpreters/{id: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getVoiceInterpreterByUID", summary="Gets a single interpreter.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=HumanLanguageInterpreterDTO.class)))}), @ApiResponse(responseCode="404", description="Interpreter not found")})
    public Response getInterpreter(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="id") @Parameter(description="interpreter id") String id) {
        Locale locale = this.localeService.getLocale(language);
        HumanLanguageInterpreter hli = this.voiceManager.getHLI(id);
        if (hli == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"No interpreter found");
        }
        HumanLanguageInterpreterDTO dto = HLIMapper.map(hli, locale);
        return Response.ok((Object)dto).build();
    }

    @POST
    @Path(value="/interpreters/{ids: [a-zA-Z_0-9,]+}")
    @Consumes(value={"text/plain"})
    @Operation(operationId="interpretText", summary="Sends a text to a given human language interpreter(s).", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="No human language interpreter was found."), @ApiResponse(responseCode="400", description="interpretation exception occurs")})
    public Response interpret(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @Parameter(description="text to interpret", required=true) String text, @PathParam(value="ids") @Parameter(description="comma separated list of interpreter ids") List<String> ids) {
        Locale locale = this.localeService.getLocale(language);
        List hlis = this.voiceManager.getHLIsByIds(ids);
        if (hlis.isEmpty()) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"No interpreter found");
        }
        String answer = "";
        String error = null;
        for (HumanLanguageInterpreter interpreter : hlis) {
            try {
                answer = interpreter.interpret(locale, text);
                this.logger.debug("Interpretation result: {}", (Object)answer);
                error = null;
                break;
            }
            catch (InterpretationException e) {
                this.logger.debug("Interpretation exception: {}", (Object)e.getMessage());
                error = Objects.requireNonNullElse(e.getMessage(), "Unexpected error");
            }
        }
        if (error != null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, error);
        }
        return Response.ok((Object)answer, (String)"text/plain").build();
    }

    @POST
    @Path(value="/interpreters")
    @Consumes(value={"text/plain"})
    @Operation(operationId="interpretTextByDefaultInterpreter", summary="Sends a text to the default human language interpreter.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="No human language interpreter was found."), @ApiResponse(responseCode="400", description="interpretation exception occurs")})
    public Response interpret(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @Parameter(description="text to interpret", required=true) String text) {
        Locale locale = this.localeService.getLocale(language);
        HumanLanguageInterpreter hli = this.voiceManager.getHLI();
        if (hli == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"No interpreter found");
        }
        try {
            hli.interpret(locale, text);
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (InterpretationException e) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
    }

    @GET
    @Path(value="/voices")
    @Produces(value={"application/json"})
    @Operation(operationId="getVoices", summary="Get the list of all voices.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=VoiceDTO.class)))})})
    public Response getVoices() {
        List<VoiceDTO> dtos = this.voiceManager.getAllVoices().stream().map(VoiceMapper::map).toList();
        return Response.ok(dtos).build();
    }

    @GET
    @Path(value="/defaultvoice")
    @Produces(value={"application/json"})
    @Operation(operationId="getDefaultVoice", summary="Gets the default voice.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=VoiceDTO.class))}), @ApiResponse(responseCode="404", description="No default voice was found.")})
    public Response getDefaultVoice() {
        Voice voice = this.voiceManager.getDefaultVoice();
        if (voice == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Default voice not found");
        }
        VoiceDTO dto = VoiceMapper.map(voice);
        return Response.ok((Object)dto).build();
    }

    @POST
    @Path(value="/say")
    @Consumes(value={"text/plain"})
    @Operation(operationId="textToSpeech", summary="Speaks a given text with a given voice through the given audio sink.", responses={@ApiResponse(responseCode="200", description="OK")})
    public Response say(@Parameter(description="text to speak", required=true) String text, @QueryParam(value="voiceid") @Parameter(description="voice id") @Nullable String voiceId, @QueryParam(value="sinkid") @Parameter(description="audio sink id") @Nullable String sinkId, @QueryParam(value="volume") @Parameter(description="volume level") @Nullable String volume) {
        PercentType volumePercent = null;
        if (volume != null && !volume.isBlank()) {
            volumePercent = new PercentType(volume);
        }
        this.voiceManager.say(text, voiceId, sinkId, volumePercent);
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/dialog/start")
    @Consumes(value={"text/plain"})
    @Operation(operationId="startDialog", summary="Start dialog processing for a given audio source.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the given ids is wrong."), @ApiResponse(responseCode="400", description="Services are missing or language is not supported by services or dialog processing is already started for the audio source.")})
    public Response startDialog(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="sourceId") @Parameter(description="source ID") @Nullable String sourceId, @QueryParam(value="ksId") @Parameter(description="keywork spotter ID") @Nullable String ksId, @QueryParam(value="sttId") @Parameter(description="Speech-to-Text ID") @Nullable String sttId, @QueryParam(value="ttsId") @Parameter(description="Text-to-Speech ID") @Nullable String ttsId, @QueryParam(value="voiceId") @Parameter(description="voice ID") @Nullable String voiceId, @QueryParam(value="hliIds") @Parameter(description="comma separated list of interpreter IDs") @Nullable String hliIds, @QueryParam(value="sinkId") @Parameter(description="audio sink ID") @Nullable String sinkId, @QueryParam(value="keyword") @Parameter(description="keyword") @Nullable String keyword, @QueryParam(value="listeningItem") @Parameter(description="listening item") @Nullable String listeningItem) {
        DialogContext.Builder dialogContextBuilder = this.voiceManager.getDialogContextBuilder();
        if (sourceId != null) {
            AudioSource source = this.audioManager.getSource(sourceId);
            if (source == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Audio source not found");
            }
            dialogContextBuilder.withSource(source);
        }
        if (ksId != null) {
            KSService ks = this.voiceManager.getKS(ksId);
            if (ks == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Keyword spotter not found");
            }
            dialogContextBuilder.withKS(ks);
        }
        if (sttId != null) {
            STTService stt = this.voiceManager.getSTT(sttId);
            if (stt == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Speech-to-Text not found");
            }
            dialogContextBuilder.withSTT(stt);
        }
        if (ttsId != null) {
            TTSService tts = this.voiceManager.getTTS(ttsId);
            if (tts == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Text-to-Speech not found");
            }
            dialogContextBuilder.withTTS(tts);
        }
        if (voiceId != null) {
            Voice voice = this.getVoice(voiceId);
            if (voice == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Voice not found");
            }
            dialogContextBuilder.withVoice(voice);
        }
        if (hliIds != null) {
            List interpreters = this.voiceManager.getHLIsByIds(hliIds);
            if (interpreters.isEmpty()) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Interpreter not found");
            }
            dialogContextBuilder.withHLIs(interpreters);
        }
        if (sinkId != null) {
            AudioSink sink = this.audioManager.getSink(sinkId);
            if (sink == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Audio sink not found");
            }
            dialogContextBuilder.withSink(sink);
        }
        if (listeningItem != null) {
            dialogContextBuilder.withListeningItem(listeningItem);
        }
        if (keyword != null) {
            dialogContextBuilder.withKeyword(keyword);
        }
        try {
            this.voiceManager.startDialog(dialogContextBuilder.withLocale(this.localeService.getLocale(language)).build());
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (IllegalStateException e) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
    }

    @POST
    @Path(value="/dialog/stop")
    @Consumes(value={"text/plain"})
    @Operation(operationId="stopDialog", summary="Stop dialog processing for a given audio source.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="No audio source was found."), @ApiResponse(responseCode="400", description="No dialog processing is started for the audio source.")})
    public Response stopDialog(@QueryParam(value="sourceId") @Parameter(description="source ID") @Nullable String sourceId) {
        AudioSource source = null;
        if (sourceId != null && (source = this.audioManager.getSource(sourceId)) == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Audio source not found");
        }
        try {
            this.voiceManager.stopDialog(source);
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (IllegalStateException e) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
    }

    @POST
    @Path(value="/listenandanswer")
    @Consumes(value={"text/plain"})
    @Operation(operationId="listenAndAnswer", summary="Executes a simple dialog sequence without keyword spotting for a given audio source.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="One of the given ids is wrong."), @ApiResponse(responseCode="400", description="Services are missing or language is not supported by services or dialog processing is already started for the audio source.")})
    public Response listenAndAnswer(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="sourceId") @Parameter(description="source ID") @Nullable String sourceId, @QueryParam(value="sttId") @Parameter(description="Speech-to-Text ID") @Nullable String sttId, @QueryParam(value="ttsId") @Parameter(description="Text-to-Speech ID") @Nullable String ttsId, @QueryParam(value="voiceId") @Parameter(description="voice ID") @Nullable String voiceId, @QueryParam(value="hliIds") @Parameter(description="interpreter IDs") @Nullable List<String> hliIds, @QueryParam(value="sinkId") @Parameter(description="audio sink ID") @Nullable String sinkId, @QueryParam(value="listeningItem") @Parameter(description="listening item") @Nullable String listeningItem) {
        DialogContext.Builder dialogContextBuilder = this.voiceManager.getDialogContextBuilder();
        if (sourceId != null) {
            AudioSource source = this.audioManager.getSource(sourceId);
            if (source == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Audio source not found");
            }
            dialogContextBuilder.withSource(source);
        }
        if (sttId != null) {
            STTService stt = this.voiceManager.getSTT(sttId);
            if (stt == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Speech-to-Text not found");
            }
            dialogContextBuilder.withSTT(stt);
        }
        if (ttsId != null) {
            TTSService tts = this.voiceManager.getTTS(ttsId);
            if (tts == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Text-to-Speech not found");
            }
            dialogContextBuilder.withTTS(tts);
        }
        if (voiceId != null) {
            Voice voice = this.getVoice(voiceId);
            if (voice == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Voice not found");
            }
            dialogContextBuilder.withVoice(voice);
        }
        if (hliIds != null) {
            List interpreters = this.voiceManager.getHLIsByIds(hliIds);
            if (interpreters.isEmpty()) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Interpreter not found");
            }
            dialogContextBuilder.withHLIs(interpreters);
        }
        if (sinkId != null) {
            AudioSink sink = this.audioManager.getSink(sinkId);
            if (sink == null) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Audio sink not found");
            }
            dialogContextBuilder.withSink(sink);
        }
        try {
            this.voiceManager.listenAndAnswer(dialogContextBuilder.withLocale(this.localeService.getLocale(language)).build());
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (IllegalStateException e) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
    }

    private @Nullable Voice getVoice(String id) {
        return this.voiceManager.getAllVoices().stream().filter(voice -> voice.getUID().equals(id)).findAny().orElse(null);
    }
}

