/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.internal.items.DefaultStateDescriptionFragmentProvider;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemProvider;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemStateConverter;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.ManagedItemProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataAwareItem;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.items.RegistryHook;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.service.CommandDescriptionService;
import org.openhab.core.service.ReadyService;
import org.openhab.core.service.StateDescriptionService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class ItemRegistryImpl
extends AbstractRegistry<Item, String, ItemProvider>
implements ItemRegistry,
RegistryChangeListener<Metadata> {
    private final Logger logger = LoggerFactory.getLogger(ItemRegistryImpl.class);
    private final List<RegistryHook<Item>> registryHooks = new CopyOnWriteArrayList<RegistryHook<Item>>();
    private @Nullable StateDescriptionService stateDescriptionService;
    private @Nullable CommandDescriptionService commandDescriptionService;
    private final MetadataRegistry metadataRegistry;
    private final DefaultStateDescriptionFragmentProvider defaultStateDescriptionFragmentProvider;
    private @Nullable ItemStateConverter itemStateConverter;

    @Activate
    public ItemRegistryImpl(@Reference MetadataRegistry metadataRegistry, @Reference DefaultStateDescriptionFragmentProvider defaultStateDescriptionFragmentProvider) {
        super(ItemProvider.class);
        this.metadataRegistry = metadataRegistry;
        this.defaultStateDescriptionFragmentProvider = defaultStateDescriptionFragmentProvider;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext.getBundleContext());
        this.metadataRegistry.addRegistryChangeListener(this);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this.metadataRegistry.removeRegistryChangeListener(this);
        super.deactivate();
    }

    @Override
    public Item getItem(String name) throws ItemNotFoundException {
        Item item = (Item)this.get(name);
        if (item == null) {
            throw new ItemNotFoundException(name);
        }
        return item;
    }

    @Override
    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        Collection<Item> items = this.getItems(name);
        if (items.isEmpty()) {
            throw new ItemNotFoundException(name);
        }
        if (items.size() > 1) {
            throw new ItemNotUniqueException(name, items);
        }
        return items.iterator().next();
    }

    @Override
    public Collection<Item> getItems() {
        return this.getAll();
    }

    @Override
    public Collection<Item> getItemsOfType(String type) {
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getType().equals(type)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    @Override
    public Collection<Item> getItems(String pattern) {
        String regex = pattern.replace("?", ".?").replace("*", ".*?");
        ArrayList<Item> matchedItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!item.getName().matches(regex)) continue;
            matchedItems.add(item);
        }
        return matchedItems;
    }

    /*
     * WARNING - void declaration
     */
    private void addToGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                void groupItem;
                Item item2 = this.getItem(groupName);
                if (!(item2 instanceof GroupItem)) continue;
                GroupItem cfr_ignored_0 = (GroupItem)item2;
                GroupItem cfr_ignored_1 = (GroupItem)item2;
                groupItem.addMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void replaceInGroupItems(Item oldItem, Item newItem, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                void groupItem;
                Item item = this.getItem(groupName);
                if (!(item instanceof GroupItem)) continue;
                GroupItem cfr_ignored_0 = (GroupItem)item;
                GroupItem cfr_ignored_1 = (GroupItem)item;
                groupItem.replaceMember(oldItem, newItem);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeItem(Item item) throws IllegalArgumentException {
        ItemUtil.assertValidItemName(item.getName());
        this.injectServices(item);
        Item item2 = item;
        if (item2 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item2;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            this.addMembersToGroupItem((GroupItem)groupItem);
        }
        this.addToGroupItems(item, item.getGroupNames());
        this.defaultStateDescriptionFragmentProvider.onItemAdded(item);
    }

    /*
     * WARNING - void declaration
     */
    private void injectServices(Item item) {
        Item item2;
        Item item3 = item;
        if (item3 instanceof GenericItem) {
            void genericItem;
            GenericItem genericItem2 = (GenericItem)item3;
            GenericItem cfr_ignored_0 = (GenericItem)item3;
            genericItem.setEventPublisher(this.getEventPublisher());
            genericItem.setStateDescriptionService(this.stateDescriptionService);
            genericItem.setCommandDescriptionService(this.commandDescriptionService);
            genericItem.setItemStateConverter(this.itemStateConverter);
        }
        if ((item2 = item) instanceof MetadataAwareItem) {
            void metadataAwareItem;
            MetadataAwareItem metadataAwareItem2 = (MetadataAwareItem)((Object)item2);
            MetadataAwareItem cfr_ignored_1 = (MetadataAwareItem)((Object)item2);
            this.metadataRegistry.stream().filter(m -> m.getUID().getItemName().equals(item.getName())).forEach(((MetadataAwareItem)metadataAwareItem)::addedMetadata);
        }
    }

    private void addMembersToGroupItem(GroupItem groupItem) {
        for (Item i : this.getItems()) {
            if (!i.getGroupNames().contains(groupItem.getName())) continue;
            groupItem.addMember(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeFromGroupItems(Item item, List<String> groupItemNames) {
        for (String groupName : groupItemNames) {
            if (groupName == null) continue;
            try {
                void groupItem;
                Item item2 = this.getItem(groupName);
                if (!(item2 instanceof GroupItem)) continue;
                GroupItem cfr_ignored_0 = (GroupItem)item2;
                GroupItem cfr_ignored_1 = (GroupItem)item2;
                groupItem.removeMember(item);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onAddElement(Item element) throws IllegalArgumentException {
        this.initializeItem(element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onRemoveElement(Item element) {
        Item item = element;
        if (item instanceof GenericItem) {
            void genericItem;
            GenericItem genericItem2 = (GenericItem)item;
            GenericItem cfr_ignored_0 = (GenericItem)item;
            genericItem.dispose();
        }
        this.removeFromGroupItems(element, element.getGroupNames());
        this.defaultStateDescriptionFragmentProvider.onItemRemoved(element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void beforeUpdateElement(Item existingElement) {
        Item item = existingElement;
        if (item instanceof GenericItem) {
            void genericItem;
            GenericItem genericItem2 = (GenericItem)item;
            GenericItem cfr_ignored_0 = (GenericItem)item;
            genericItem.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onUpdateElement(Item oldItem, Item item) {
        List<String> oldNames = oldItem.getGroupNames();
        List<String> newNames = item.getGroupNames();
        List<String> commonNames = oldNames.stream().filter(newNames::contains).toList();
        this.removeFromGroupItems(oldItem, oldNames.stream().filter(name -> !commonNames.contains(name)).toList());
        this.replaceInGroupItems(oldItem, item, commonNames);
        this.addToGroupItems(item, newNames.stream().filter(name -> !commonNames.contains(name)).toList());
        Item item2 = item;
        if (item2 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item2;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            this.addMembersToGroupItem((GroupItem)groupItem);
        }
        this.injectServices(item);
        this.defaultStateDescriptionFragmentProvider.onItemRemoved(oldItem);
        this.defaultStateDescriptionFragmentProvider.onItemAdded(item);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEventPublisher(EventPublisher eventPublisher) {
        super.setEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(eventPublisher);
        }
    }

    @Override
    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        super.unsetEventPublisher(eventPublisher);
        for (Item item : this.getItems()) {
            ((GenericItem)item).setEventPublisher(null);
        }
    }

    @Override
    @Reference
    protected void setReadyService(ReadyService readyService) {
        super.setReadyService(readyService);
    }

    @Override
    protected void unsetReadyService(ReadyService readyService) {
        super.unsetReadyService(readyService);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setItemStateConverter(ItemStateConverter itemStateConverter) {
        this.itemStateConverter = itemStateConverter;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setItemStateConverter(itemStateConverter);
        }
    }

    protected void unsetItemStateConverter(ItemStateConverter itemStateConverter) {
        this.itemStateConverter = null;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setItemStateConverter(null);
        }
    }

    @Override
    public Collection<Item> getItemsByTag(String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItems()) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    private boolean itemHasTags(Item item, String ... tags) {
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (!item.hasTag(tag)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public <T extends Item> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        Collection<Item> items = this.getItemsByTag(tags);
        for (Item item : items) {
            if (!typeFilter.isInstance(item)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    @Override
    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : this.getItemsOfType(type)) {
            if (!this.itemHasTags(item, tags)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    @Override
    public @Nullable Item remove(String itemName, boolean recursive) {
        return ((ManagedItemProvider)this.getManagedProvider().orElseThrow(() -> new IllegalStateException("ManagedProvider is not available"))).remove(itemName, recursive);
    }

    @Override
    protected void notifyListenersAboutAddedElement(Item element) {
        this.postEvent(ItemEventFactory.createAddedEvent(element));
        super.notifyListenersAboutAddedElement(element);
    }

    @Override
    protected void notifyListenersAboutRemovedElement(Item element) {
        this.postEvent(ItemEventFactory.createRemovedEvent(element));
        super.notifyListenersAboutRemovedElement(element);
    }

    @Override
    protected void notifyListenersAboutUpdatedElement(Item oldElement, Item element) {
        this.postEvent(ItemEventFactory.createUpdateEvent(element, oldElement));
        super.notifyListenersAboutUpdatedElement(oldElement, element);
    }

    @Override
    public void added(Provider<Item> provider, Item element) {
        for (RegistryHook<Item> registryHook : this.registryHooks) {
            registryHook.beforeAdding(element);
        }
        super.added(provider, element);
    }

    @Override
    protected void addProvider(Provider<Item> provider) {
        for (Item element : provider.getAll()) {
            for (RegistryHook<Item> registryHook : this.registryHooks) {
                registryHook.beforeAdding(element);
            }
        }
        super.addProvider(provider);
    }

    @Override
    public void removed(Provider<Item> provider, Item element) {
        super.removed(provider, element);
        for (RegistryHook<Item> registryHook : this.registryHooks) {
            registryHook.afterRemoving(element);
        }
        if (provider instanceof ManagedItemProvider) {
            this.logger.debug("Item {} was removed, trying to clean up corresponding metadata", element.getUID());
            this.metadataRegistry.removeItemMetadata(element.getName());
        }
    }

    @Override
    protected void removeProvider(Provider<Item> provider) {
        super.removeProvider(provider);
        for (Item element : provider.getAll()) {
            for (RegistryHook<Item> registryHook : this.registryHooks) {
                registryHook.afterRemoving(element);
            }
        }
    }

    @Override
    public void addRegistryHook(RegistryHook<Item> hook) {
        this.registryHooks.add(hook);
    }

    @Override
    public void removeRegistryHook(RegistryHook<Item> hook) {
        this.registryHooks.remove(hook);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setStateDescriptionService(StateDescriptionService stateDescriptionService) {
        this.stateDescriptionService = stateDescriptionService;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setStateDescriptionService(stateDescriptionService);
        }
    }

    public void unsetStateDescriptionService(StateDescriptionService stateDescriptionService) {
        this.stateDescriptionService = null;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setStateDescriptionService(null);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setCommandDescriptionService(CommandDescriptionService commandDescriptionService) {
        this.commandDescriptionService = commandDescriptionService;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setCommandDescriptionService(commandDescriptionService);
        }
    }

    public void unsetCommandDescriptionService(CommandDescriptionService commandDescriptionService) {
        this.commandDescriptionService = null;
        for (Item item : this.getItems()) {
            ((GenericItem)item).setCommandDescriptionService(null);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedProvider(ManagedItemProvider provider) {
        super.setManagedProvider(provider);
    }

    protected void unsetManagedProvider(ManagedItemProvider provider) {
        super.unsetManagedProvider(provider);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void added(Metadata element) {
        String itemName = element.getUID().getItemName();
        Item item = (Item)this.get(itemName);
        Item item2 = item;
        if (item2 instanceof MetadataAwareItem) {
            void metadataAwareItem;
            MetadataAwareItem metadataAwareItem2 = (MetadataAwareItem)((Object)item2);
            MetadataAwareItem cfr_ignored_0 = (MetadataAwareItem)((Object)item2);
            metadataAwareItem.addedMetadata(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removed(Metadata element) {
        String itemName = element.getUID().getItemName();
        Item item = (Item)this.get(itemName);
        Item item2 = item;
        if (item2 instanceof MetadataAwareItem) {
            void metadataAwareItem;
            MetadataAwareItem metadataAwareItem2 = (MetadataAwareItem)((Object)item2);
            MetadataAwareItem cfr_ignored_0 = (MetadataAwareItem)((Object)item2);
            metadataAwareItem.removedMetadata(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updated(Metadata oldElement, Metadata element) {
        String itemName = element.getUID().getItemName();
        Item item = (Item)this.get(itemName);
        Item item2 = item;
        if (item2 instanceof MetadataAwareItem) {
            void metadataAwareItem;
            MetadataAwareItem metadataAwareItem2 = (MetadataAwareItem)((Object)item2);
            MetadataAwareItem cfr_ignored_0 = (MetadataAwareItem)((Object)item2);
            metadataAwareItem.updatedMetadata(oldElement, element);
        }
    }
}

