"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTour", {
  enumerable: true,
  get: function get() {
    return _tour.EuiTour;
  }
});
exports.OuiTour = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _useOuiTour3 = require("./useOuiTour");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _tour = require("../../eui_components/tour/tour");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiTour = function OuiTour(_ref) {
  var children = _ref.children,
      steps = _ref.steps,
      initialState = _ref.initialState;

  var _useOuiTour = (0, _useOuiTour3.useOuiTour)(steps, initialState),
      _useOuiTour2 = (0, _slicedToArray2.default)(_useOuiTour, 3),
      stepProps = _useOuiTour2[0],
      actions = _useOuiTour2[1],
      state = _useOuiTour2[2];

  return children(stepProps, actions, state);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiTour = OuiTour;
OuiTour.propTypes = {
  children: _propTypes.default.func.isRequired,
  steps: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
  initialState: _propTypes.default.shape({
    currentTourStep: _propTypes.default.number.isRequired,
    isTourActive: _propTypes.default.bool.isRequired,
    tourPopoverWidth: _propTypes.default.number.isRequired,
    tourSubtitle: _propTypes.default.string.isRequired
  }).isRequired
};
/* OUI -> EUI Aliases: Build-Time */