"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _constants = require("../../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled = false) {
  const {
    commonService
  } = services;
  let query = _configSchema.schema.object({}, {
    unknowns: "allow"
  });
  if (dataSourceEnabled) {
    query = query.extends({
      dataSourceId: _configSchema.schema.string()
    });
  }
  let bodySchema = _configSchema.schema.nullable(_configSchema.schema.object({
    endpoint: _configSchema.schema.string(),
    data: _configSchema.schema.nullable(_configSchema.schema.any()),
    hideLog: _configSchema.schema.nullable(_configSchema.schema.boolean())
  }));
  const payload = {
    path: _constants.NODE_API.API_CALLER,
    validate: {
      body: bodySchema,
      query: query
    }
  };
  router.post(payload, commonService.apiCaller);

  // this api is called on the very first page load
  router.post({
    path: _constants.NODE_API.ACCOUNT_INFO,
    validate: {
      body: bodySchema
    }
  }, commonService.apiCaller);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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