"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = exports.setQueryManager = exports.setPPLService = exports.setOSDSavedObjectsClient = exports.setOSDHttp = exports.getQueryManager = exports.getPPLService = exports.getOSDSavedObjectsClient = exports.getOSDHttp = void 0;
var _common = require("../../../../src/plugins/opensearch_dashboards_utils/common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let uiSettings;
let notifications;
const uiSettingsService = exports.uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;
    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;
    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject('uiSettings client not initialized.');
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
const [getPPLService, setPPLService] = (0, _common.createGetterSetter)('PPLService');
exports.setPPLService = setPPLService;
exports.getPPLService = getPPLService;
const [getOSDHttp, setOSDHttp] = (0, _common.createGetterSetter)('http');
exports.setOSDHttp = setOSDHttp;
exports.getOSDHttp = getOSDHttp;
const [getOSDSavedObjectsClient, setOSDSavedObjectsClient] = (0, _common.createGetterSetter)('SavedObjectsClient');
exports.setOSDSavedObjectsClient = setOSDSavedObjectsClient;
exports.getOSDSavedObjectsClient = getOSDSavedObjectsClient;
const [getQueryManager, setQueryManager] = (0, _common.createGetterSetter)('QueryManager');
exports.setQueryManager = setQueryManager;
exports.getQueryManager = getQueryManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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