"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentIdByConfig = exports.getAgentIdAndRequest = void 0;
var _query_assist = require("../../../../common/constants/query_assist");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const AGENT_REQUEST_OPTIONS = {
  /**
   * It is time-consuming for LLM to generate final answer
   * Give it a large timeout window
   */
  requestTimeout: 5 * 60 * 1000,
  /**
   * Do not retry
   */
  maxRetries: 0
};
const getAgentIdByConfig = async (opensearchClient, configName) => {
  try {
    const response = await opensearchClient.transport.request({
      method: 'GET',
      path: `${_query_assist.ML_COMMONS_API_PREFIX}/config/${configName}`
    });
    if (!response || response.body.configuration.agent_id === undefined) {
      throw new Error('cannot find any agent by configuration: ' + configName);
    }
    return response.body.configuration.agent_id;
  } catch (error) {
    var _error$meta;
    const errorMessage = JSON.stringify((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body) || error;
    throw new Error(`Get agent '${configName}' failed, reason: ` + errorMessage);
  }
};
exports.getAgentIdByConfig = getAgentIdByConfig;
const getAgentIdAndRequest = async options => {
  const {
    client,
    configName,
    body
  } = options;
  const agentId = await getAgentIdByConfig(client, configName);
  return client.transport.request({
    method: 'POST',
    path: `${_query_assist.ML_COMMONS_API_PREFIX}/agents/${agentId}/_execute`,
    body
  }, AGENT_REQUEST_OPTIONS);
};
exports.getAgentIdAndRequest = getAgentIdAndRequest;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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