"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationSavedObject = exports.searchSavedObject = exports.notebookSavedObject = void 0;
var _shared = require("../../common/constants/shared");
var _observability_saved_object_attributes = require("../../common/types/observability_saved_object_attributes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const visualizationSavedObject = exports.visualizationSavedObject = {
  name: _observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'visQueryPPL',
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editPath = `#/explorer/${_observability_saved_object_attributes.VISUALIZATION_SAVED_OBJECT}:${obj.id}`;
      const editUrl = `/app/${_shared.observabilityLogsID}${editPath}`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
const searchSavedObject = exports.searchSavedObject = {
  name: _observability_saved_object_attributes.SEARCH_SAVED_OBJECT,
  icon: 'editorCodeBlock',
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editPath = `#/explorer/${_observability_saved_object_attributes.SEARCH_SAVED_OBJECT}:${obj.id}`;
      const editUrl = `/app/${_shared.observabilityLogsID}${editPath}`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
const notebookSavedObject = exports.notebookSavedObject = {
  name: _observability_saved_object_attributes.NOTEBOOK_SAVED_OBJECT,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'title',
    importableAndExportable: true,
    icon: 'notebookApp',
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      const editUrl = `/app/${_shared.observabilityNotebookID}#/${obj.id}?view=view_both`;
      return {
        path: editUrl,
        uiCapabilitiesPath: 'observability.show'
      };
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      title: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  migrations: {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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