"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(_client, dataSourceEnabled, logger) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "describeQueryPostInternal", async (request, format, responseFormat, body, context) => {
      try {
        const params = {
          body: JSON.stringify(body)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryPostInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeQueryJobIdInternal", async (request, format, jobId, responseFormat, context, dataSourceMDSId) => {
      try {
        let client = this.client;
        let queryResponse;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, {
            jobId: jobId
          });
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, {
            jobId: jobId
          });
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info(err);
        this.logger.info(request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeQueryGetInternalSync", async (request, format, responseFormat, context) => {
      try {
        let client = this.client;
        let queryResponse;
        const dataSourceMDSId = request.params.dataSourceMDSId;
        if (this.dataSourceEnabled && dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryGetInternalSync');
        this.logger.info(err);
        this.logger.info(request.query);
        console.log(err, request.query);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplQuery', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlCsv', null, request.body, context);
    });
    _defineProperty(this, "describePPLCsv", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplCsv', null, request.body, context);
    });
    _defineProperty(this, "describeSQLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlJson', 'json', request.body, context);
    });
    _defineProperty(this, "describePPLJson", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplJson', 'json', request.body, context);
    });
    _defineProperty(this, "describeSQLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sqlText', null, request.body, context);
    });
    _defineProperty(this, "describePPLText", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.pplText', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncQuery", async (context, request) => {
      return this.describeQueryPostInternal(request, 'sql.sparkSqlQuery', null, request.body, context);
    });
    _defineProperty(this, "describeSQLAsyncGetQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.sparkSqlGetQuery', jobId, null, context, dataSourceMDSId);
    });
    _defineProperty(this, "describeSyncQueryDataSources", async (context, request) => {
      return this.describeQueryGetInternalSync(request, 'sql.datasourcesGetQuery', null, context);
    });
    _defineProperty(this, "describeAsyncDeleteQuery", async (context, request, jobId, dataSourceMDSId) => {
      return this.describeQueryJobIdInternal(request, 'sql.asyncDeleteQuery', jobId, null, context, dataSourceMDSId);
    });
    this.client = _client;
    this.dataSourceEnabled = dataSourceEnabled;
    this.logger = logger;
  }
}
exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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