/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.DefaultSharedIndexNetworkCacheScope;
import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexNetworkCache;
import com.intellij.indexing.shared.download.SharedIndexNetworkCacheScope;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0015JN\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001f0\u001e2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010\"R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u000f*\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexNetworkCache;", "Key", "", "Value", "scope", "Lcom/intellij/indexing/shared/download/SharedIndexNetworkCacheScope;", "TTL", "Ljava/time/Duration;", "(Lcom/intellij/indexing/shared/download/SharedIndexNetworkCacheScope;Ljava/time/Duration;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "created", "Ljava/time/Instant;", "getCreated", "(Ljava/lang/Object;)Ljava/time/Instant;", "cacheSize", "", "invalidate", "", "key", "(Ljava/lang/Object;)V", "invalidateCaches", "lookupOrCompute", "request", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "validKeyPredicate", "Lkotlin/Function1;", "", "computeFunction", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.indexing.shared"})
public abstract class SharedIndexNetworkCache<Key, Value> {
    @NotNull
    private final SharedIndexNetworkCacheScope scope;
    @NotNull
    private final Duration TTL;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ConcurrentHashMap<Key, Value> cache;

    public SharedIndexNetworkCache(@NotNull SharedIndexNetworkCacheScope scope, @NotNull Duration TTL) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)TTL, (String)"TTL");
        this.scope = scope;
        this.TTL = TTL;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.cache = new ConcurrentHashMap();
    }

    public /* synthetic */ SharedIndexNetworkCache(SharedIndexNetworkCacheScope sharedIndexNetworkCacheScope, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sharedIndexNetworkCacheScope = DefaultSharedIndexNetworkCacheScope.INSTANCE;
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofMinutes(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(sharedIndexNetworkCacheScope, duration);
    }

    public final void invalidateCaches() {
        this.cache.clear();
    }

    public final void invalidate(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.cache.remove(key);
    }

    public final int cacheSize() {
        return this.cache.size();
    }

    @NotNull
    protected abstract Instant getCreated(@NotNull Value var1);

    @Nullable
    public final Value lookupOrCompute(@NotNull Key request, @NotNull ProgressIndicator indicator, @NotNull Function1<? super Value, Boolean> validKeyPredicate, @NotNull Function1<? super SharedIndexNetworkCacheScope, ? extends Value> computeFunction) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(validKeyPredicate, (String)"validKeyPredicate");
        Intrinsics.checkNotNullParameter(computeFunction, (String)"computeFunction");
        Function<Object, Object> compute = arg_0 -> SharedIndexNetworkCache.lookupOrCompute$lambda$0(computeFunction, this, indicator, request, arg_0);
        if (!Registry.is((String)"shared.indexes.cache.cdn")) {
            return (Value)compute.apply(request);
        }
        while (this.cache.computeIfAbsent(request, compute) != null) {
            Object cachedEntry;
            if (Duration.between(this.getCreated(cachedEntry), this.scope.getNow()).compareTo(this.TTL) < 0 && ((Boolean)validKeyPredicate.invoke(cachedEntry)).booleanValue()) {
                return (Value)cachedEntry;
            }
            this.cache.remove(request, cachedEntry);
        }
        return null;
    }

    public static /* synthetic */ Object lookupOrCompute$default(SharedIndexNetworkCache sharedIndexNetworkCache, Object object, ProgressIndicator progressIndicator, Function1 function1, Function1 function12, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lookupOrCompute");
        }
        if ((n & 4) != 0) {
            function1 = lookupOrCompute.1.INSTANCE;
        }
        return sharedIndexNetworkCache.lookupOrCompute(object, progressIndicator, function1, function12);
    }

    private static final Object lookupOrCompute$lambda$0(Function1 $computeFunction, SharedIndexNetworkCache this$0, ProgressIndicator $indicator, Object $request, Object it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$computeFunction, (String)"$computeFunction");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        try {
            object = $computeFunction.invoke((Object)this$0.scope);
        }
        catch (SharedIndexAuthException t) {
            object = null;
        }
        catch (UnknownHostException e) {
            object = null;
        }
        catch (SocketTimeoutException e) {
            object = null;
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            $indicator.checkCanceled();
            this$0.LOG.warn("Failed to compute cache value for " + $request + ". " + t.getMessage(), t);
            object = null;
        }
        return object;
    }

    public SharedIndexNetworkCache() {
        this(null, null, 3, null);
    }
}

