/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.indexing.shared.platform.impl.SharedIndexInfrastructure;
import com.intellij.indexing.shared.platform.impl.SharedIndexProjectSettings;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.dependencies.ProjectIndexingDependenciesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "attachChunksFromPreviousIDESession", "", "project", "Lcom/intellij/openapi/project/Project;", "attachChunksFromPreviousIDESessionImpl", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexInfrastructureStartup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexInfrastructureStartup.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexInfrastructureStartupKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,49:1\n31#2,2:50\n31#2,2:52\n*S KotlinDebug\n*F\n+ 1 SharedIndexInfrastructureStartup.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexInfrastructureStartupKt\n*L\n19#1:50,2\n45#1:52,2\n*E\n"})
public final class SharedIndexInfrastructureStartupKt {
    @NotNull
    private static final Logger LOG;

    public static final void attachChunksFromPreviousIDESession(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            SharedIndexInfrastructureStartupKt.attachChunksFromPreviousIDESessionImpl(project);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectIndexingDependenciesService> serviceClass$iv = ProjectIndexingDependenciesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ProjectIndexingDependenciesService)object).requestHeavyScanningOnProjectOpen("Could not attach some shared indexes chunks. Exception: " + t.getMessage());
            throw t;
        }
    }

    private static final void attachChunksFromPreviousIDESessionImpl(Project project) {
        Set<String> chunks2 = SharedIndexProjectSettings.getInstance((Project)project).getState().attachedChunks;
        if (chunks2.isEmpty()) {
            return;
        }
        List attached = new ArrayList();
        List skipped = new ArrayList();
        for (String chunkId : chunks2) {
            boolean bl = SharedIndexChunkConfiguration.getInstance().attachExistingChunk(project, chunkId);
            if (bl) {
                Intrinsics.checkNotNull((Object)chunkId);
                attached.add(chunkId);
                continue;
            }
            if (bl) continue;
            Intrinsics.checkNotNull((Object)chunkId);
            skipped.add(chunkId);
        }
        if (!((Collection)attached).isEmpty()) {
            LOG.info("Attached " + attached.size() + " shared indexes: " + CollectionsKt.joinToString$default((Iterable)attached, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)skipped).isEmpty()) {
            LOG.warn("Skipped " + skipped.size() + " shared indexes: " + CollectionsKt.joinToString$default((Iterable)skipped, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectIndexingDependenciesService> serviceClass$iv = ProjectIndexingDependenciesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ProjectIndexingDependenciesService)object).requestHeavyScanningOnProjectOpen("Shared indexes could not load " + skipped.size() + " chunks. Invalidate indexing flag in project [" + project.getName() + "] and continue.");
        }
    }

    static {
        Logger logger = Logger.getInstance(SharedIndexInfrastructure.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

