/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.cache;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceEntityBasicApiData;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheUpdateListener;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000H\u0016J\u001c\u0010\u0018\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\bH\u0007R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCache;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "maxSize", "", "(I)V", "cacheMap", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/python/community/impl/huggingFace/api/HuggingFaceEntityBasicApiData;", "Lkotlin/collections/LinkedHashMap;", "hotCache", "hotCacheMaxSize", "nameSet", "", "getBasicData", "entityId", "getCacheSize", "getPipelineTagForEntity", "getState", "isInCache", "", "loadState", "", "state", "saveEntities", "entitiesMap", "", "saveEntity", "entityData", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceEntitiesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceEntitiesCache.kt\ncom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1855#2,2:93\n1#3:95\n*S KotlinDebug\n*F\n+ 1 HuggingFaceEntitiesCache.kt\ncom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCache\n*L\n37#1:93,2\n*E\n"})
public abstract class HuggingFaceCache
implements PersistentStateComponent<HuggingFaceCache> {
    private final int maxSize;
    @NotNull
    private Set<String> nameSet;
    private final int hotCacheMaxSize;
    @NotNull
    private LinkedHashMap<String, HuggingFaceEntityBasicApiData> cacheMap;
    @NotNull
    private final LinkedHashMap<String, HuggingFaceEntityBasicApiData> hotCache;

    public HuggingFaceCache(int maxSize) {
        this.maxSize = maxSize;
        this.nameSet = new LinkedHashSet();
        this.hotCacheMaxSize = 32;
        int n = this.maxSize;
        this.cacheMap = new LinkedHashMap<String, HuggingFaceEntityBasicApiData>(this, n){
            final /* synthetic */ HuggingFaceCache this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, 0.75f, true);
            }

            protected boolean removeEldestEntry(@Nullable Map.Entry<String, HuggingFaceEntityBasicApiData> eldest) {
                return this.size() > HuggingFaceCache.access$getMaxSize$p(this.this$0);
            }
        };
        this.hotCache = new LinkedHashMap<String, HuggingFaceEntityBasicApiData>(this){
            final /* synthetic */ HuggingFaceCache this$0;
            {
                this.this$0 = $receiver;
                super(16, 0.75f, true);
            }

            protected boolean removeEldestEntry(@Nullable Map.Entry<String, HuggingFaceEntityBasicApiData> eldest) {
                return this.size() > HuggingFaceCache.access$getHotCacheMaxSize$p(this.this$0);
            }
        };
    }

    @RequiresBackgroundThread
    public final synchronized void saveEntities(@NotNull Map<String, HuggingFaceEntityBasicApiData> entitiesMap) {
        Intrinsics.checkNotNullParameter(entitiesMap, (String)"entitiesMap");
        this.cacheMap.putAll(entitiesMap);
        Iterable $this$forEach$iv = entitiesMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            this.nameSet.add(key);
        }
    }

    @RequiresBackgroundThread
    public final synchronized void saveEntity(@NotNull HuggingFaceEntityBasicApiData entityData) {
        Intrinsics.checkNotNullParameter((Object)entityData, (String)"entityData");
        ((Map)this.cacheMap).put(entityData.getItemId(), entityData);
        this.nameSet.add(entityData.getItemId());
    }

    public final synchronized boolean isInCache(@NotNull String entityId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        if (this.hotCache.containsKey(entityId)) {
            return true;
        }
        if (this.cacheMap.containsKey(entityId)) {
            Map map = this.hotCache;
            HuggingFaceEntityBasicApiData huggingFaceEntityBasicApiData = this.cacheMap.get(entityId);
            Intrinsics.checkNotNull((Object)huggingFaceEntityBasicApiData);
            map.put(entityId, huggingFaceEntityBasicApiData);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final synchronized HuggingFaceEntityBasicApiData getBasicData(@NotNull String entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        return this.cacheMap.get(entityId);
    }

    @Nullable
    public final synchronized String getPipelineTagForEntity(@NotNull String entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        HuggingFaceEntityBasicApiData huggingFaceEntityBasicApiData = this.hotCache.get(entityId);
        if (huggingFaceEntityBasicApiData != null) {
            HuggingFaceEntityBasicApiData it = huggingFaceEntityBasicApiData;
            boolean bl = false;
            return it.getPipelineTag();
        }
        HuggingFaceEntityBasicApiData huggingFaceEntityBasicApiData2 = this.cacheMap.get(entityId);
        return huggingFaceEntityBasicApiData2 != null ? huggingFaceEntityBasicApiData2.getPipelineTag() : null;
    }

    public final synchronized int getCacheSize() {
        return this.cacheMap.size();
    }

    @NotNull
    public HuggingFaceCache getState() {
        return this;
    }

    public void loadState(@NotNull HuggingFaceCache state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
        this.cacheMap = state2.cacheMap;
        this.nameSet = state2.nameSet;
        HuggingFaceCacheUpdateListener.Companion.notifyCacheUpdated();
    }

    public static final /* synthetic */ int access$getMaxSize$p(HuggingFaceCache $this) {
        return $this.maxSize;
    }

    public static final /* synthetic */ int access$getHotCacheMaxSize$p(HuggingFaceCache $this) {
        return $this.hotCacheMaxSize;
    }
}

