/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharSequenceReader;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.parser.icons.PythonParserIcons;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFileType
extends LanguageFileType {
    private static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=]\\s*([-\\w.]+)");
    public static final int MAX_CHARSET_ENCODING_LINE = 2;
    public static final PythonFileType INSTANCE = new PythonFileType();

    private PythonFileType() {
        this(PythonLanguage.INSTANCE);
    }

    protected PythonFileType(Language language) {
        super(language);
    }

    @NotNull
    @NonNls
    public String getName() {
        return "Python";
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        return "Python";
    }

    @NotNull
    public String getDefaultExtension() {
        return "py";
    }

    public Icon getIcon() {
        return PythonParserIcons.PythonFile;
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content2) {
        if (file == null) {
            PythonFileType.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            PythonFileType.$$$reportNull$$$0(1);
        }
        if (CharsetToolkit.hasUTF8Bom((byte[])content2)) {
            return "UTF-8";
        }
        ByteBuffer bytes = ByteBuffer.wrap(content2, 0, Math.min(256, content2.length));
        String decoded = StandardCharsets.UTF_8.decode(bytes).toString();
        return PythonFileType.getCharsetFromEncodingDeclaration(StringUtil.convertLineSeparators((String)decoded));
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project2, @Nullable VirtualFile file, @NotNull CharSequence content2) {
        String charsetName;
        if (content2 == null) {
            PythonFileType.$$$reportNull$$$0(2);
        }
        if ((charsetName = PythonFileType.getCharsetFromEncodingDeclaration(content2)) == null) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    @Nullable
    public static String getCharsetFromEncodingDeclaration(@NotNull PsiFile file) {
        String content2;
        Document document;
        if (file == null) {
            PythonFileType.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null && document.getLineCount() > 2) {
            int offset = document.getLineEndOffset(2);
            content2 = document.getText(TextRange.create((int)0, (int)offset));
        } else {
            content2 = file.getText();
        }
        return PythonFileType.getCharsetFromEncodingDeclaration(content2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getCharsetFromEncodingDeclaration(@Nullable CharSequence content2) {
        if (content2 == null) return null;
        if (content2.length() == 0) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader((Reader)new CharSequenceReader(content2));){
            int i = 0;
            while (i < 2) {
                String line2 = reader.readLine();
                if (line2 == null) {
                    String string = null;
                    return string;
                }
                Matcher matcher = ENCODING_PATTERN.matcher(line2);
                if (matcher.find()) {
                    String charset = matcher.group(1);
                    String string = PythonFileType.normalizeCharset(charset);
                    return string;
                }
                ++i;
            }
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String normalizeCharset(String charset) {
        if (charset == null) {
            return null;
        }
        if ("latin-1".equals(charset = StringUtil.toLowerCase((String)charset))) {
            return "iso-8859-1";
        }
        return charset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PythonFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCharsetFromFileContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharsetFromEncodingDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

