/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstCallSiteExpression;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceOwner;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.psi.PyElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstPrefixExpression
extends PyAstQualifiedExpression,
PyAstReferenceOwner,
PyAstCallSiteExpression {
    @Override
    @Nullable
    default public PyAstExpression getReceiver(@Nullable PyAstCallable resolvedCallee) {
        return this.getOperand();
    }

    @NotNull
    default public List<PyAstExpression> getArguments(@Nullable PyAstCallable resolvedCallee) {
        List<PyAstExpression> list = Collections.emptyList();
        if (list == null) {
            PyAstPrefixExpression.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    default public PyAstExpression getOperand() {
        return (PyAstExpression)this.childToPsi(PythonDialectsTokenSetProvider.getInstance().getExpressionTokens(), 0);
    }

    @Nullable
    default public PsiElement getPsiOperator() {
        ASTNode node = this.getNode();
        ASTNode child = node.findChildByType(PyElementTypes.UNARY_OPS);
        return child != null ? child.getPsi() : null;
    }

    @NotNull
    default public PyElementType getOperator() {
        PsiElement op = this.getPsiOperator();
        if (!1.$assertionsDisabled && op == null) {
            throw new AssertionError();
        }
        PyElementType pyElementType = (PyElementType)op.getNode().getElementType();
        if (pyElementType == null) {
            PyAstPrefixExpression.$$$reportNull$$$0(1);
        }
        return pyElementType;
    }

    @Override
    default public PyAstExpression getQualifier() {
        return this.getOperand();
    }

    @Override
    @Nullable
    default public QualifiedName asQualifiedName() {
        return PyPsiUtilsCore.asQualifiedName(this);
    }

    @Override
    default public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    default public String getReferencedName() {
        PyElementType t = this.getOperator();
        if (t == PyTokenTypes.PLUS) {
            return "__pos__";
        }
        if (t == PyTokenTypes.MINUS) {
            return "__neg__";
        }
        return this.getOperator().getSpecialMethodName();
    }

    @Override
    default public ASTNode getNameElement() {
        PsiElement op = this.getPsiOperator();
        return op != null ? op.getNode() : null;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyPrefixExpression(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstPrefixExpression";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperator";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

