/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstNamedParameter;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StringLiteralExpression;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConvertVariadicParamIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PyPsiBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.convert.variadic.param", new Object[0]);
        if (string == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file) {
        if (project2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null) {
            if (LanguageLevel.forElement(function).isPython2() && function.getParameterList().hasPositionalContainer()) {
                return false;
            }
            Usages usages = ConvertVariadicParamIntention.findKeywordContainerUsages(function, false);
            if (usages.hasMoreReferences) {
                return false;
            }
            boolean caretInParameterList = PsiTreeUtil.isAncestor((PsiElement)function.getParameterList(), (PsiElement)element, (boolean)true);
            if (caretInParameterList && ContainerUtil.exists(usages.names.values(), n -> !n.unableToHasDefaultValue)) {
                return true;
            }
            for (Map.Entry<String, DefaultValue> nameAndValue : usages.names.entrySet()) {
                String name2;
                if (nameAndValue.getValue().unableToHasDefaultValue || !ContainerUtil.exists((Iterable)usages.calls.get((Object)(name2 = nameAndValue.getKey())), c -> PsiTreeUtil.isAncestor((PsiElement)c, (PsiElement)element, (boolean)true)) && !ContainerUtil.exists((Iterable)usages.subscriptions.get((Object)name2), s -> PsiTreeUtil.isAncestor((PsiElement)s, (PsiElement)element, (boolean)true))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PyParameter getKeywordContainer(@NotNull PyParameterList parameterList) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(3);
        }
        return StreamEx.of((Object[])parameterList.getParameters()).select(PyNamedParameter.class).findFirst(PyAstNamedParameter::isKeywordContainer).orElse(null);
    }

    @Override
    public void doInvoke(@NotNull Project project2, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PyFunction function;
        if (project2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(4);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(editor2.getCaretModel().getOffset())), PyFunction.class)) != null) {
            ConvertVariadicParamIntention.replaceKeywordContainerUsages(function, project2);
        }
    }

    @NotNull
    private static Usages findKeywordContainerUsages(@NotNull PyFunction function, boolean skipReferencesToContainer) {
        PyParameter keywordContainer;
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(5);
        }
        if ((keywordContainer = ConvertVariadicParamIntention.getKeywordContainer((PyParameterList)function.getParameterList())) == null) {
            return new Usages(false, new LinkedHashMap<String, DefaultValue>(), (MultiMap<String, PyCallExpression>)MultiMap.empty(), (MultiMap<String, PySubscriptionExpression>)MultiMap.empty());
        }
        HashSet allReferences = new HashSet();
        HashSet referencesAsOperandOrReceiver = new HashSet();
        LinkedHashMap<String, DefaultValue> names2 = new LinkedHashMap<String, DefaultValue>();
        MultiMap calls = MultiMap.create();
        MultiMap subscriptions = MultiMap.create();
        SyntaxTraverser.psiTraverser((PsiElement)function.getStatementList()).forEach(e -> {
            if (!skipReferencesToContainer && e instanceof PyReferenceExpression && ((PyReferenceExpression)e).getReference().isReferenceTo((PsiElement)keywordContainer)) {
                allReferences.add((PyReferenceExpression)e);
            } else if (ConvertVariadicParamIntention.isKeywordContainerCall(e, keywordContainer)) {
                PyCallExpression call = (PyCallExpression)e;
                referencesAsOperandOrReceiver.add(call.getReceiver(null));
                String name2 = ConvertVariadicParamIntention.getIndexValueToReplace(call);
                if (name2 != null) {
                    names2.merge(name2, ConvertVariadicParamIntention.getDefaultKeyValue(call), DefaultValue::merge);
                    calls.putValue((Object)name2, (Object)call);
                }
            } else if (ConvertVariadicParamIntention.isKeywordContainerSubscription(e, keywordContainer)) {
                PySubscriptionExpression subscription = (PySubscriptionExpression)e;
                referencesAsOperandOrReceiver.add(subscription.getOperand());
                String name3 = ConvertVariadicParamIntention.getIndexValueToReplace(subscription);
                if (name3 != null) {
                    names2.merge(name3, DefaultValue.noDefault(), DefaultValue::merge);
                    subscriptions.putValue((Object)name3, (Object)subscription);
                }
            }
        });
        allReferences.removeAll(referencesAsOperandOrReceiver);
        return new Usages(!allReferences.isEmpty(), names2, (MultiMap<String, PyCallExpression>)calls, (MultiMap<String, PySubscriptionExpression>)subscriptions);
    }

    @Nullable
    private static String getIndexValueToReplace(@NotNull PySubscriptionExpression subscription) {
        if (subscription == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(6);
        }
        return Optional.ofNullable(subscription.getIndexExpression()).map(indexExpression -> PyUtil.as(indexExpression, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).orElse(null);
    }

    @Nullable
    private static String getIndexValueToReplace(@NotNull PyCallExpression call) {
        if (call == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(7);
        }
        return Optional.of(call.getArguments()).map(ArrayUtil::getFirstElement).map(firstArgument -> PyUtil.as(firstArgument, PyStringLiteralExpression.class)).map(StringLiteralExpression::getStringValue).filter(PyNames::isIdentifier).orElse(null);
    }

    private static void replaceKeywordContainerUsages(@NotNull PyFunction function, @NotNull Project project2) {
        if (function == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(9);
        }
        Usages usages = ConvertVariadicParamIntention.findKeywordContainerUsages(function, true);
        MultiMap<String, PySubscriptionExpression> subscriptions = usages.subscriptions;
        MultiMap<String, PyCallExpression> calls = usages.calls;
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project2);
        for (Map.Entry<String, DefaultValue> nameAndValue : usages.names.entrySet()) {
            if (nameAndValue.getValue().unableToHasDefaultValue) continue;
            String name2 = nameAndValue.getKey();
            String defaultValue = nameAndValue.getValue().defaultValue;
            LanguageLevel languageLevel = LanguageLevel.forElement(function);
            PyNamedParameter parameter = elementGenerator.createParameter(name2, defaultValue, null, languageLevel);
            ConvertVariadicParamIntention.insertParameter((PyParameterList)function.getParameterList(), parameter, parameter.hasDefaultValue(), elementGenerator);
            PyExpression parameterUsage = elementGenerator.createExpressionFromText(languageLevel, name2);
            subscriptions.get((Object)name2).forEach(e -> e.replace((PsiElement)parameterUsage));
            calls.get((Object)name2).forEach(e -> e.replace((PsiElement)parameterUsage));
        }
    }

    private static boolean isKeywordContainerSubscription(@Nullable PsiElement element, @NotNull PyParameter keywordContainer) {
        PyExpression operand;
        if (keywordContainer == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(10);
        }
        if (element instanceof PySubscriptionExpression && (operand = ((PySubscriptionExpression)element).getOperand()) instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)operand).getReference().isReferenceTo((PsiElement)keywordContainer);
        }
        return false;
    }

    private static boolean isKeywordContainerCall(@Nullable PsiElement element, @NotNull PyParameter keywordContainer) {
        PyQualifiedExpression qualifiedCallee;
        PyExpression qualifier;
        PyExpression callee;
        if (keywordContainer == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(11);
        }
        if (element instanceof PyCallExpression && (callee = ((PyCallExpression)element).getCallee()) instanceof PyQualifiedExpression && (qualifier = (qualifiedCallee = (PyQualifiedExpression)callee).getQualifier()) instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)keywordContainer) && ArrayUtil.contains((String)qualifiedCallee.getReferencedName(), (String[])new String[]{"get", "pop", "__getitem__"});
        }
        return false;
    }

    private static void insertParameter(@NotNull PyParameterList parameterList, @NotNull PyElement parameter, boolean hasDefaultValue, @NotNull PyElementGenerator elementGenerator) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(12);
        }
        if (parameter == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(13);
        }
        if (elementGenerator == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(14);
        }
        PyElement placeToInsertParameter = ConvertVariadicParamIntention.findCompatiblePlaceToInsertParameter(parameterList, hasDefaultValue);
        parameterList.addBefore((PsiElement)parameter, (PsiElement)placeToInsertParameter);
        parameterList.addBefore((PsiElement)elementGenerator.createComma(), (PsiElement)placeToInsertParameter);
    }

    @NotNull
    private static DefaultValue getDefaultKeyValue(@NotNull PyCallExpression call) {
        PyExpression[] arguments;
        if (call == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(15);
        }
        if ((arguments = call.getArguments()).length > 1) {
            PyExpression argument = PyUtil.peelArgument(arguments[1]);
            String value = argument == null ? null : argument.getText();
            DefaultValue defaultValue = value == null ? DefaultValue.noDefault() : DefaultValue.defaultValue(value);
            if (defaultValue == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(16);
            }
            return defaultValue;
        }
        PyQualifiedExpression callee = PyUtil.as(call.getCallee(), PyQualifiedExpression.class);
        if (callee != null && "get".equals(callee.getReferencedName())) {
            DefaultValue defaultValue = DefaultValue.defaultValue("None");
            if (defaultValue == null) {
                ConvertVariadicParamIntention.$$$reportNull$$$0(17);
            }
            return defaultValue;
        }
        DefaultValue defaultValue = DefaultValue.noDefault();
        if (defaultValue == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(18);
        }
        return defaultValue;
    }

    @Nullable
    private static PyElement findCompatiblePlaceToInsertParameter(@NotNull PyParameterList parameterList, boolean hasDefaultValue) {
        if (parameterList == null) {
            ConvertVariadicParamIntention.$$$reportNull$$$0(19);
        }
        if (hasDefaultValue) {
            return ConvertVariadicParamIntention.getKeywordContainer(parameterList);
        }
        List<PyParameter> parameters = Arrays.asList(parameterList.getParameters());
        for (Pair currentAndNext : ContainerUtil.zip(parameters, parameters.subList(1, parameters.size()))) {
            PyParameter current = (PyParameter)currentAndNext.getFirst();
            if (!(current instanceof PyNamedParameter) || !((PyNamedParameter)current).isPositionalContainer()) continue;
            return (PyElement)currentAndNext.getSecond();
        }
        return (PyElement)ContainerUtil.find((Object[])parameterList.getParameters(), p -> p.hasDefaultValue() || p instanceof PyNamedParameter && ((PyNamedParameter)p).isKeywordContainer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscription";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordContainer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeyValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordContainer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findKeywordContainerUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexValueToReplace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceKeywordContainerUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerSubscription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordContainerCall";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertParameter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultKeyValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findCompatiblePlaceToInsertParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 19 -> new IllegalArgumentException(string);
        };
    }

    private static final class Usages {
        private final boolean hasMoreReferences;
        @NotNull
        private final LinkedHashMap<String, DefaultValue> names;
        @NotNull
        private final MultiMap<String, PyCallExpression> calls;
        @NotNull
        private final MultiMap<String, PySubscriptionExpression> subscriptions;

        private Usages(boolean hasMoreReferences, @NotNull LinkedHashMap<String, DefaultValue> names2, @NotNull MultiMap<String, PyCallExpression> calls, @NotNull MultiMap<String, PySubscriptionExpression> subscriptions) {
            if (names2 == null) {
                Usages.$$$reportNull$$$0(0);
            }
            if (calls == null) {
                Usages.$$$reportNull$$$0(1);
            }
            if (subscriptions == null) {
                Usages.$$$reportNull$$$0(2);
            }
            this.hasMoreReferences = hasMoreReferences;
            this.names = names2;
            this.calls = calls;
            this.subscriptions = subscriptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "names";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "calls";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subscriptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention$Usages";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultValue {
        private final boolean unableToHasDefaultValue;
        @Nullable
        private final String defaultValue;

        @NotNull
        private static DefaultValue noDefault() {
            return new DefaultValue(false, null);
        }

        @NotNull
        private static DefaultValue defaultValue(@NotNull String defaultValue) {
            if (defaultValue == null) {
                DefaultValue.$$$reportNull$$$0(0);
            }
            return new DefaultValue(false, defaultValue);
        }

        private DefaultValue(boolean unableToHasDefaultValue, @Nullable String defaultValue) {
            this.unableToHasDefaultValue = unableToHasDefaultValue;
            this.defaultValue = defaultValue;
        }

        @NotNull
        private static DefaultValue merge(@NotNull DefaultValue self, @NotNull DefaultValue other) {
            if (self == null) {
                DefaultValue.$$$reportNull$$$0(1);
            }
            if (other == null) {
                DefaultValue.$$$reportNull$$$0(2);
            }
            if (self.unableToHasDefaultValue) {
                DefaultValue defaultValue = self;
                if (defaultValue == null) {
                    DefaultValue.$$$reportNull$$$0(3);
                }
                return defaultValue;
            }
            if (other.unableToHasDefaultValue) {
                DefaultValue defaultValue = other;
                if (defaultValue == null) {
                    DefaultValue.$$$reportNull$$$0(4);
                }
                return defaultValue;
            }
            if (self.defaultValue == null) {
                DefaultValue defaultValue = self;
                if (defaultValue == null) {
                    DefaultValue.$$$reportNull$$$0(5);
                }
                return defaultValue;
            }
            if (other.defaultValue == null) {
                DefaultValue defaultValue = other;
                if (defaultValue == null) {
                    DefaultValue.$$$reportNull$$$0(6);
                }
                return defaultValue;
            }
            if (Objects.equals(self.defaultValue, other.defaultValue)) {
                DefaultValue defaultValue = self;
                if (defaultValue == null) {
                    DefaultValue.$$$reportNull$$$0(7);
                }
                return defaultValue;
            }
            return new DefaultValue(true, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "self";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention$DefaultValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ConvertVariadicParamIntention$DefaultValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

