/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.actions;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.icons.PythonIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/console/actions/ShowCommandQueueAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "consoleView", "Lcom/jetbrains/python/console/PythonConsoleView;", "(Lcom/jetbrains/python/console/PythonConsoleView;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "Companion", "intellij.python.community.impl"})
public final class ShowCommandQueueAction
extends ToggleAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PythonConsoleView consoleView;
    @NotNull
    private static final Icon emptyQueueIcon;
    @NotNull
    private static final Icon notEmptyQueueIcon;

    public ShowCommandQueueAction(@NotNull PythonConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        super(PyBundle.message("python.console.command.queue.show.action.text", new Object[0]), PyBundle.message("python.console.command.queue.show.action.description", new Object[0]), emptyQueueIcon);
        this.consoleView = consoleView;
    }

    public void update(@NotNull AnActionEvent e) {
        block4: {
            ConsoleCommunication communication;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            ConsoleCommunication consoleCommunication = communication = (ConsoleCommunication)this.consoleView.getFile().getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY);
            if (consoleCommunication == null) break block4;
            ConsoleCommunication it = consoleCommunication;
            boolean bl = false;
            if (PyConsoleUtil.isCommandQueueEnabled(this.consoleView.getProject())) {
                e.getPresentation().setEnabled(true);
                if (PyConsoleUtil.isCommandQueueEmpty(communication)) {
                    e.getPresentation().setIcon(emptyQueueIcon);
                } else {
                    e.getPresentation().setIcon(notEmptyQueueIcon);
                }
            } else {
                e.getPresentation().setIcon(emptyQueueIcon);
                e.getPresentation().setEnabled(false);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.consoleView.isShowQueue();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.consoleView.setShowQueue(state2);
        if (state2) {
            this.consoleView.showQueue();
        } else {
            this.consoleView.restoreQueueWindow(false);
        }
    }

    @JvmStatic
    public static final boolean isCommandQueueIcon(@NotNull Icon icon) {
        return Companion.isCommandQueueIcon(icon);
    }

    static {
        Icon icon = PythonIcons.Python.CommandQueue;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CommandQueue");
        emptyQueueIcon = icon;
        Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)emptyQueueIcon);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getLiveIndicator(...)");
        notEmptyQueueIcon = icon2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/console/actions/ShowCommandQueueAction$Companion;", "", "()V", "emptyQueueIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "notEmptyQueueIcon", "isCommandQueueIcon", "", "icon", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isCommandQueueIcon(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            return Intrinsics.areEqual((Object)icon, (Object)emptyQueueIcon) || Intrinsics.areEqual((Object)icon, (Object)notEmptyQueueIcon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

