/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeProviderWithCustomContext;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PyDocSignaturesHighlighterKt;
import com.jetbrains.python.documentation.PyDocumentationBuilder;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyTypeModelBuilder;
import com.jetbrains.python.documentation.PythonDocumentationLinkProvider;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationProvider
implements DocumentationProvider {
    public static final String DOCUMENTATION_CONFIGURABLE_ID = "com.jetbrains.python.documentation.PythonDocumentationConfigurable";
    private static final int RETURN_TYPE_WRAPPING_THRESHOLD = 80;

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, @NotNull PsiElement originalElement) {
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(0);
        }
        PsiElement referenceElement = originalElement.getParent();
        for (PythonDocumentationQuickInfoProvider point : (PythonDocumentationQuickInfoProvider[])PythonDocumentationQuickInfoProvider.EP_NAME.getExtensions()) {
            String info = point.getQuickInfo(referenceElement);
            if (info == null) continue;
            return info;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(referenceElement.getProject(), referenceElement.getContainingFile());
        if (element instanceof PyFunction) {
            String clsName;
            PyFunction function = (PyFunction)element;
            HtmlBuilder result2 = new HtmlBuilder();
            PyClass cls = function.getContainingClass();
            if (cls != null && (clsName = cls.getName()) != null) {
                result2.append(PyDocSignaturesHighlighterKt.styledSpan(PyPsiBundle.message("QDOC.class", new Object[0]), PyHighlighter.PY_KEYWORD));
                result2.nbsp();
                result2.append(PyDocSignaturesHighlighterKt.styledSpan(clsName, PyHighlighter.PY_CLASS_DEFINITION));
                result2.br();
            }
            return result2.append(PythonDocumentationProvider.describeDecorators(function, HtmlChunk.text((String)", "))).append(PythonDocumentationProvider.describeFunction(function, context, true)).toString();
        }
        if (element instanceof PyClass) {
            PyClass cls = (PyClass)element;
            HtmlBuilder result3 = new HtmlBuilder();
            return result3.append(PythonDocumentationProvider.describeDecorators(cls, HtmlChunk.text((String)", "))).append(PythonDocumentationProvider.describeClass(cls, context)).toString();
        }
        if (element instanceof PyExpression) {
            return PythonDocumentationProvider.describeExpression((PyExpression)element, referenceElement, context);
        }
        if (element instanceof PyTypeParameter) {
            PyTypeParameter typeParameter = (PyTypeParameter)element;
            return PyPsiBundle.message("QDOC.type.parameter.name", PythonDocumentationProvider.describeTypeParameter(typeParameter, true, context));
        }
        if (element instanceof PyTypeAliasStatement) {
            PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)element;
            return PythonDocumentationProvider.describeTypeAlias(typeAliasStatement, context).toString();
        }
        return null;
    }

    @NotNull
    static HtmlChunk describeFunction(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(2);
        }
        HtmlChunk htmlChunk = HtmlChunk.raw((String)PythonDocumentationProvider.describeFunctionWithTypes(function, context, forTooltip));
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTarget(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        if (target == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(5);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)target.getName()), DefaultLanguageHighlighterColors.IDENTIFIER));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType(target), target, target, context), PyHighlighter.PY_ANNOTATION));
        PyExpression value = target.findAssignedValue();
        if (value != null) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(" = ", PyHighlighter.PY_OPERATION_SIGN));
            String initializerText = value.getText();
            int index = value.getText().indexOf("\n");
            if (index < 0) {
                result2.append(PyDocSignaturesHighlighterKt.highlightExpressionText(initializerText, value));
            } else {
                result2.append(PyDocSignaturesHighlighterKt.highlightExpressionText(initializerText.substring(0, index), value));
                result2.append(PyDocSignaturesHighlighterKt.styledSpan("...", PyHighlighter.PY_DOT));
            }
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeParameter(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        if (parameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(8);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)parameter.getName()), PyDocSignaturesHighlighterKt.paramNameTextAttribute(parameter.isSelf())));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType(parameter), parameter, parameter, context), PyHighlighter.PY_ANNOTATION));
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(9);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTypeParameter(@NotNull PyTypeParameter typeParameter, boolean showKind, @NotNull TypeEvalContext context) {
        if (typeParameter == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(11);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)typeParameter.getName()), PyHighlighter.PY_TYPE_PARAMETER));
        PyExpression boundExpression = typeParameter.getBoundExpression();
        if (boundExpression != null && typeParameter.getBoundExpressionText() != null) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN));
            result2.append(PyDocSignaturesHighlighterKt.highlightExpressionText(typeParameter.getBoundExpressionText(), typeParameter.getBoundExpression()));
        }
        if (showKind) {
            result2.append(", ").append(PyPsiBundle.message("QDOC.type.parameter.kind", new Object[0])).append(" ").append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType(typeParameter), typeParameter, (PsiElement)typeParameter, context), PyHighlighter.PY_ANNOTATION));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(12);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeTypeAlias(@NotNull PyTypeAliasStatement typeAliasStatement, @NotNull TypeEvalContext context) {
        PyExpression typeExpression;
        if (typeAliasStatement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(14);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan("type ", PyHighlighter.PY_KEYWORD));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(StringUtil.notNullize((String)typeAliasStatement.getName()), DefaultLanguageHighlighterColors.IDENTIFIER));
        if (typeAliasStatement.getTypeParameterList() != null) {
            List<PyTypeParameter> typeParameters = typeAliasStatement.getTypeParameterList().getTypeParameters();
            result2.append(PyDocSignaturesHighlighterKt.styledSpan("[", PyHighlighter.PY_BRACKETS));
            result2.append((HtmlChunk)StreamEx.of(typeParameters).map(typeParameter -> PythonDocumentationProvider.describeTypeParameter(typeParameter, false, context)).collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA))));
            result2.append(PyDocSignaturesHighlighterKt.styledSpan("]", PyHighlighter.PY_BRACKETS));
        }
        if ((typeExpression = typeAliasStatement.getTypeExpression()) != null) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(" = ", PyHighlighter.PY_OPERATION_SIGN));
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(context.getType(typeExpression), typeExpression, typeAliasStatement, context), PyHighlighter.PY_ANNOTATION));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(15);
        }
        return htmlChunk;
    }

    @NlsSafe
    @NotNull
    private static String describeFunctionWithTypes(@NotNull PyFunction function, @NotNull TypeEvalContext context, boolean forTooltip) {
        if (function == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(17);
        }
        StringBuilder result2 = new StringBuilder();
        int firstParamOffset = 0;
        if (function.isAsync()) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan("async ", PyHighlighter.PY_KEYWORD));
            firstParamOffset += "async ".length();
        }
        result2.append(PyDocSignaturesHighlighterKt.styledSpan("def ", PyHighlighter.PY_KEYWORD));
        firstParamOffset += "def ".length();
        String funcName = StringUtil.notNullize((String)function.getName(), (String)"<unnamed>");
        firstParamOffset += funcName.length();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(funcName, PyDocSignaturesHighlighterKt.functionNameTextAttribute(function, funcName)));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
        ++firstParamOffset;
        int lastLineOffset = 0;
        boolean first = true;
        boolean firstIsSelf = false;
        List parameters = function.getParameters(context);
        for (PyCallableParameter parameter : parameters) {
            String delimiter;
            String[] parts;
            String signature;
            boolean isSelf = parameter.isSelf();
            if (!first) {
                result2.append(PyDocSignaturesHighlighterKt.styledSpan(",", PyHighlighter.PY_COMMA));
                if (forTooltip || firstIsSelf && parameters.size() == 2) {
                    result2.append(" ");
                } else {
                    result2.append("\n");
                    lastLineOffset = result2.length();
                    StringUtil.repeatSymbol((Appendable)result2, (char)' ', (int)firstParamOffset);
                }
            } else {
                firstIsSelf = isSelf;
            }
            Object paramName = parameter.getName();
            PyType paramType = parameter.getType(context);
            PyNamedParameter named = PyUtil.as(parameter.getParameter(), PyNamedParameter.class);
            boolean showType = true;
            if (parameter.isPositionalContainer()) {
                paramName = "*" + StringUtil.notNullize((String)paramName, (String)"args");
                PyTupleType tupleType = PyUtil.as(paramType, PyTupleType.class);
                if (tupleType != null) {
                    paramType = tupleType.getIteratedItemType();
                }
            } else if (parameter.isKeywordContainer()) {
                paramName = "**" + StringUtil.notNullize((String)paramName, (String)"kwargs");
                PyCollectionType genericType = PyUtil.as(paramType, PyCollectionType.class);
                if (genericType != null && genericType.getPyClass() == PyBuiltinCache.getInstance(function).getClass("dict")) {
                    List<PyType> typeParams = genericType.getElementTypes();
                    paramType = typeParams.size() == 2 ? typeParams.get(1) : null;
                }
            } else if (parameter.getParameter() instanceof PySlashParameter) {
                paramName = "/";
                showType = false;
            } else if (parameter.getParameter() instanceof PySingleStarParameter) {
                paramName = "*";
                showType = false;
            } else {
                paramName = StringUtil.notNullize((String)paramName, (String)"<unnamed>");
                showType = !isSelf || named != null && ((PyTypeProviderWithCustomContext)new PyTypingTypeProvider()).getParameterType(named, function, context) != null;
            }
            result2.append(PyDocSignaturesHighlighterKt.styledSpan((String)paramName, PyDocSignaturesHighlighterKt.paramNameTextAttribute(isSelf)));
            if (showType) {
                result2.append(PyDocSignaturesHighlighterKt.styledSpan(": ", PyHighlighter.PY_OPERATION_SIGN)).append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(paramType, named, function, context), PyHighlighter.PY_ANNOTATION));
            }
            if ((signature = ParamHelper.getDefaultValuePartInSignature(parameter.getDefaultValueText(), showType)) != null && (parts = signature.split(delimiter = showType ? " = " : "=")).length == 2) {
                result2.append(PyDocSignaturesHighlighterKt.styledSpan(delimiter, PyHighlighter.PY_OPERATION_SIGN));
                result2.append(PyDocSignaturesHighlighterKt.highlightExpressionText(parts[1], parameter.getDefaultValue()));
            }
            first = false;
        }
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        if (!forTooltip && StringUtil.stripHtml((String)result2.substring(lastLineOffset), (boolean)false).length() > 80) {
            result2.append("\n ");
        }
        PyType returnType = context.getReturnType(function);
        result2.append(HtmlChunk.text((String)" -> "));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(PythonDocumentationProvider.formatTypeWithLinks(returnType, function, function, context), PyHighlighter.PY_ANNOTATION));
        String string = result2.toString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    @Nls
    private static String describeExpression(@NotNull PyExpression expression, @NotNull PsiElement originalElement, @NotNull TypeEvalContext context) {
        String name2;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(19);
        }
        if (originalElement == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(21);
        }
        if ((name2 = expression.getName()) != null) {
            HtmlBuilder result2 = new HtmlBuilder();
            if (expression instanceof PyNamedParameter) {
                PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
                if (function != null) {
                    String functionName = function.getName();
                    if (function.getContainingClass() == null) {
                        result2.append(PyPsiBundle.message("QDOC.parameter.of.function.name", name2, functionName));
                    } else {
                        result2.append(PyPsiBundle.message("QDOC.parameter.of.method.name", name2, functionName));
                    }
                } else {
                    result2.append(PyPsiBundle.message("QDOC.parameter.name", name2));
                }
            } else {
                result2.append(PyPsiBundle.message("QDOC.variable.name", name2));
            }
            if (originalElement instanceof PyTypedElement) {
                PyTypedElement typedElement = (PyTypedElement)originalElement;
                PyType type2 = context.getType(typedElement);
                HtmlChunk formattedType = PythonDocumentationProvider.formatTypeWithLinks(type2, typedElement, (PsiElement)typedElement, context);
                result2.br().appendRaw(PyPsiBundle.message("QDOC.inferred.type.name", formattedType));
            }
            return result2.toString();
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getTypeName(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(22);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type2, context).asString();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getTypeHint(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(24);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type2, context).asPep484TypeHint();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String getVerboseTypeName(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(26);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type2, context).asStringWithAdditionalInfo();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(27);
        }
        return string;
    }

    public static void describeTypeWithLinks(@Nullable PyType type2, @Nullable PyTypedElement typeOwner, @NotNull TypeEvalContext context, @NotNull PsiElement anchor, @NotNull HtmlBuilder body) {
        PyAssignmentStatement assignment;
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (body == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (typeOwner instanceof PyTargetExpression && type2 == null && (assignment = PyUtil.as(typeOwner.getParent(), PyAssignmentStatement.class)) != null && PyTypingTypeProvider.isExplicitTypeAlias(assignment, context)) {
            body.append(PyDocSignaturesHighlighterKt.styledSpan("TypeAlias", PyHighlighter.PY_ANNOTATION));
            return;
        }
        PythonDocumentationProvider.buildTypeModel(type2, context).toBodyWithLinks(body, anchor);
    }

    @NotNull
    public static String getTypeDescription(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(31);
        }
        String string = PythonDocumentationProvider.buildTypeModel(type2, context).asDescription();
        if (string == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static PyTypeModelBuilder.TypeModel buildTypeModel(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(33);
        }
        PyTypeModelBuilder.TypeModel typeModel = new PyTypeModelBuilder(context).build(type2, true);
        if (typeModel == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(34);
        }
        return typeModel;
    }

    @NotNull
    static HtmlChunk describeDecorators(@NotNull PyDecoratable decoratable, @NotNull HtmlChunk separator) {
        if (decoratable == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (separator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(36);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        PyDecoratorList decoratorList = decoratable.getDecoratorList();
        if (decoratorList != null) {
            boolean first = true;
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                if (!first) {
                    result2.append(separator);
                }
                result2.appendRaw(PythonDocumentationProvider.describeDecorator(decorator).toString());
                first = false;
            }
        }
        if (!result2.isEmpty()) {
            result2.br();
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(37);
        }
        return htmlChunk;
    }

    @NotNull
    static HtmlChunk describeClass(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(39);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        @NlsSafe String name2 = StringUtil.notNullize((String)cls.getName(), (String)"<unnamed>");
        result2.append(PyDocSignaturesHighlighterKt.styledSpan("class ", PyHighlighter.PY_KEYWORD));
        result2.append(PyDocSignaturesHighlighterKt.styledSpan(name2, PyHighlighter.PY_CLASS_DEFINITION));
        PyExpression[] superClasses = cls.getSuperClassExpressions();
        if (superClasses.length > 0) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
            boolean isNotFirst = false;
            for (PyExpression superClass : superClasses) {
                if (isNotFirst) {
                    result2.append(PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA));
                } else {
                    isNotFirst = true;
                }
                result2.append(PythonDocumentationProvider.describeSuperClass(superClass, context));
            }
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(40);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk describeSuperClass(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PyCallExpression callExpression;
        PyExpression callee;
        if (expression == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(42);
        }
        @NlsSafe String expressionText = expression.getText();
        if (expression instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
            if (!referenceExpression.isQualified()) {
                PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
                for (ResolveResult result2 : referenceExpression.getReference(resolveContext).multiResolve(false)) {
                    PyClass pyClass;
                    PsiElement psiElement = result2.getElement();
                    if (!(psiElement instanceof PyClass) || (pyClass = (PyClass)psiElement).getQualifiedName() == null) continue;
                    HtmlChunk htmlChunk = PyDocSignaturesHighlighterKt.styledReference(PyDocumentationLink.toClass(pyClass, expressionText), pyClass);
                    if (htmlChunk == null) {
                        PythonDocumentationProvider.$$$reportNull$$$0(43);
                    }
                    return htmlChunk;
                }
            }
        } else if (expression instanceof PySubscriptionExpression) {
            PyExpression operand = ((PySubscriptionExpression)expression).getOperand();
            PyExpression indexExpression = ((PySubscriptionExpression)expression).getIndexExpression();
            if (indexExpression != null) {
                HtmlChunk htmlChunk = new HtmlBuilder().append(PythonDocumentationProvider.describeSuperClass(operand, context)).append(PyDocSignaturesHighlighterKt.styledSpan("[", PyHighlighter.PY_BRACKETS)).append(PythonDocumentationProvider.describeSuperClass(indexExpression, context)).append(PyDocSignaturesHighlighterKt.styledSpan("]", PyHighlighter.PY_BRACKETS)).toFragment();
                if (htmlChunk == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(44);
                }
                return htmlChunk;
            }
        } else if (expression instanceof PyKeywordArgument) {
            String keyword = ((PyKeywordArgument)expression).getKeyword();
            PyExpression valueExpression = ((PyKeywordArgument)expression).getValueExpression();
            if ("metaclass".equals(keyword) && valueExpression != null) {
                HtmlChunk htmlChunk = new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan("metaclass", PyHighlighter.PY_KEYWORD_ARGUMENT)).append(PyDocSignaturesHighlighterKt.styledSpan("=", PyHighlighter.PY_OPERATION_SIGN)).append(PythonDocumentationProvider.describeSuperClass(valueExpression, context)).toFragment();
                if (htmlChunk == null) {
                    PythonDocumentationProvider.$$$reportNull$$$0(45);
                }
                return htmlChunk;
            }
        } else if (PyClassImpl.isSixWithMetaclassCall(expression) && (callee = (callExpression = (PyCallExpression)expression).getCallee()) != null) {
            HtmlChunk htmlChunk = new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan(callee.getText(), DefaultLanguageHighlighterColors.IDENTIFIER)).append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS)).append((HtmlChunk)StreamEx.of((Object[])callExpression.getArguments()).map(argument -> PythonDocumentationProvider.describeSuperClass(argument, context)).collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA)))).append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS)).toFragment();
            if (htmlChunk == null) {
                PythonDocumentationProvider.$$$reportNull$$$0(46);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = HtmlChunk.text((String)expressionText);
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(47);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk describeDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(48);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(PyDocSignaturesHighlighterKt.styledSpan("@" + PyUtil.getReadableRepr((PsiElement)decorator.getCallee(), false), PyHighlighter.PY_DECORATOR));
        PyArgumentList argumentList = decorator.getArgumentList();
        if (argumentList != null) {
            result2.append(PyDocSignaturesHighlighterKt.styledSpan("(", PyHighlighter.PY_PARENTHS));
            Object[] argumentsExpressions = argumentList.getArguments();
            HtmlChunk styledArgumentsList = (HtmlChunk)StreamEx.of((Object[])argumentsExpressions).map(argExpression -> {
                if (!(argExpression instanceof PyKeywordArgument)) {
                    return PyDocSignaturesHighlighterKt.highlightExpressionText(argExpression.getText(), argExpression);
                }
                PyKeywordArgument keywordArg = (PyKeywordArgument)argExpression;
                String argName = argExpression.getName();
                if (argName == null) {
                    return null;
                }
                PyExpression argValueExpression = keywordArg.getValueExpression();
                if (argValueExpression == null) {
                    return null;
                }
                return new HtmlBuilder().append(PyDocSignaturesHighlighterKt.styledSpan(argName, PyHighlighter.PY_KEYWORD_ARGUMENT)).append(PyDocSignaturesHighlighterKt.styledSpan("=", PyHighlighter.PY_OPERATION_SIGN)).append(PyDocSignaturesHighlighterKt.highlightExpressionText(argValueExpression.getText(), argValueExpression)).toFragment();
            }).nonNull().collect(HtmlChunk.toFragment((HtmlChunk)PyDocSignaturesHighlighterKt.styledSpan(", ", PyHighlighter.PY_COMMA)));
            result2.append(styledArgumentsList);
            result2.append(PyDocSignaturesHighlighterKt.styledSpan(")", PyHighlighter.PY_PARENTHS));
        }
        HtmlChunk htmlChunk = result2.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(49);
        }
        return htmlChunk;
    }

    @Nls
    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        PythonRuntimeService runtimeService;
        if (element == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(50);
        }
        if ((runtimeService = PythonRuntimeService.getInstance()).isInPydevConsole(element) || originalElement != null && runtimeService.isInPydevConsole(originalElement)) {
            return runtimeService.createPydevDoc(element, originalElement);
        }
        return new PyDocumentationBuilder(element, originalElement).build();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, @NotNull String link, @NotNull PsiElement context) {
        if (link == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(51);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(52);
        }
        return PyDocumentationLink.elementForLink(link, context, TypeEvalContext.userInitiated(context.getProject(), context.getContainingFile()));
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String url = PythonDocumentationProvider.getOnlyUrlFor(element, originalElement);
        return url == null ? null : Collections.singletonList(url);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor2, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor2 == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(53);
        }
        if (file == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (contextElement != null) {
            PyDocStringOwner docstringOwner;
            PsiReference reference;
            PyExpression callee;
            PyExpression expression;
            IElementType elementType = contextElement.getNode().getElementType();
            if (PythonDialectsTokenSetProvider.getInstance().getKeywordTokens().contains(elementType)) {
                return contextElement;
            }
            PsiElement parent = contextElement.getParent();
            if (parent instanceof PyArgumentList && (PyTokenTypes.LPAR == elementType || PyTokenTypes.RPAR == elementType) && (expression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyCallExpression.class)) != null && (callee = expression.getCallee()) != null && (reference = callee.getReference()) != null) {
                return reference.resolve();
            }
            expression = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyExpression.class);
            if (expression != null && DocStringUtil.isDocStringExpression(expression) && (docstringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)contextElement, PyDocStringOwner.class)) != null) {
                return docstringOwner;
            }
        }
        return null;
    }

    @NotNull
    private static HtmlChunk formatTypeWithLinks(@Nullable PyType type2, @Nullable PyTypedElement typeOwner, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        if (anchor == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(55);
        }
        if (context == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(56);
        }
        HtmlBuilder builder = new HtmlBuilder();
        PythonDocumentationProvider.describeTypeWithLinks(type2, typeOwner, context, anchor, builder);
        HtmlChunk htmlChunk = builder.toFragment();
        if (htmlChunk == null) {
            PythonDocumentationProvider.$$$reportNull$$$0(57);
        }
        return htmlChunk;
    }

    @Nullable
    public static QualifiedName getFullQualifiedName(@Nullable PsiElement element) {
        String name2;
        String string = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (name2 = element != null ? element.getText() : null);
        if (name2 != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(element);
            if (owner instanceof PyClass) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath(element, element);
                if (importQName != null) {
                    return QualifiedName.fromDottedString((String)(importQName + "." + owner.getName() + "." + name2));
                }
            } else if (PyUtil.isInitOrNewMethod((PsiElement)owner)) {
                QualifiedName importQName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)owner, element);
                PyClass containingClass = ((PyFunction)owner).getContainingClass();
                if (importQName != null && containingClass != null) {
                    return QualifiedName.fromDottedString((String)(importQName + "." + containingClass.getName() + "." + name2));
                }
            } else if (owner instanceof PyFile) {
                QualifiedName fileQName;
                if (builtinCache.isBuiltin(element)) {
                    return QualifiedName.fromDottedString((String)name2);
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findCanonicalImportPath(element, element)) != null) {
                    return QualifiedName.fromDottedString((String)(fileQName + "." + name2));
                }
            } else if (element instanceof PyFile) {
                return QualifiedNameFinder.findCanonicalImportPath(element, element);
            }
        }
        return null;
    }

    @Nullable
    protected static PsiFileSystemItem getFile(PsiElement element) {
        PsiFileSystemItem file = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        return (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)file);
    }

    @Nullable
    public static PsiNamedElement getNamedElement(@Nullable PsiElement element) {
        Object namedElement = element instanceof PsiNamedElement ? (PsiNamedElement)element : null;
        PyClass containingClass = PyUtil.turnConstructorIntoClass(PyUtil.as(namedElement, PyFunction.class));
        namedElement = containingClass != null ? containingClass : (PsiNamedElement)PyUtil.turnInitIntoDir((PsiElement)namedElement);
        return namedElement;
    }

    @Nullable
    public static String getOnlyUrlFor(PsiElement element, PsiElement originalElement) {
        PsiFileSystemItem file = PythonDocumentationProvider.getFile(element);
        if (file == null) {
            return null;
        }
        Sdk sdk2 = PyBuiltinCache.findSdkForFile(file);
        if (sdk2 == null) {
            return null;
        }
        QualifiedName qName = QualifiedNameFinder.findCanonicalImportPath(element, originalElement);
        if (qName == null) {
            return null;
        }
        PythonDocumentationMap map = PythonDocumentationMap.getInstance();
        String pyVersion = PythonDocumentationProvider.pyVersion(sdk2.getVersionString());
        PsiNamedElement namedElement = PythonDocumentationProvider.getNamedElement(element);
        String url = map.urlFor(qName, namedElement, pyVersion);
        if (url != null) {
            return url;
        }
        for (PythonDocumentationLinkProvider provider : PythonDocumentationLinkProvider.EP_NAME.getExtensionList()) {
            String providerUrl = provider.getExternalDocumentationUrl(element, originalElement);
            if (providerUrl == null) continue;
            return providerUrl;
        }
        return null;
    }

    @Nullable
    public static String pyVersion(@Nullable String versionString) {
        String version2;
        int dot;
        String prefix = "Python ";
        if (versionString != null && versionString.startsWith("Python ") && (dot = (version2 = versionString.substring("Python ".length())).indexOf(46)) > 0) {
            if ((dot = version2.indexOf(46, dot + 1)) > 0) {
                return version2.substring(0, dot);
            }
            return version2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 12, 15, 18, 23, 25, 27, 32, 34, 37, 40, 43, 44, 45, 46, 47, 49, 57 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 42: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasStatement";
                break;
            }
            case 19: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 29: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PythonDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "describeParameter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTypeParameter";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "describeTypeAlias";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "describeFunctionWithTypes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerboseTypeName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDescription";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeModel";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorators";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "describeClass";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "describeSuperClass";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDecorator";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeWithLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "describeFunction";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 57: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "describeTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "describeParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeParameter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeAlias";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "describeFunctionWithTypes";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "describeExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVerboseTypeName";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "describeTypeWithLinks";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDescription";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeModel";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorators";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "describeClass";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "describeSuperClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "describeDecorator";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElementForLink";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeWithLinks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 12, 15, 18, 23, 25, 27, 32, 34, 37, 40, 43, 44, 45, 46, 47, 49, 57 -> new IllegalStateException(string);
        };
    }
}

