/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.requirements.EnvironmentMarkersKt;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsFileType;
import com.jetbrains.python.requirements.RequirementsLanguage;
import com.jetbrains.python.requirements.psi.EditableReq;
import com.jetbrains.python.requirements.psi.Option;
import com.jetbrains.python.requirements.psi.ReferReq;
import com.jetbrains.python.requirements.psi.Requirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/requirements/RequirementsFile;", "Lcom/intellij/extapi/psi/PsiFileBase;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "(Lcom/intellij/psi/FileViewProvider;)V", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "disabledRequirements", "", "Lcom/jetbrains/python/requirements/psi/Requirement;", "enabledRequirements", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "requirements", "toString", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nRequirementsFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequirementsFile.kt\ncom/jetbrains/python/requirements/RequirementsFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n766#2:59\n857#2,2:60\n766#2:62\n857#2,2:63\n*S KotlinDebug\n*F\n+ 1 RequirementsFile.kt\ncom/jetbrains/python/requirements/RequirementsFile\n*L\n45#1:59\n45#1:60,2\n52#1:62\n52#1:63,2\n*E\n"})
public final class RequirementsFile
extends PsiFileBase {
    public RequirementsFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        super(viewProvider, (Language)RequirementsLanguage.Companion.getINSTANCE());
    }

    @NotNull
    public FileType getFileType() {
        return (FileType)RequirementsFileType.Companion.getINSTANCE();
    }

    @NotNull
    public final List<Requirement> requirements() {
        List requirements2 = new ArrayList();
        PsiElement[] psiElementArray = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement child : psiElementArray) {
            if (child instanceof Requirement) {
                requirements2.add(child);
                continue;
            }
            if (!(child instanceof Option)) continue;
            EditableReq editableReq = ((Option)child).getEditableReq();
            ReferReq referReq = ((Option)child).getReferReq();
            if (editableReq != null) {
                requirements2.add(editableReq);
                continue;
            }
            if (referReq == null) continue;
            requirements2.add(referReq);
        }
        return requirements2;
    }

    @Nullable
    public final Sdk getSdk() {
        return PackageUtilsKt.getPythonSdk((PsiFile)this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Requirement> enabledRequirements() {
        void $this$filterTo$iv$iv;
        Sdk sdk2 = this.getSdk();
        if (sdk2 == null) {
            return CollectionsKt.emptyList();
        }
        Sdk sdk3 = sdk2;
        Iterable $this$filter$iv = this.requirements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Requirement it = (Requirement)element$iv$iv;
            boolean bl = false;
            if (!it.enabled(EnvironmentMarkersKt.getPythonInfo(sdk3).getMap())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Requirement> disabledRequirements() {
        void $this$filterTo$iv$iv;
        Sdk sdk2 = this.getSdk();
        if (sdk2 == null) {
            return this.requirements();
        }
        Sdk sdk3 = sdk2;
        Iterable $this$filter$iv = this.requirements();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Requirement it = (Requirement)element$iv$iv;
            boolean bl = false;
            if (!(!it.enabled(EnvironmentMarkersKt.getPythonInfo(sdk3).getMap()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return "Requirements File";
    }
}

