/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyCondaSdkFixKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.target.conda.PyAddCondaToolsKt;
import com.jetbrains.python.sdk.add.v2.PythonInterpreterSelectionMode;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.statistics.InterpreterTarget;
import com.jetbrains.python.statistics.InterpreterType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020*H\u0014J\b\u00101\u001a\u00020*H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010R\u0014\u0010'\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010\u00a8\u00064"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultBaseDir", "getDefaultBaseDir", "()Ljava/lang/String;", "envName", "getEnvName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "languageLevelsField", "Ljavax/swing/JComboBox;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "pathField", "getPathField", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "selectedLanguageLevel", "getSelectedLanguageLevel", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "getStatisticInfo", "Lcom/jetbrains/python/newProject/collector/InterpreterStatisticsInfo;", "layoutComponents", "updatePathField", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyAddNewCondaEnvPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddNewCondaEnvPanel.kt\ncom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,168:1\n1549#2:169\n1620#2,3:170\n37#3,2:173\n*S KotlinDebug\n*F\n+ 1 PyAddNewCondaEnvPanel.kt\ncom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel\n*L\n79#1:169\n79#1:170,3\n81#1:173,2\n*E\n"})
public class PyAddNewCondaEnvPanel
extends PyAddNewEnvPanel {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @NotNull
    private final String envName;
    @NotNull
    private final Icon icon;
    @NotNull
    private final JComboBox<String> languageLevelsField;
    @NotNull
    private final TextFieldWithBrowseButton condaPathField;
    @NotNull
    private final TextFieldWithBrowseButton pathField;
    @NotNull
    private final JBCheckBox makeSharedField;
    @Nullable
    private String newProjectPath;

    /*
     * WARNING - void declaration
     */
    public PyAddNewCondaEnvPanel(@Nullable Project project2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        void $this$_init__u24lambda_u244;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$pathField_u24lambda_u242;
        TextFieldWithBrowseButton $this$condaPathField_u24lambda_u241;
        String path2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        super(PythonInterpreterSelectionMode.BASE_CONDA);
        this.project = project2;
        this.module = module;
        this.existingSdks = existingSdks;
        this.envName = "Conda";
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Anaconda");
        this.icon = icon;
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        Object object = this;
        boolean bl = false;
        String string = path2 = PyCondaPackageService.Companion.getCondaExecutable(null);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$condaPathField_u24lambda_u241.setText(it);
        }
        $this$condaPathField_u24lambda_u241.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        $this$condaPathField_u24lambda_u241.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PyAddNewCondaEnvPanel.access$updatePathField(this.this$0);
            }
        });
        ((PyAddNewCondaEnvPanel)object).condaPathField = textFieldWithBrowseButton;
        $this$condaPathField_u24lambda_u241 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        object = this;
        boolean bl3 = false;
        $this$pathField_u24lambda_u242.addBrowseFolderListener(PyBundle.message("python.sdk.select.location.for.conda.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ((PyAddNewCondaEnvPanel)object).pathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        this.newProjectPath = newProjectPath;
        this.setLayout(new BorderLayout());
        $this$pathField_u24lambda_u242 = PyAddCondaToolsKt.getCondaSupportedLanguages();
        boolean $i$f$map = false;
        path2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguageLevel languageLevel = (LanguageLevel)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl4 = false;
            object.add(it.toPythonVersion());
        }
        List supportedLanguageLevels = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = supportedLanguageLevels;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TextFieldWithBrowseButton $i$f$toTypedArray22 = textFieldWithBrowseButton2 = new ComboBox((Object[])thisCollection$iv.toArray(new String[0]));
        object = this;
        boolean bl5 = false;
        $this$_init__u24lambda_u244.setSelectedItem($this$_init__u24lambda_u244.getItemCount() > 0 ? (String)$this$_init__u24lambda_u244.getItemAt(0) : null);
        ((PyAddNewCondaEnvPanel)object).languageLevelsField = (JComboBox)textFieldWithBrowseButton2;
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.updatePathField();
        this.layoutComponents();
    }

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.new.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final TextFieldWithBrowseButton getPathField() {
        return this.pathField;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.updatePathField();
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.location", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PyBundle.message("sdk.create.venv.conda.dialog.label.python.version", new Object[0]), (JComponent)this.languageLevelsField).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String condaPath = string;
        Project project2 = this.project;
        String string2 = PyBundle.message("python.sdk.creating.conda.environment.title", new Object[0]);
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(condaPath, this, project2, string2){
            final /* synthetic */ String $condaPath;
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;
            {
                this.$condaPath = $condaPath;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = PyCondaPackageManagerImpl.createVirtualEnv(this.$condaPath, this.this$0.getPathField().getText(), PyAddNewCondaEnvPanel.access$getSelectedLanguageLevel(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createVirtualEnv(...)");
                return string;
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        String associatedPath = !shared ? this.getProjectBasePath() : null;
        Sdk sdk2 = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, null, associatedPath, null);
        if (sdk2 == null) {
            return null;
        }
        Sdk sdk3 = sdk2;
        if (!shared) {
            PySdkExtKt.associateWithModule(sdk3, this.module, this.getNewProjectPath());
        }
        PyCondaPackageService.Companion.onCondaEnvCreated(condaPath);
        PySdkExtKt.excludeInnerVirtualEnv(this.project, sdk3);
        PyCondaSdkFixKt.fixPythonCondaSdk(sdk3, PySdkExtKt.getOrCreateAdditionalData(sdk3), condaPath);
        return sdk3;
    }

    @Override
    @Nullable
    public InterpreterStatisticsInfo getStatisticInfo() {
        return new InterpreterStatisticsInfo(InterpreterType.CONDAVENV, InterpreterTarget.LOCAL, false, this.makeSharedField.isSelected(), false, false, null, 96, null);
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DocumentAdapter documentListener2 = new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;
            {
                this.$listener = $listener;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.run();
            }
        };
        this.pathField.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener2);
        this.condaPathField.getTextField().getDocument().addDocumentListener((DocumentListener)documentListener2);
    }

    private final void updatePathField() {
        String string;
        String baseDir;
        Object object = this.getDefaultBaseDir();
        if (object == null) {
            object = baseDir = SystemProperties.getUserHome() + "/.conda/envs";
        }
        if ((string = this.getProjectBasePath()) == null) {
            string = "untitled";
        }
        String string2 = PathUtil.getFileName((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        String dirName = string2;
        this.pathField.setText(FileUtil.toSystemDependentName((String)(baseDir + "/" + dirName)));
    }

    private final String getDefaultBaseDir() {
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String conda = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(conda);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile condaFile = virtualFile;
        VirtualFile virtualFile2 = condaFile.getParent();
        return virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null && (virtualFile2 = virtualFile2.findChild("envs")) != null ? virtualFile2.getPath() : null;
    }

    private final String getProjectBasePath() {
        String string = this.getNewProjectPath();
        if (string == null) {
            Module module = this.module;
            string = module != null ? BasePySdkExtKt.getBasePath(module) : null;
            if (string == null) {
                Project project2 = this.project;
                string = project2 != null ? project2.getBasePath() : null;
            }
        }
        return string;
    }

    private final String getSelectedLanguageLevel() {
        String string = this.languageLevelsField.getItemAt(this.languageLevelsField.getSelectedIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getItemAt(...)");
        return string;
    }

    public static final /* synthetic */ String access$getSelectedLanguageLevel(PyAddNewCondaEnvPanel $this) {
        return $this.getSelectedLanguageLevel();
    }

    public static final /* synthetic */ void access$updatePathField(PyAddNewCondaEnvPanel $this) {
        $this.updatePathField();
    }
}

