/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkPopupFactory;
import com.jetbrains.python.sdk.configuration.PyInterpreterInspectionSuppressor;
import com.jetbrains.python.sdk.configuration.PyPackageRequirementsInspectionSuppressor;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.configuration.TipOfTheDaySuppressor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rJ \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eJ(\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfiguration;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "configureSdkUsingExtension", "", "module", "Lcom/intellij/openapi/module/Module;", "extension", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "supplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/projectRoots/Sdk;", "notifyAboutConfiguredSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "setReadyToUseSdk", "setSdkUsingExtension", "suppressTipAndInspectionsFor", "Lcom/intellij/openapi/Disposable;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyProjectSdkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyProjectSdkConfiguration.kt\ncom/jetbrains/python/sdk/configuration/PyProjectSdkConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class PyProjectSdkConfiguration {
    @NotNull
    public static final PyProjectSdkConfiguration INSTANCE = new PyProjectSdkConfiguration();
    @NotNull
    private static final Logger LOGGER;

    private PyProjectSdkConfiguration() {
    }

    public final void configureSdkUsingExtension(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull Function0<? extends Sdk> supplier) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        Disposable lifetime = this.suppressTipAndInspectionsFor(module, extension);
        Project project2 = module.getProject();
        String string = PySdkBundle.message("python.configuring.interpreter.progress", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(lifetime, module, extension, supplier, project2, string){
            final /* synthetic */ Disposable $lifetime;
            final /* synthetic */ Module $module;
            final /* synthetic */ PyProjectSdkConfigurationExtension $extension;
            final /* synthetic */ Function0<Sdk> $supplier;
            {
                this.$lifetime = $lifetime;
                this.$module = $module;
                this.$extension = $extension;
                this.$supplier = $supplier;
                super($super_call_param$1, $super_call_param$2, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$use$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                Disposable disposable = this.$lifetime;
                Module module = this.$module;
                PyProjectSdkConfigurationExtension pyProjectSdkConfigurationExtension = this.$extension;
                Function0<Sdk> function0 = this.$supplier;
                boolean $i$f$use = false;
                try {
                    void it = $this$use$iv;
                    boolean bl = false;
                    PyProjectSdkConfiguration.INSTANCE.setSdkUsingExtension(module, pyProjectSdkConfigurationExtension, function0);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if ($this$use$iv != null) {
                        Disposer.dispose((Disposable)$this$use$iv);
                    }
                }
            }
        });
    }

    @RequiresBackgroundThread
    public final void setSdkUsingExtension(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension, @NotNull Function0<? extends Sdk> supplier) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            ProgressManager.progress((String)"");
            LOGGER.debug("Configuring sdk with " + extension.getClass().getCanonicalName() + " extension");
            Sdk sdk2 = (Sdk)supplier.invoke();
            if (sdk2 == null) break block0;
            Sdk it = sdk2;
            boolean bl = false;
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            INSTANCE.setReadyToUseSdk(project2, module, it);
        }
    }

    public final void setReadyToUseSdk(@NotNull Project project2, @NotNull Module module, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(module, project2, sdk2){
            final /* synthetic */ Module $module;
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $sdk;
            {
                this.$module = $module;
                this.$project = $project;
                this.$sdk = $sdk;
                super(0);
            }

            public final void invoke() {
                if (this.$module.isDisposed()) {
                    return;
                }
                SdkConfigurationUtil.setDirectoryProjectSdk((Project)this.$project, (Sdk)this.$sdk);
                PySdkExtKt.excludeInnerVirtualEnv(this.$module, this.$sdk);
                PyProjectSdkConfiguration.access$notifyAboutConfiguredSdk(PyProjectSdkConfiguration.INSTANCE, this.$project, this.$module, this.$sdk);
            }
        }), (int)1, null);
    }

    @NotNull
    public final Disposable suppressTipAndInspectionsFor(@NotNull Module module, @NotNull PyProjectSdkConfigurationExtension extension) {
        Disposable it;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Disposable disposable = Disposer.newDisposable((Disposable)PythonPluginDisposable.getInstance(project3), (String)("Configuring sdk using " + extension.getClass().getName() + " extension"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable lifetime = disposable;
        Disposable disposable2 = TipOfTheDaySuppressor.Companion.suppress();
        if (disposable2 != null) {
            it = disposable2;
            boolean bl = false;
            Disposer.register((Disposable)lifetime, (Disposable)it);
        }
        Disposable disposable3 = PyInterpreterInspectionSuppressor.Companion.suppress(project3);
        if (disposable3 != null) {
            it = disposable3;
            boolean bl = false;
            Disposer.register((Disposable)lifetime, (Disposable)it);
        }
        Disposer.register((Disposable)lifetime, (Disposable)new PyPackageRequirementsInspectionSuppressor(module));
        return lifetime;
    }

    private final void notifyAboutConfiguredSdk(Project project2, Module module, Sdk sdk2) {
        Notification notification;
        if (ProjectUtil.isNotificationSilentMode((Project)project2)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("ConfiguredPythonInterpreter");
        Object[] objectArray = new Object[]{sdk2.getName()};
        String string = PyBundle.message("sdk.has.been.configured.as.the.project.interpreter", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Notification $this$notifyAboutConfiguredSdk_u24lambda_u244 = notification = notificationGroup.createNotification(string, NotificationType.INFORMATION);
        boolean bl = false;
        NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)PySdkBundle.message("python.configure.interpreter.action", new Object[0]), () -> PyProjectSdkConfiguration.notifyAboutConfiguredSdk$lambda$4$lambda$3(project2, module));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
        NotificationAction configureSdkAction = notificationAction;
        $this$notifyAboutConfiguredSdk_u24lambda_u244.addAction((AnAction)configureSdkAction);
        $this$notifyAboutConfiguredSdk_u24lambda_u244.notify(project2);
    }

    private static final void notifyAboutConfiguredSdk$lambda$4$lambda$3(Project $project, Module $module) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        PySdkPopupFactory.Companion.createAndShow($project, $module);
    }

    public static final /* synthetic */ void access$notifyAboutConfiguredSdk(PyProjectSdkConfiguration $this, Project project2, Module module, Sdk sdk2) {
        $this.notifyAboutConfiguredSdk(project2, module, sdk2);
    }

    static {
        Logger logger = Logger.getInstance(PyProjectSdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

