/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\b\u0007\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u0004\u0018\u00010\nJ\n\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\u0004H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/sdk/flavors/VirtualEnvReader;", "", "envGetter", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "getEnvGetter", "()Lkotlin/jvm/functions/Function1;", "findInRootDirectory", "", "Ljava/nio/file/Path;", "dir", "names", "", "pattern", "Ljava/util/regex/Pattern;", "findInterpreter", "findLocalInterpreters", "", "root", "findPyenvInterpreters", "findVEnvInterpreters", "getPyenvRootDir", "getPyenvVersionsDir", "getVEnvRootDir", "isPyenvSdk", "", "path", "resolveDir", "env", "dirName", "tryReadLink", "tryResolvePath", "str", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nVirtualEnvReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualEnvReader.kt\ncom/jetbrains/python/sdk/flavors/VirtualEnvReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class VirtualEnvReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, String> envGetter;
    @NotNull
    private static final VirtualEnvReader Instance = new VirtualEnvReader(null, 1, null);

    @JvmOverloads
    public VirtualEnvReader(@NotNull Function1<? super String, String> envGetter) {
        Intrinsics.checkNotNullParameter(envGetter, (String)"envGetter");
        this.envGetter = envGetter;
    }

    public /* synthetic */ VirtualEnvReader(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = (Function1)new Function1<String, String>((Object)Companion){

                @NotNull
                public final String invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((Companion)this.receiver).systemEnvGetter(p0);
                }
            };
        }
        this((Function1<? super String, String>)function1);
    }

    @NotNull
    public final Function1<String, String> getEnvGetter() {
        return this.envGetter;
    }

    @Nullable
    public final Path getVEnvRootDir() {
        return this.resolveDir("WORKON_HOME", ".virtualenvs");
    }

    @NotNull
    public final List<Path> findVEnvInterpreters(@NotNull Set<String> names2, @NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter(names2, (String)"names");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.findLocalInterpreters(this.getVEnvRootDir(), names2, pattern);
    }

    @Nullable
    public final Path getPyenvRootDir() {
        return this.resolveDir("PYENV_ROOT", ".pyenv");
    }

    @NotNull
    public final List<Path> findPyenvInterpreters(@NotNull Set<String> names2, @NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter(names2, (String)"names");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.findLocalInterpreters(this.getPyenvVersionsDir(), names2, pattern);
    }

    @NotNull
    public final List<Path> findLocalInterpreters(@Nullable Path root, @NotNull Set<String> names2, @NotNull Pattern pattern) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(names2, (String)"names");
                Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                if (root == null) break block3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
            }
            return CollectionsKt.emptyList();
        }
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path dir : PathsKt.listDirectoryEntries$default((Path)root, null, (int)1, null)) {
            candidates.addAll(this.findInRootDirectory(dir, names2, pattern));
        }
        return candidates;
    }

    public final boolean isPyenvSdk(@Nullable String path2) {
        CharSequence charSequence = path2;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return this.isPyenvSdk(this.tryResolvePath(path2));
    }

    public final boolean isPyenvSdk(@Nullable Path path2) {
        boolean bl;
        Path real = this.tryReadLink(path2);
        if (real == null) {
            return false;
        }
        Object object = this.getPyenvRootDir();
        if (object != null && (object = NioPathUtil.toCanonicalPath((Path)object)) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = real.startsWith((String)it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final Path getPyenvVersionsDir() {
        Path path2 = this.getPyenvRootDir();
        return path2 != null ? path2.resolve("versions") : null;
    }

    private final Collection<Path> findInRootDirectory(Path dir, Set<String> names2, Pattern pattern) {
        ArrayList<Path> candidates;
        block12: {
            block11: {
                block10: {
                    if (dir == null) break block10;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block11;
                }
                return CollectionsKt.emptyList();
            }
            candidates = new ArrayList<Path>();
            Path bin = dir.resolve("bin");
            Intrinsics.checkNotNull((Object)bin);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(bin, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path2 = this.findInterpreter(bin, names2, pattern);
                if (path2 != null) {
                    Path it = path2;
                    boolean bl = false;
                    candidates.add(it);
                }
            }
            Path scripts = dir.resolve("Scripts");
            Intrinsics.checkNotNull((Object)scripts);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(scripts, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Path path3 = this.findInterpreter(scripts, names2, pattern);
                if (path3 != null) {
                    Path it = path3;
                    boolean bl = false;
                    candidates.add(it);
                }
            }
            if (!candidates.isEmpty()) break block12;
            Path path4 = this.findInterpreter(dir, names2, pattern);
            if (path4 != null) {
                Path it = path4;
                boolean bl = false;
                candidates.add(it);
            }
        }
        return candidates;
    }

    private final Path findInterpreter(Path dir, Set<String> names2, Pattern pattern) {
        for (Path child : PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null)) {
            String name2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(child, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)PathsKt.getName((Path)child).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!names2.contains(name2) && !pattern.matcher(name2).matches()) continue;
            return child;
        }
        return null;
    }

    private final Path resolveDir(String env, String dirName) {
        Path path2;
        String envPath = (String)this.envGetter.invoke((Object)env);
        if (!(((CharSequence)envPath).length() == 0)) {
            v0 = this.tryResolvePath(envPath);
        } else {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            Path path3 = this.tryResolvePath(string);
            v0 = path2 = path3 != null ? path3.resolve(dirName) : null;
        }
        if (path2 != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return path2;
            }
        }
        return null;
    }

    private final Path tryResolvePath(String str) {
        if (PythonSdkUtil.isCustomPythonSdkHomePath(str)) {
            return null;
        }
        try {
            Path path2 = Paths.get(str, new String[0]);
            return path2;
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    private final Path tryReadLink(Path path2) {
        try {
            Path path3 = path2;
            boolean bl = path3 != null ? Files.isSymbolicLink(path3) : false;
            if (bl) {
                return path2.toRealPath(new LinkOption[0]);
            }
            return path2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @JvmOverloads
    public VirtualEnvReader() {
        this(null, 1, null);
    }

    @NotNull
    public static final VirtualEnvReader getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final String systemEnvGetter(@NotNull String name2) {
        return Companion.systemEnvGetter(name2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/sdk/flavors/VirtualEnvReader$Companion;", "", "()V", "Instance", "Lcom/jetbrains/python/sdk/flavors/VirtualEnvReader;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/python/sdk/flavors/VirtualEnvReader;", "systemEnvGetter", "", "name", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VirtualEnvReader getInstance() {
            return Instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final String systemEnvGetter(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            String string = System.getenv(name2);
            if (string == null) {
                string = new String();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

