/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TSeekableFile;
import org.apache.thrift.transport.TStandardFile;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFileTransport
extends TTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TFileTransport.class.getName());
    TailPolicy currentPolicy_ = TailPolicy.NOWAIT;
    protected TSeekableFile inputFile_ = null;
    protected OutputStream outputStream_ = null;
    Event currentEvent_ = null;
    InputStream inputStream_ = null;
    ChunkState cs = null;
    private boolean readOnly_ = false;

    public TailPolicy getTailPolicy() {
        return this.currentPolicy_;
    }

    public TailPolicy setTailPolicy(TailPolicy policy) {
        TailPolicy old = this.currentPolicy_;
        this.currentPolicy_ = policy;
        return old;
    }

    private InputStream createInputStream() throws TTransportException {
        InputStream is;
        try {
            if (this.inputStream_ != null) {
                ((TruncableBufferedInputStream)this.inputStream_).trunc();
                is = this.inputStream_;
            } else {
                is = new TruncableBufferedInputStream(this.inputFile_.getInputStream());
            }
        }
        catch (IOException iox) {
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
        return is;
    }

    private int tailRead(InputStream is, byte[] buf, int off, int len, TailPolicy tp) throws TTransportException {
        int orig_len = len;
        try {
            int retries = 0;
            while (len > 0) {
                int cnt = is.read(buf, off, len);
                if (cnt > 0) {
                    off += cnt;
                    len -= cnt;
                    retries = 0;
                    this.cs.skip(cnt);
                    continue;
                }
                if (cnt == -1) {
                    if (tp.retries_ != -1 && tp.retries_ < ++retries) {
                        return orig_len - len;
                    }
                    if (tp.timeout_ <= 0) continue;
                    try {
                        Thread.sleep(tp.timeout_);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new TTransportException("Unexpected return from InputStream.read = " + cnt);
            }
        }
        catch (IOException iox) {
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
        return orig_len - len;
    }

    private boolean performRecovery() throws TTransportException {
        int numChunks = this.getNumChunks();
        int curChunk = this.cs.getChunkNum();
        if (curChunk >= numChunks - 1) {
            return false;
        }
        this.seekToChunk(curChunk + 1);
        return true;
    }

    private boolean readEvent() throws TTransportException {
        byte[] buf;
        int nread;
        int esize;
        byte[] ebytes = new byte[4];
        do {
            int nrequested;
            if ((nrequested = this.cs.getRemaining()) < 4 && (nread = this.tailRead(this.inputStream_, ebytes, 0, nrequested, this.currentPolicy_)) != nrequested) {
                return false;
            }
            nread = this.tailRead(this.inputStream_, ebytes, 0, 4, this.currentPolicy_);
            if (nread != 4) {
                return false;
            }
            esize = 0;
            for (int i = 3; i >= 0; --i) {
                int val = 0xFF & ebytes[i];
                esize |= val << i * 8;
            }
            if (esize <= this.cs.getRemaining()) continue;
            throw new TTransportException("FileTransport error: bad event size");
        } while (esize == 0);
        if (this.currentEvent_.getSize() < esize) {
            this.currentEvent_ = new Event(new byte[esize]);
        }
        if ((nread = this.tailRead(this.inputStream_, buf = this.currentEvent_.getBuf(), 0, esize, this.currentPolicy_)) != esize) {
            return false;
        }
        this.currentEvent_.setAvailable(esize);
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.inputStream_ != null && (this.readOnly_ || this.outputStream_ != null);
    }

    @Override
    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2);
        }
        try {
            this.inputStream_ = this.createInputStream();
            this.cs = new ChunkState();
            this.currentEvent_ = new Event(new byte[256]);
            if (!this.readOnly_) {
                this.outputStream_ = new BufferedOutputStream(this.inputFile_.getOutputStream());
            }
        }
        catch (IOException iox) {
            throw new TTransportException(1, (Throwable)iox);
        }
    }

    @Override
    public void close() {
        if (this.inputFile_ != null) {
            try {
                this.inputFile_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("WARNING: Error closing input file: " + iox.getMessage());
            }
            this.inputFile_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("WARNING: Error closing output stream: " + iox.getMessage());
            }
            this.outputStream_ = null;
        }
    }

    public TFileTransport(String path2, boolean readOnly) throws IOException {
        this.inputFile_ = new TStandardFile(path2);
        this.readOnly_ = readOnly;
    }

    public TFileTransport(TSeekableFile inputFile, boolean readOnly) {
        this.inputFile_ = inputFile;
        this.readOnly_ = readOnly;
    }

    @Override
    public int readAll(byte[] buf, int off, int len) throws TTransportException {
        int got;
        int ret = 0;
        for (got = 0; got < len; got += ret) {
            ret = this.read(buf, off + got, len - got);
            if (ret < 0) {
                throw new TTransportException("Error in reading from file");
            }
            if (ret != 0) continue;
            throw new TTransportException(4, "End of File reached");
        }
        return got;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before reading");
        }
        if (this.currentEvent_.getRemaining() == 0 && !this.readEvent()) {
            return 0;
        }
        return this.currentEvent_.emit(buf, off, len);
    }

    public int getNumChunks() throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before getNumChunks");
        }
        try {
            long len = this.inputFile_.length();
            if (len == 0L) {
                return 0;
            }
            return (int)(len / (long)this.cs.getChunkSize()) + 1;
        }
        catch (IOException iox) {
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
    }

    public int getCurChunk() throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before getCurChunk");
        }
        return this.cs.getChunkNum();
    }

    public void seekToChunk(int chunk) throws TTransportException {
        boolean seekToEnd;
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before seeking");
        }
        int numChunks = this.getNumChunks();
        if (numChunks == 0) {
            return;
        }
        if (chunk < 0) {
            chunk += numChunks;
        }
        if (chunk < 0) {
            chunk = 0;
        }
        long eofOffset = 0L;
        boolean bl = seekToEnd = chunk >= numChunks;
        if (seekToEnd) {
            --chunk;
            try {
                eofOffset = this.inputFile_.length();
            }
            catch (IOException iox) {
                throw new TTransportException(iox.getMessage(), (Throwable)iox);
            }
        }
        if ((long)(chunk * this.cs.getChunkSize()) != this.cs.getOffset()) {
            try {
                this.inputFile_.seek((long)chunk * (long)this.cs.getChunkSize());
            }
            catch (IOException iox) {
                throw new TTransportException("Seek to chunk " + chunk + " " + iox.getMessage(), (Throwable)iox);
            }
            this.cs.seek((long)chunk * (long)this.cs.getChunkSize());
            this.currentEvent_.setAvailable(0);
            this.inputStream_ = this.createInputStream();
        }
        if (seekToEnd) {
            TailPolicy old = this.setTailPolicy(TailPolicy.WAIT_FOREVER);
            while (this.cs.getOffset() < eofOffset) {
                this.readEvent();
            }
            this.currentEvent_.setAvailable(0);
            this.setTailPolicy(old);
        }
    }

    public void seekToEnd() throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before seeking");
        }
        this.seekToChunk(this.getNumChunks());
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        throw new TTransportException("Not Supported");
    }

    @Override
    public void flush() throws TTransportException {
        throw new TTransportException("Not Supported");
    }

    @Override
    public TConfiguration getConfiguration() {
        return null;
    }

    @Override
    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    @Override
    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }

    public static void main(String[] args2) throws Exception {
        int num_chunks = 10;
        if (args2.length < 1 || args2[0].equals("--help") || args2[0].equals("-h") || args2[0].equals("-?")) {
            TFileTransport.printUsage();
        }
        if (args2.length > 1) {
            try {
                num_chunks = Integer.parseInt(args2[1]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot parse " + args2[1]);
                TFileTransport.printUsage();
            }
        }
        TFileTransport t = new TFileTransport(args2[0], true);
        t.open();
        LOGGER.info("NumChunks=" + t.getNumChunks());
        Random r = new Random();
        for (int j = 0; j < num_chunks; ++j) {
            byte[] buf = new byte[4096];
            int cnum = r.nextInt(t.getNumChunks() - 1);
            LOGGER.info("Reading chunk " + cnum);
            t.seekToChunk(cnum);
            for (int i = 0; i < 4096; ++i) {
                t.read(buf, 0, 4096);
            }
        }
    }

    private static void printUsage() {
        LOGGER.error("Usage: TFileTransport <filename> [num_chunks]");
        LOGGER.error("       (Opens and reads num_chunks chunks from file randomly)");
        System.exit(1);
    }

    public static enum TailPolicy {
        NOWAIT(0, 0),
        WAIT_FOREVER(500, -1);

        public final int timeout_;
        public final int retries_;

        private TailPolicy(int timeout, int retries) {
            this.timeout_ = timeout;
            this.retries_ = retries;
        }
    }

    public static class TruncableBufferedInputStream
    extends BufferedInputStream {
        public void trunc() {
            this.count = 0;
            this.pos = 0;
        }

        public TruncableBufferedInputStream(InputStream in) {
            super(in);
        }

        public TruncableBufferedInputStream(InputStream in, int size) {
            super(in, size);
        }
    }

    public static class ChunkState {
        public static final int DEFAULT_CHUNK_SIZE = 0x1000000;
        private int chunk_size_ = 0x1000000;
        private long offset_ = 0L;

        public ChunkState() {
        }

        public ChunkState(int chunk_size) {
            this.chunk_size_ = chunk_size;
        }

        public void skip(int size) {
            this.offset_ += (long)size;
        }

        public void seek(long offset) {
            this.offset_ = offset;
        }

        public int getChunkSize() {
            return this.chunk_size_;
        }

        public int getChunkNum() {
            return (int)(this.offset_ / (long)this.chunk_size_);
        }

        public int getRemaining() {
            return this.chunk_size_ - (int)(this.offset_ % (long)this.chunk_size_);
        }

        public long getOffset() {
            return this.offset_;
        }
    }

    public static class Event {
        private byte[] buf_;
        private int nread_;
        private int navailable_;

        public Event(byte[] buf) {
            this.buf_ = buf;
            this.navailable_ = 0;
            this.nread_ = 0;
        }

        public byte[] getBuf() {
            return this.buf_;
        }

        public int getSize() {
            return this.buf_.length;
        }

        public void setAvailable(int sz) {
            this.nread_ = 0;
            this.navailable_ = sz;
        }

        public int getRemaining() {
            return this.navailable_ - this.nread_;
        }

        public int emit(byte[] buf, int offset, int ndesired) {
            if (ndesired == 0 || ndesired > this.getRemaining()) {
                ndesired = this.getRemaining();
            }
            if (ndesired <= 0) {
                return ndesired;
            }
            System.arraycopy(this.buf_, this.nread_, buf, offset, ndesired);
            this.nread_ += ndesired;
            return ndesired;
        }
    }
}

