/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitActivity;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitAbortOperationAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;

    public GitCherryPicker(@NotNull Project project) {
        if (project == null) {
            GitCherryPicker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    public void cherryPick(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        ProgressIndicator indicator;
        if (commits2 == null) {
            GitCherryPicker.$$$reportNull$$$0(1);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setIndeterminate(false);
        }
        IntRef cherryPickedCommitsCount = new IntRef(1);
        new GitApplyChangesProcess(this.myProject, commits2, true, GitBundle.message("cherry.pick.name", new Object[0]), GitBundle.message("cherry.pick.applied", new Object[0]), (Function4<? super GitRepository, ? super VcsCommitMetadata, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit, autoCommit, listeners) -> {
            GitCommandResult result2 = this.cherryPickSingleCommit((GitRepository)repository, (VcsCommitMetadata)commit, (boolean)autoCommit, (List<? extends GitLineHandlerListener>)listeners, indicator, cherryPickedCommitsCount.get(), commits2.size());
            cherryPickedCommitsCount.inc();
            return result2;
        }), new GitAbortOperationAction.CherryPick(), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)((Function2)(repository, commit) -> this.createCommitMessage((GitRepository)repository, (VcsFullCommitDetails)commit)), true, (Function2<? super GitRepository, ? super Boolean, Unit>)((Function2)(repository, autoCommit) -> GitCherryPicker.cancelCherryPick(repository, autoCommit)), GitBundle.message("activity.name.cherry.pick", new Object[0]), GitActivity.CherryPick).execute();
    }

    private GitCommandResult cherryPickSingleCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, boolean autoCommit, @NotNull List<? extends GitLineHandlerListener> listeners, @Nullable ProgressIndicator indicator, int alreadyCherryPickedCount, int totalCommitsToCherryPick) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(2);
        }
        if (commit == null) {
            GitCherryPicker.$$$reportNull$$$0(3);
        }
        if (listeners == null) {
            GitCherryPicker.$$$reportNull$$$0(4);
        }
        if (indicator != null) {
            GitCherryPicker.updateCherryPickIndicatorText(indicator, commit, alreadyCherryPickedCount, totalCommitsToCherryPick);
        }
        GitCommandResult result2 = Git.getInstance().cherryPick(repository, ((Hash)commit.getId()).asString(), autoCommit, this.shouldAddSuffix(repository, (Hash)commit.getId()), listeners.toArray(new GitLineHandlerListener[0]));
        if (indicator != null) {
            indicator.setFraction((double)alreadyCherryPickedCount / (double)totalCommitsToCherryPick);
        }
        return result2;
    }

    private static void updateCherryPickIndicatorText(@NotNull ProgressIndicator indicator, @NotNull VcsCommitMetadata commit, int alreadyCherryPickedCount, int totalCommitsToCherryPick) {
        if (indicator == null) {
            GitCherryPicker.$$$reportNull$$$0(5);
        }
        if (commit == null) {
            GitCherryPicker.$$$reportNull$$$0(6);
        }
        if (totalCommitsToCherryPick > 1) {
            indicator.setText(DvcsBundle.message((String)"cherry.picking.process.commit", (Object[])new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30), alreadyCherryPickedCount, totalCommitsToCherryPick}));
        } else {
            indicator.setText(DvcsBundle.message((String)"cherry.picking.process.commit.single", (Object[])new Object[]{StringUtil.trimMiddle((String)commit.getSubject(), (int)30)}));
        }
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        String stdout;
        if (result2 == null) {
            GitCherryPicker.$$$reportNull$$$0(7);
        }
        return (stdout = result2.getOutputAsJoinedString()).contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private String createCommitMessage(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(8);
        }
        if (commit == null) {
            GitCherryPicker.$$$reportNull$$$0(9);
        }
        Object message = commit.getFullMessage();
        if (this.shouldAddSuffix(repository, (Hash)commit.getId())) {
            message = (String)message + String.format("\n\n(cherry picked from commit %s)", ((Hash)commit.getId()).asString());
        }
        String string = message;
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(10);
        }
        return string;
    }

    private boolean shouldAddSuffix(@NotNull GitRepository repository, @NotNull Hash commit) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(11);
        }
        if (commit == null) {
            GitCherryPicker.$$$reportNull$$$0(12);
        }
        return this.mySettings.shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository, commit);
    }

    private static Unit cancelCherryPick(@NotNull GitRepository repository, boolean autoCommit) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(13);
        }
        if (autoCommit) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile;
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(14);
        }
        if ((cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead()).exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitCherryPicker.$$$reportNull$$$0(15);
        }
        return vcsKey;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getActionTitle() {
        String string = DvcsBundle.message((String)"cherry.pick.action.text", (Object[])new Object[0]);
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            GitCherryPicker.$$$reportNull$$$0(17);
        }
        return ContainerUtil.all(roots, r -> this.myRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cherryPickSingleCommit";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateCherryPickIndicatorText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNothingToCommitMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessage";
                break;
            }
            case 10: 
            case 15: 
            case 16: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddSuffix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cancelCherryPick";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeCherryPickHead";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 15, 16 -> new IllegalStateException(string);
        };
    }
}

