/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import git4idea.i18n.GitBundle;
import java.text.ParseException;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitVersion
implements Comparable<GitVersion> {
    public static final GitVersion MIN = SystemInfo.isWindows ? new GitVersion(2, 19, 2, 0) : new GitVersion(2, 17, 0, 0);
    public static final GitVersion NULL = new GitVersion(0, 0, 0, 0, Type.NULL);
    private static final Pattern FORMAT = Pattern.compile("git version (\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(.*)", 2);
    private static final Logger LOG = Logger.getInstance((String)GitVersion.class.getName());
    private final int myMajor;
    private final int myMinor;
    private final int myRevision;
    private final int myPatchLevel;
    @NotNull
    private final Type myType;
    private final int myHashCode;

    public GitVersion(int major, int minor, int revision, int patchLevel, @NotNull Type type) {
        if (type == null) {
            GitVersion.$$$reportNull$$$0(0);
        }
        this.myMajor = major;
        this.myMinor = minor;
        this.myRevision = revision;
        this.myPatchLevel = patchLevel;
        this.myType = type;
        this.myHashCode = Objects.hash(this.myMajor, this.myMinor, this.myRevision, this.myPatchLevel);
    }

    public GitVersion(int major, int minor, int revision, int patchLevel) {
        this(major, minor, revision, patchLevel, Type.UNDEFINED);
    }

    @NotNull
    public static GitVersion parse(@NotNull String output) throws ParseException {
        if (output == null) {
            GitVersion.$$$reportNull$$$0(1);
        }
        return GitVersion.parse(output, null);
    }

    @NotNull
    public static GitVersion parse(@NotNull String output, @Nullable Type type) throws ParseException {
        if (output == null) {
            GitVersion.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            throw new ParseException("Empty git --version output: " + output, 0);
        }
        Matcher m = FORMAT.matcher(output.trim());
        if (!m.matches()) {
            throw new ParseException("Unsupported format of git --version output: " + output, 0);
        }
        int major = GitVersion.getIntGroup(m, 1);
        int minor = GitVersion.getIntGroup(m, 2);
        int rev = GitVersion.getIntGroup(m, 3);
        int patch = GitVersion.getIntGroup(m, 4);
        if (type == null) {
            String suffix;
            type = SystemInfo.isWindows ? (StringUtil.toLowerCase((String)(suffix = GitVersion.getStringGroup(m, 5))).contains("msysgit") || StringUtil.toLowerCase((String)suffix).contains("windows") ? Type.MSYS : Type.CYGWIN) : Type.UNIX;
        }
        return new GitVersion(major, minor, rev, patch, type);
    }

    private static int getIntGroup(@NotNull Matcher matcher, int group) {
        if (matcher == null) {
            GitVersion.$$$reportNull$$$0(3);
        }
        if (group > matcher.groupCount() + 1) {
            return 0;
        }
        String match2 = matcher.group(group);
        if (match2 == null) {
            return 0;
        }
        return Integer.parseInt(match2);
    }

    @NotNull
    private static String getStringGroup(@NotNull Matcher matcher, int group) {
        if (matcher == null) {
            GitVersion.$$$reportNull$$$0(4);
        }
        if (group > matcher.groupCount() + 1) {
            return "";
        }
        String match2 = matcher.group(group);
        if (match2 == null) {
            return "";
        }
        String string = match2.trim();
        if (string == null) {
            GitVersion.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static GitVersion identifyVersion(@NotNull String gitExecutable) throws TimeoutException, ExecutionException, ParseException {
        ProcessOutput result2;
        if (gitExecutable == null) {
            GitVersion.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(gitExecutable);
        commandLine.addParameter("--version");
        commandLine.setCharset(CharsetToolkit.getDefaultSystemCharset());
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProcessOutput processOutput = result2 = indicator == null ? handler.runProcess(ExecutableValidator.TIMEOUT_MS) : handler.runProcessWithProgressIndicator(indicator);
        if (result2.isTimeout()) {
            throw new TimeoutException("Couldn't identify the version of Git - stopped by timeout.");
        }
        if (result2.isCancelled()) {
            LOG.info("Cancelled by user. exitCode=" + result2.getExitCode());
            throw new ProcessCanceledException();
        }
        if (result2.getExitCode() != 0 || !result2.getStderr().isEmpty()) {
            LOG.info("getVersion exitCode=" + result2.getExitCode() + " errors: " + result2.getStderr());
            try {
                GitVersion.parse(result2.getStdout());
            }
            catch (ParseException pe) {
                throw new ExecutionException(GitBundle.message("error.git.version.check.failed", result2.getExitCode(), result2.getStderr()), (Throwable)pe);
            }
        }
        return GitVersion.parse(result2.getStdout());
    }

    public boolean isSupported() {
        Type type = this.getType();
        return type != Type.NULL && (Registry.is((String)"git.allow.wsl1.executables") || type != Type.WSL1) && this.compareTo(MIN) >= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitVersion)) {
            return false;
        }
        GitVersion other = (GitVersion)obj;
        if (this.compareTo(other) != 0) {
            return false;
        }
        if (this.myType == Type.UNDEFINED || other.myType == Type.UNDEFINED) {
            return true;
        }
        return this.myType == other.myType;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    public int compareTo(@NotNull GitVersion o) {
        if (o == null) {
            GitVersion.$$$reportNull$$$0(7);
        }
        if (o.getType() == Type.NULL) {
            return this.getType() == Type.NULL ? 0 : 1;
        }
        int d = this.myMajor - o.myMajor;
        if (d != 0) {
            return d;
        }
        d = this.myMinor - o.myMinor;
        if (d != 0) {
            return d;
        }
        d = this.myRevision - o.myRevision;
        if (d != 0) {
            return d;
        }
        return this.myPatchLevel - o.myPatchLevel;
    }

    @NotNull
    public String getPresentation() {
        String presentation2 = this.myMajor + "." + this.myMinor + "." + this.myRevision;
        if (this.myPatchLevel > 0) {
            presentation2 = presentation2 + "." + this.myPatchLevel;
        }
        String string = presentation2;
        if (string == null) {
            GitVersion.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        return this.myMajor + "." + this.myMinor + "." + this.myRevision + "." + this.myPatchLevel + " (" + this.myType + ")";
    }

    @NotNull
    public String getSemanticPresentation() {
        String presentation2 = this.myMajor + "." + this.myMinor + "." + this.myRevision;
        if (this.myPatchLevel > 0) {
            presentation2 = presentation2 + "." + this.myPatchLevel;
        }
        String string = presentation2 + "-" + this.myType;
        if (string == null) {
            GitVersion.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isOlderOrEqual(GitVersion gitVersion) {
        return gitVersion != null && this.compareTo(gitVersion) <= 0;
    }

    public boolean isLaterOrEqual(GitVersion version) {
        return version != null && this.compareTo(version) >= 0;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            GitVersion.$$$reportNull$$$0(10);
        }
        return type;
    }

    public boolean isNull() {
        return this.getType() == Type.NULL;
    }

    public boolean isWSL() {
        return switch (this.getType()) {
            case Type.WSL1, Type.WSL2 -> true;
            default -> false;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitExecutable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSemanticPresentation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntGroup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringGroup";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        UNIX,
        MSYS,
        CYGWIN,
        WSL1,
        WSL2,
        UNDEFINED,
        NULL;

    }
}

