/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GitInteractiveRebaseFile {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final File myFile;

    GitInteractiveRebaseFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull File file2) {
        if (project == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myFile = file2;
    }

    @NotNull
    public List<GitRebaseEntry> load() throws IOException, NoopException, VcsException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList<GitRebaseEntry> entries = new ArrayList<GitRebaseEntry>();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)this.myFile, (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || this.isComment(s)) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String command = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            GitRebaseEntry.Action action = GitRebaseEntry.parseAction(command);
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        ArrayList<GitRebaseEntry> arrayList = entries;
        if (arrayList == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private boolean isComment(@NotNull StringScanner s) {
        if (s == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(4);
        }
        String commentChar = GitVersionSpecialty.KNOWS_CORE_COMMENT_CHAR.existsIn(this.myProject) ? "\u0001" : "#";
        return s.startsWith(commentChar);
    }

    public void cancel() throws IOException {
        try (PrintWriter out = new PrintWriter(new FileWriter(this.myFile));){
            out.println("# rebase is cancelled");
        }
    }

    public void save(@NotNull List<? extends GitRebaseEntry> entries) throws IOException {
        if (entries == null) {
            GitInteractiveRebaseFile.$$$reportNull$$$0(5);
        }
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));){
            boolean knowsDropAction = GitVersionSpecialty.KNOWS_REBASE_DROP_ACTION.existsIn(this.myProject);
            for (GitRebaseEntry gitRebaseEntry : entries) {
                if (gitRebaseEntry.getAction() == GitRebaseEntry.Action.DROP.INSTANCE && !knowsDropAction) continue;
                out.println(gitRebaseEntry);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitInteractiveRebaseFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitInteractiveRebaseFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

