/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;

public class ConsoleProcessListChildProcessMain {
    static final String PREFIX = "Process list count: ";
    static final String SUFFIX = " attached to the console";

    public static void main(String[] args) {
        int pid;
        if (args.length != 1) {
            System.err.println("single argument expected: pid");
            return;
        }
        try {
            pid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.err.println("Cannot parse pid from " + args[0]);
            return;
        }
        if (!Kernel32.INSTANCE.FreeConsole()) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("FreeConsole"));
            return;
        }
        if (!Kernel32.INSTANCE.AttachConsole(pid)) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("AttachConsole"));
            return;
        }
        int MAX_COUNT = 64;
        Memory buffer = new Memory((long)(4 * MAX_COUNT));
        WinDef.DWORD result2 = MyConsoleLibrary.INSTANCE.GetConsoleProcessList((Pointer)buffer, new WinDef.DWORD((long)MAX_COUNT));
        int count = result2.intValue();
        if (count == 0) {
            System.err.println(LastErrorExceptionEx.getErrorMessage("GetConsoleProcessList"));
            return;
        }
        System.out.println(PREFIX + count + SUFFIX);
    }

    private static interface MyConsoleLibrary
    extends Library {
        public static final MyConsoleLibrary INSTANCE = (MyConsoleLibrary)Native.load((String)"kernel32", MyConsoleLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.DWORD GetConsoleProcessList(Pointer var1, WinDef.DWORD var2);
    }
}

