/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.text.TextRange;
import ai.grazie.utils.CollectionsKt;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieAddExceptionQuickFix;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieCustomFixWrapper;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieRuleSettingsAction;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.ExternalTextChecker;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.SuppressionPattern;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150%H\u0002J(\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00062\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020'0+J!\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020/\u00a2\u0006\u0002\u00100J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020/0\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u001cJ\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00065"}, d2={"Lcom/intellij/grazie/text/CheckerRunner;", "", "text", "Lcom/intellij/grazie/text/TextContent;", "(Lcom/intellij/grazie/text/TextContent;)V", "sentences", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "getSentences", "()Ljava/util/List;", "sentences$delegate", "Lkotlin/Lazy;", "getText", "()Lcom/intellij/grazie/text/TextContent;", "tokenizer", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "defaultSuppressionPattern", "Lcom/intellij/grazie/text/SuppressionPattern;", "problem", "Lcom/intellij/grazie/text/TextProblem;", "sentenceText", "", "fileHighlightRanges", "Lcom/intellij/openapi/util/TextRange;", "findSentence", "hasIgnoredCategory", "", "highlightSpan", "ignoredRules", "Lcom/intellij/grazie/text/RuleGroup;", "descriptor", "isIgnoredByStrategies", "isSuppressed", "processProblem", "filtered", "", "run", "", "checkers", "Lcom/intellij/grazie/text/TextChecker;", "consumer", "Lkotlin/Function1;", "toFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInspection/ProblemDescriptor;", "(Lcom/intellij/grazie/text/TextProblem;Lcom/intellij/codeInspection/ProblemDescriptor;)[Lcom/intellij/codeInspection/LocalQuickFix;", "toProblemDescriptors", "isOnTheFly", "tokenize", "GrazieProblemDescriptor", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCheckerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerRunner.kt\ncom/intellij/grazie/text/CheckerRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,235:1\n1549#2:236\n1620#2,3:237\n2624#2,2:240\n1747#2,3:242\n2626#2:245\n1549#2:246\n1620#2,3:247\n1747#2,3:251\n1549#2:254\n1620#2,3:255\n1864#2,3:258\n1#3:250\n37#4,2:261\n*S KotlinDebug\n*F\n+ 1 CheckerRunner.kt\ncom/intellij/grazie/text/CheckerRunner\n*L\n49#1:236\n49#1:237,3\n91#1:240,2\n91#1:242,3\n91#1:245\n102#1:246\n102#1:247,3\n187#1:251,3\n194#1:254\n194#1:255,3\n201#1:258,3\n210#1:261,2\n*E\n"})
public final class CheckerRunner {
    @NotNull
    private final TextContent text;
    @NotNull
    private final Lazy sentences$delegate;

    public CheckerRunner(@NotNull TextContent text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        this.sentences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Tokenizer.Token>>(this){
            final /* synthetic */ CheckerRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Tokenizer.Token> invoke() {
                return CheckerRunner.access$tokenize(this.this$0, this.this$0.getText());
            }
        }));
    }

    @NotNull
    public final TextContent getText() {
        return this.text;
    }

    private final StandardSentenceTokenizer getTokenizer() {
        return StandardSentenceTokenizer.Companion.getDefault();
    }

    private final List<Tokenizer.Token> getSentences() {
        Lazy lazy = this.sentences$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tokenizer.Token> tokenize(TextContent text2) {
        void $this$mapTo$iv$iv;
        String string2 = ((Object)text2).toString();
        StringUtil.BombedCharSequence sequence2 = new StringUtil.BombedCharSequence(string2){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        List<TextRange> ranges = this.getTokenizer().tokenRanges((CharSequence)sequence2);
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(((Object)((CharSequence)text2).subSequence(it.getStart(), it.getEndExclusive())).toString(), new IntRange(it.getStart(), it.getEndExclusive())));
        }
        return (List)destination$iv$iv;
    }

    public final void run(@NotNull List<? extends TextChecker> checkers, @NotNull Function1<? super TextProblem, Unit> consumer) {
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(checkers, this, consumer, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ CheckerRunner this$0;
            final /* synthetic */ Function1<TextProblem, Unit> $consumer;
            {
                this.$checkers = $checkers;
                this.this$0 = $receiver;
                this.$consumer = $consumer;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlockingCancellable = (CoroutineScope)this.L$0;
                        var4_4 = this.$checkers;
                        var5_5 = this.this$0;
                        $i$f$map = false;
                        var7_8 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_13 = (TextChecker)item$iv$iv;
                            var14_15 = destination$iv$iv;
                            $i$a$-map-CheckerRunner$run$1$deferred$1 = false;
                            var14_15.add(checker instanceof ExternalTextChecker ? BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends TextProblem>>, Object>((TextChecker)checker, (CheckerRunner)var5_5, null){
                                int label;
                                final /* synthetic */ TextChecker $checker;
                                final /* synthetic */ CheckerRunner this$0;
                                {
                                    this.$checker = $checker;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = ((ExternalTextChecker)this.$checker).checkExternally(this.this$0.getText(), (Continuation<? super Collection<? extends TextProblem>>)((Continuation)this));
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Collection<? extends TextProblem>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null) : BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends TextProblem>>, Object>((TextChecker)checker, (CheckerRunner)var5_5, null){
                                int label;
                                final /* synthetic */ TextChecker $checker;
                                final /* synthetic */ CheckerRunner this$0;
                                {
                                    this.$checker = $checker;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Collection<? extends TextProblem>>(this.$checker, this.this$0){
                                                final /* synthetic */ TextChecker $checker;
                                                final /* synthetic */ CheckerRunner this$0;
                                                {
                                                    this.$checker = $checker;
                                                    this.this$0 = $receiver;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final Collection<? extends TextProblem> invoke() {
                                                    return this.$checker.check(this.this$0.getText());
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Collection<? extends TextProblem>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null));
                        }
                        deferred = (List)destination$iv$iv;
                        BuildersKt.launch$default((CoroutineScope)$this$runBlockingCancellable, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends Deferred<? extends Collection<? extends TextProblem>>>)deferred, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ List<Deferred<Collection<TextProblem>>> $deferred;
                            {
                                this.$deferred = $deferred;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = this.$deferred.iterator();
lbl6:
                                        // 2 sources

                                        while (var2_3.hasNext()) {
                                            job = (Deferred)var2_3.next();
                                            this.L$0 = var2_3;
                                            this.L$1 = job;
                                            this.label = 1;
                                            v0 = YieldKt.yield((Continuation)((Continuation)this));
                                            if (v0 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl21
                                        }
                                        break;
                                    }
                                    case 1: {
                                        job = (Deferred)this.L$1;
                                        var2_3 = (Iterator)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl21:
                                        // 2 sources

                                        job.start();
                                        ** GOTO lbl6
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        filtered = new ArrayList<E>();
                        var5_5 = deferred.iterator();
lbl24:
                        // 3 sources

                        while (var5_5.hasNext()) {
                            job = (Deferred)var5_5.next();
                            this.L$0 = filtered;
                            this.L$1 = var5_5;
                            this.label = 1;
                            v0 = job.await((Continuation)this);
                            if (v0 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl39
                        }
                        break;
                    }
                    case 1: {
                        var5_5 = (Iterator)this.L$1;
                        filtered = (ArrayList<E>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl39:
                        // 2 sources

                        problems = (Collection)v0;
                        this.L$0 = filtered;
                        this.L$1 = var5_5;
                        this.label = 2;
                        v1 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<Unit>((Collection<? extends TextProblem>)problems, this.this$0, (ArrayList<TextProblem>)filtered, this.$consumer){
                            final /* synthetic */ Collection<TextProblem> $problems;
                            final /* synthetic */ CheckerRunner this$0;
                            final /* synthetic */ ArrayList<TextProblem> $filtered;
                            final /* synthetic */ Function1<TextProblem, Unit> $consumer;
                            {
                                this.$problems = $problems;
                                this.this$0 = $receiver;
                                this.$filtered = $filtered;
                                this.$consumer = $consumer;
                                super(0);
                            }

                            public final void invoke() {
                                for (TextProblem problem : this.$problems) {
                                    if (!CheckerRunner.access$processProblem(this.this$0, problem, this.$filtered)) continue;
                                    this.$consumer.invoke((Object)problem);
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 != var15_2) ** GOTO lbl24
                        return var15_2;
                    }
                    case 2: {
                        var5_5 = (Iterator)this.L$1;
                        filtered = (ArrayList)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl24
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final boolean processProblem(TextProblem problem, List<TextProblem> filtered) {
        boolean bl;
        block14: {
            if (!Intrinsics.areEqual((Object)problem.getText(), (Object)this.text)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (this.isSuppressed(problem) || this.hasIgnoredCategory(problem) || this.isIgnoredByStrategies(problem) || ProblemFilter.allIgnoringFilters(problem).findAny().isPresent()) {
                return false;
            }
            Iterable $this$none$iv = filtered;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block13: {
                        TextProblem it = (TextProblem)element$iv;
                        boolean bl3 = false;
                        List<com.intellij.openapi.util.TextRange> list = it.getHighlightRanges();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                boolean bl4;
                                block12: {
                                    com.intellij.openapi.util.TextRange r1 = (com.intellij.openapi.util.TextRange)element$iv2;
                                    boolean bl5 = false;
                                    List<com.intellij.openapi.util.TextRange> list2 = problem.getHighlightRanges();
                                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getHighlightRanges(...)");
                                    Iterable $this$any$iv2 = list2;
                                    boolean $i$f$any2 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv2) {
                                            com.intellij.openapi.util.TextRange r2 = (com.intellij.openapi.util.TextRange)element$iv3;
                                            boolean bl6 = false;
                                            if (!r1.intersects(r2)) continue;
                                            bl4 = true;
                                            break block12;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block13;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            filtered.add(problem);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProblemDescriptor> toProblemDescriptors(@NotNull TextProblem problem, boolean isOnTheFly) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        PsiElement psiElement = this.text.getCommonParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getCommonParent(...)");
        PsiElement parent = psiElement;
        String string2 = problem.getTooltipTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTooltipTemplate(...)");
        String tooltip = string2;
        String string3 = problem.getDescriptionTemplate(isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDescriptionTemplate(...)");
        String description = string3;
        Iterable $this$map$iv = this.fileHighlightRanges(problem);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void range;
            com.intellij.openapi.util.TextRange textRange = (com.intellij.openapi.util.TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GrazieProblemDescriptor descriptor2 = new GrazieProblemDescriptor(parent, description, range.shiftLeft(UtilsKt.getStartOffset((PsiElement)parent)), isOnTheFly, tooltip);
            if (isOnTheFly) {
                descriptor2.setQuickFixes(this.toFixes(problem, (ProblemDescriptor)descriptor2));
            }
            collection.add(descriptor2);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isIgnoredByStrategies(TextProblem descriptor2) {
        PsiElement psiElement = this.text.findPsiElementAt(0);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findPsiElementAt(...)");
        for (PsiElement root : PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true)) {
            for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(root.getLanguage())) {
                com.intellij.openapi.util.TextRange patternRange;
                com.intellij.openapi.util.TextRange errorRange;
                if (!strategy.isMyContextRoot(root)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)this.text.textRangeToFile(this.highlightSpan(descriptor2)).shiftLeft(UtilsKt.getStartOffset((PsiElement)root)), (String)"shiftLeft(...)");
                com.intellij.openapi.util.TextRange textRange = descriptor2.getPatternRange();
                if (textRange == null) {
                    textRange = this.highlightSpan(descriptor2);
                }
                Intrinsics.checkNotNullExpressionValue((Object)this.text.textRangeToFile(textRange).shiftLeft(UtilsKt.getStartOffset((PsiElement)root)), (String)"shiftLeft(...)");
                IntRange typoRange = RangesKt.until((int)errorRange.getStartOffset(), (int)errorRange.getEndOffset());
                IntRange ruleRange = RangesKt.until((int)patternRange.getStartOffset(), (int)patternRange.getEndOffset());
                PsiElement psiElement2 = this.text.getCommonParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getCommonParent(...)");
                if (strategy.isTypoAccepted(psiElement2, strategy.getRootsChain(root), typoRange, ruleRange) && strategy.isTypoAccepted(root, typoRange, ruleRange)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean hasIgnoredCategory(TextProblem problem) {
        RuleGroup ignored = this.ignoredRules(problem);
        return !((Collection)ignored.getRules()).isEmpty() && problem.fitsGroup(ignored);
    }

    private final RuleGroup ignoredRules(TextProblem descriptor2) {
        List<com.intellij.openapi.util.TextRange> list = descriptor2.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        LinkedHashSet<PsiElement> leaves2 = CollectionsKt.toLinkedSet(SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list), (Function1)ignoredRules.leaves.1.INSTANCE), (Function1)((Function1)new Function1<Integer, PsiElement>(this){
            final /* synthetic */ CheckerRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PsiElement invoke(int it) {
                return this.this$0.getText().findPsiElementAt(it);
            }
        })));
        LinkedHashSet ignored = new LinkedHashSet();
        for (PsiElement leaf : leaves2) {
            Intrinsics.checkNotNull((Object)leaf);
            for (PsiElement root : PsiTreeUtilKt.parents((PsiElement)leaf, (boolean)true)) {
                block2: for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(root.getLanguage())) {
                    for (PsiElement child : PsiTreeUtilKt.parents((PsiElement)leaf, (boolean)true)) {
                        com.intellij.grazie.grammar.strategy.impl.RuleGroup group = strategy.getIgnoredRuleGroup(root, child);
                        if (group != null) {
                            ignored.addAll(group.getRules());
                        }
                        if (!Intrinsics.areEqual((Object)child, (Object)root)) continue;
                        continue block2;
                    }
                }
            }
        }
        return new RuleGroup(ignored);
    }

    private final boolean isSuppressed(TextProblem problem) {
        String sentence = this.findSentence(problem);
        if (this.defaultSuppressionPattern(problem, sentence).isSuppressed()) {
            return true;
        }
        com.intellij.openapi.util.TextRange patternRange = problem.getPatternRange();
        CharSequence charSequence = this.highlightSpan(problem).subSequence((CharSequence)this.text);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        CharSequence errorText = charSequence;
        return patternRange != null && sentence != null && new SuppressionPattern(errorText, sentence).isSuppressed();
    }

    @ApiStatus.Experimental
    @Nullable
    public final String findSentence(@NotNull TextProblem problem) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Iterable iterable = this.getSentences();
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    Tokenizer.Token it = (Tokenizer.Token)t;
                    boolean bl2 = false;
                    List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            com.intellij.openapi.util.TextRange range = (com.intellij.openapi.util.TextRange)element$iv;
                            boolean bl3 = false;
                            if (!range.intersects(it.getRange().getFirst(), it.getRange().getLast() + 1)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Tokenizer.Token token = v2;
        return token != null ? token.getToken() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LocalQuickFix[] toFixes(@NotNull TextProblem problem, @NotNull ProblemDescriptor descriptor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiFile psiFile = this.text.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file2 = psiFile;
        ArrayList<Comparable<IntentionAction>> result2 = new ArrayList<Comparable<IntentionAction>>();
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file2.getProject());
        Iterable $this$map$iv = this.fileHighlightRanges(problem);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.intellij.openapi.util.TextRange textRange = (com.intellij.openapi.util.TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(spm.createSmartPsiFileRangePointer(file2, (com.intellij.openapi.util.TextRange)it));
        }
        List underline = (List)destination$iv$iv;
        List<TextProblem.Suggestion> list = problem.getSuggestions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
        if (!((Collection)list).isEmpty()) {
            GrazieFUSCounter.INSTANCE.typoFound(problem);
            result2.addAll((Collection)GrazieReplaceTypoQuickFix.getReplacementFixes(problem, underline));
        }
        List<LocalQuickFix> list2 = problem.getCustomFixes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCustomFixes(...)");
        Object $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator iterator = $this$forEachIndexed$iv.iterator();
        while (iterator.hasNext()) {
            void fix;
            int n;
            Object item$iv$iv;
            Object item$iv = iterator.next();
            if ((n = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (LocalQuickFix)item$iv;
            int index = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)fix);
            result2.add(new GrazieCustomFixWrapper(problem, (LocalQuickFix)fix, descriptor2, index));
        }
        $this$forEachIndexed$iv = this.defaultSuppressionPattern(problem, this.findSentence(problem));
        result2.add(new GrazieAddExceptionQuickFix(underline, problem, (SuppressionPattern)$this$forEachIndexed$iv){
            final /* synthetic */ TextProblem $problem;
            {
                this.$problem = $problem;
                super($super_call_param$1, $underline);
            }

            public void applyFix(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Rule rule = this.$problem.getRule();
                Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"getRule(...)");
                GrazieFUSCounter.INSTANCE.quickFixInvoked(rule, project, "add.exception");
                super.applyFix(project, file2, editor);
            }
        });
        String string2 = problem.getRule().getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        Rule rule = problem.getRule();
        Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"getRule(...)");
        result2.add(new GrazieRuleSettingsAction(string2, rule));
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    private final List<com.intellij.openapi.util.TextRange> fileHighlightRanges(TextProblem problem) {
        List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<com.intellij.openapi.util.TextRange, com.intellij.openapi.util.TextRange>(this){
            final /* synthetic */ CheckerRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final com.intellij.openapi.util.TextRange invoke(com.intellij.openapi.util.TextRange it) {
                return this.this$0.getText().textRangeToFile(it);
            }
        })), (Function1)((Function1)new Function1<com.intellij.openapi.util.TextRange, List<com.intellij.openapi.util.TextRange>>(this){
            final /* synthetic */ CheckerRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<com.intellij.openapi.util.TextRange> invoke(@NotNull com.intellij.openapi.util.TextRange range) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                List<com.intellij.openapi.util.TextRange> list = this.this$0.getText().intersection(range);
                Intrinsics.checkNotNullExpressionValue(list, (String)"intersection(...)");
                return list;
            }
        })), (Function1)fileHighlightRanges.3.INSTANCE));
    }

    @ApiStatus.Experimental
    @NotNull
    public final SuppressionPattern defaultSuppressionPattern(@NotNull TextProblem problem, @Nullable String sentenceText) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        TextContent text2 = textContent;
        com.intellij.openapi.util.TextRange patternRange = problem.getPatternRange();
        if (patternRange != null) {
            CharSequence charSequence = patternRange.subSequence((CharSequence)text2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
            return new SuppressionPattern(charSequence, null);
        }
        CharSequence charSequence = this.highlightSpan(problem).subSequence((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        return new SuppressionPattern(charSequence, sentenceText);
    }

    private final com.intellij.openapi.util.TextRange highlightSpan(TextProblem problem) {
        int n = problem.getHighlightRanges().get(0).getStartOffset();
        List<com.intellij.openapi.util.TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        return new com.intellij.openapi.util.TextRange(n, ((com.intellij.openapi.util.TextRange)kotlin.collections.CollectionsKt.last(list)).getEndOffset());
    }

    public static final /* synthetic */ boolean access$processProblem(CheckerRunner $this, TextProblem problem, List filtered) {
        return $this.processProblem(problem, filtered);
    }

    public static final /* synthetic */ List access$tokenize(CheckerRunner $this, TextContent text2) {
        return $this.tokenize(text2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/grazie/text/CheckerRunner$GrazieProblemDescriptor;", "Lcom/intellij/codeInspection/ProblemDescriptorBase;", "psi", "Lcom/intellij/psi/PsiElement;", "descriptionTemplate", "", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "onTheFly", "", "tooltip", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;ZLjava/lang/String;)V", "quickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "getQuickFixes", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "setQuickFixes", "([Lcom/intellij/codeInspection/LocalQuickFix;)V", "[Lcom/intellij/codeInspection/LocalQuickFix;", "getFixes", "getTooltipTemplate", "intellij.grazie.core"})
    private static final class GrazieProblemDescriptor
    extends ProblemDescriptorBase {
        @NotNull
        private final String tooltip;
        @NotNull
        private LocalQuickFix[] quickFixes;

        public GrazieProblemDescriptor(@NotNull PsiElement psi, @InspectionMessage @NotNull String descriptionTemplate, @Nullable com.intellij.openapi.util.TextRange rangeInElement, boolean onTheFly, @NlsContexts.Tooltip @NotNull String tooltip) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            Intrinsics.checkNotNullParameter((Object)descriptionTemplate, (String)"descriptionTemplate");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            super(psi, psi, descriptionTemplate, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, rangeInElement, true, onTheFly);
            this.tooltip = tooltip;
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            this.quickFixes = LocalQuickFix.EMPTY_ARRAY;
        }

        @NotNull
        public final LocalQuickFix[] getQuickFixes() {
            return this.quickFixes;
        }

        public final void setQuickFixes(@NotNull LocalQuickFix[] localQuickFixArray) {
            Intrinsics.checkNotNullParameter((Object)localQuickFixArray, (String)"<set-?>");
            this.quickFixes = localQuickFixArray;
        }

        @NotNull
        public LocalQuickFix[] getFixes() {
            return this.quickFixes;
        }

        @NotNull
        public String getTooltipTemplate() {
            return this.tooltip;
        }
    }
}

