/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.AmericanReplaceRule;
import org.languagetool.rules.en.MorfologikAmericanSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleUS;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.SymSpellRule;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;

public class AmericanEnglish
extends English {
    @Override
    public String[] getCountries() {
        return new String[]{"US"};
    }

    @Override
    public String getName() {
        return "English (US)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules2 = new ArrayList<Rule>(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules2.add(new AmericanReplaceRule(messages, "/en/en-US/replace.txt"));
        rules2.add(new UnitConversionRuleUS(messages));
        return rules2;
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikAmericanSpellerRule(messages, this, null, Collections.emptyList());
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules2 = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, lm, globalConfig, userConfig, motherTongue, altLanguages));
        if (SuggestionsChanges.isRunningExperiment("SymSpell") || SuggestionsChanges.isRunningExperiment("SymSpell+NewSuggestionsOrderer")) {
            rules2.add(new SymSpellRule(messages, this, userConfig, altLanguages, lm));
        } else {
            rules2.add(new MorfologikAmericanSpellerRule(messages, this, globalConfig, userConfig, altLanguages, lm, motherTongue));
        }
        return rules2;
    }
}

