/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.rules.UnsyncStack;
import org.languagetool.tools.Tools;

public class EnglishUnpairedBracketsRule
extends GenericUnpairedBracketsRule {
    private static final Pattern INCH_PATTERN = Pattern.compile(".*\\d\".*", 32);
    private static final List<String> EN_START_SYMBOLS = Arrays.asList("[", "(", "{", "\u201c", "\"", "'", "\u2018");
    private static final List<String> EN_END_SYMBOLS = Arrays.asList("]", ")", "}", "\u201d", "\"", "'", "\u2019");

    public EnglishUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages, EN_START_SYMBOLS, EN_END_SYMBOLS);
        this.setUrl(Tools.getUrl("https://languagetool.org/insights/post/punctuation-guide/#what-are-parentheses"));
        this.addExamplePair(Example.wrong("\"I'm over here,<marker></marker> she said."), Example.fixed("\"I'm over here,<marker>\"</marker> she said."));
    }

    @Override
    public String getId() {
        return "EN_UNPAIRED_BRACKETS";
    }

    @Override
    protected boolean preventMatch(AnalyzedSentence sentence) {
        String text2 = sentence.getText();
        Matcher inchMatcher = INCH_PATTERN.matcher(text2);
        return inchMatcher.matches();
    }

    @Override
    protected boolean isNoException(String tokenStr, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace, UnsyncStack<SymbolLocator> symbolStack) {
        boolean superException;
        if (tokens[i].hasPosTag("_apostrophe_contraction_") || tokens[i].hasPosTag("POS")) {
            return false;
        }
        if (i <= 1) {
            return true;
        }
        boolean bl = superException = !super.isNoException(tokenStr, tokens, i, j, precSpace, follSpace, symbolStack);
        if (superException) {
            return false;
        }
        if ((!precSpace && follSpace || tokens[i].isSentenceEnd()) && "\"".equals(tokenStr) && !symbolStack.empty() && "\"".equals(symbolStack.peek().getSymbol())) {
            return true;
        }
        return true;
    }
}

