/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker;

import com.intellij.packageChecker.PackageCheckerIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Severity;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u00a8\u0006\f"}, d2={"matchCoordinates", "", "it", "Lorg/jetbrains/security/package/Package;", "severityIcon", "Ljavax/swing/Icon;", "severity", "Lorg/jetbrains/security/problems/vulnerabilities/Severity;", "severityTreeIcon", "transitiveSeverityTreeIcon", "getReference", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "intellij.packageChecker"})
public final class PackageUtilKt {
    @NotNull
    public static final Icon severityIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.Severity.Lowall;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.Severity.Medall;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.Severity.Highall;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon severityTreeIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.Severity.Lowall_tree;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall_tree");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.Severity.Medall_tree;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall_tree");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.Severity.Highall_tree;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall_tree");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final Icon transitiveSeverityTreeIcon(@NotNull Severity severity) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        switch (WhenMappings.$EnumSwitchMapping$0[severity.getType().ordinal()]) {
            case 1: {
                Icon icon2 = PackageCheckerIcons.SeverityEmpty.Lowall_tree_outline;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Lowall_tree_outline");
                break;
            }
            case 2: {
                Icon icon3 = PackageCheckerIcons.SeverityEmpty.Medall_tree_outline;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Medall_tree_outline");
                break;
            }
            case 3: 
            case 4: {
                Icon icon4 = PackageCheckerIcons.SeverityEmpty.Highall_tree_outline;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Highall_tree_outline");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NotNull
    public static final String getReference(@NotNull Vulnerability $this$getReference) {
        Intrinsics.checkNotNullParameter((Object)$this$getReference, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$getReference.getReference())) {
            return "https://advisory.checkmarx.net/advisory/vulnerability/" + $this$getReference.getCve();
        }
        return $this$getReference.getReference();
    }

    @NotNull
    public static final String matchCoordinates(@NotNull Package it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNamespace() + ":" + it.getName();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.Type.values().length];
            try {
                nArray[Severity.Type.Low.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Medium.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.High.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.Type.Critical.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

